/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.j2ee;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.j2ee.EntityBeanCheck;
import com.puppycrawl.tools.checkstyle.checks.j2ee.EntityBeanMethodChecker;
import com.puppycrawl.tools.checkstyle.checks.j2ee.Utils;

public class BeanManagedMethodChecker
extends EntityBeanMethodChecker {
    private boolean mHasEjbFindByPrimaryKey;

    public BeanManagedMethodChecker(EntityBeanCheck aCheck) {
        super(aCheck);
    }

    public void checkMethods(DetailAST aAST) {
        this.mHasEjbFindByPrimaryKey = false;
        super.checkMethods(aAST);
        if (!this.mHasEjbFindByPrimaryKey) {
            DetailAST nameAST = aAST.findFirstToken(58);
            String name = nameAST.getText();
            String arg = "Entity bean '" + name + "'";
            this.log(aAST, "missingmethod.bean", new Object[]{arg, "ejbFindByPrimaryKey"});
        }
    }

    public void checkMethod(DetailAST aMethodAST) {
        super.checkMethod(aMethodAST);
        DetailAST nameAST = aMethodAST.findFirstToken(58);
        String name = nameAST.getText();
        if (name.startsWith("ejbFind")) {
            if (name.equals("ejbFindByPrimaryKey")) {
                this.mHasEjbFindByPrimaryKey = true;
                DetailAST paramAST = aMethodAST.findFirstToken(20);
                int paramCount = paramAST.getChildCount();
                if (paramCount != 1) {
                    this.logName(aMethodAST, "paramcount.bean", new Object[]{"1"});
                }
            }
            this.checkFindMethod(aMethodAST);
        }
    }

    private void checkFindMethod(DetailAST aMethodAST) {
        super.checkMethod(aMethodAST, false);
        if (Utils.isVoid(aMethodAST)) {
            this.logName(aMethodAST, "voidmethod.bean", new Object[0]);
        }
    }
}

