/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class NormalKindermannRamageGen
extends NormalGen {
    public NormalKindermannRamageGen(RandomStream s, double mu, double sigma) {
        super(s, null);
        this.setParams(mu, sigma);
    }

    public NormalKindermannRamageGen(RandomStream s) {
        this(s, 0.0, 1.0);
    }

    public NormalKindermannRamageGen(RandomStream s, NormalDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getMu(), dist.getSigma());
        }
    }

    public double nextDouble() {
        return NormalKindermannRamageGen.kindermanRamage(this.stream, this.mu, this.sigma);
    }

    public static double nextDouble(RandomStream s, double mu, double sigma) {
        return NormalKindermannRamageGen.kindermanRamage(s, mu, sigma);
    }

    private static double kindermanRamage(RandomStream stream, double mu, double sigma) {
        double X;
        double XI = 2.216035867166471;
        double PIhochK = 0.3989422804;
        double U = stream.nextDouble();
        if (U < 0.884070402298758) {
            double V = stream.nextDouble();
            X = 2.216035867166471 * (1.13113163544418 * U + V - 1.0);
        } else if (U >= 0.973310954173898) {
            double W;
            double t;
            double V;
            while ((V = stream.nextDouble()) * V * (t = (W = stream.nextDouble()) == 0.0 ? 0.0 : 2.455407482284126 - Math.log(W)) > 2.455407482284126) {
            }
            X = U < 0.986655477086949 ? Math.pow(2.0 * t, 0.5) : -Math.pow(2.0 * t, 0.5);
        } else if (U >= 0.958720824790463) {
            double t;
            double z;
            double W;
            double V;
            do {
                V = stream.nextDouble();
                W = stream.nextDouble();
                z = V - W;
                t = 2.216035867166471 - 0.63083480192196 * Math.min(V, W);
            } while (Math.max(V, W) > 0.755591531667601 && 0.034240503750111 * Math.abs(z) > 0.3989422804 * Math.exp(t * t / -2.0) - 0.180025191068563 * (2.216035867166471 - Math.abs(t)));
            X = z < 0.0 ? t : -t;
        } else if (U >= 0.911312780288703) {
            double t;
            double z;
            double W;
            double V;
            do {
                V = stream.nextDouble();
                W = stream.nextDouble();
                z = V - W;
                t = 0.479727404222441 + 1.10547366102207 * Math.min(V, W);
            } while (Math.max(V, W) > 0.87283497667179 && 0.049264496373128 * Math.abs(z) > 0.3989422804 * Math.exp(t * t / -2.0) - 0.180025191068563 * (2.216035867166471 - Math.abs(t)));
            X = z < 0.0 ? t : -t;
        } else {
            double t;
            double z;
            double W;
            double V;
            do {
                V = stream.nextDouble();
                W = stream.nextDouble();
                z = V - W;
                t = 0.479727404222441 - 0.59550713801594 * Math.min(V, W);
                if (!(t < 0.0)) continue;
            } while (Math.max(V, W) > 0.805777924423817 && 0.053377549506886 * Math.abs(z) > 0.3989422804 * Math.exp(t * t / -2.0) - 0.180025191068563 * (2.216035867166471 - Math.abs(t)));
            X = z < 0.0 ? t : -t;
        }
        return mu + sigma * X;
    }
}

