/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.LognormalDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class LognormalGen
extends RandomVariateGen {
    private double mu;
    private double sigma = -1.0;

    public LognormalGen(RandomStream s, double mu, double sigma) {
        this(s, new LognormalDist(mu, sigma));
        this.setParams(mu, sigma);
    }

    public LognormalGen(RandomStream s) {
        this(s, 0.0, 1.0);
    }

    public LognormalGen(RandomStream s, LognormalDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getMu(), dist.getSigma());
        }
    }

    public static double nextDouble(RandomStream s, double mu, double sigma) {
        return LognormalDist.inverseF(mu, sigma, s.nextDouble());
    }

    public double getMu() {
        return this.mu;
    }

    public double getSigma() {
        return this.sigma;
    }

    protected void setParams(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        this.mu = mu;
        this.sigma = sigma;
    }
}

