/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.util.Num;

public class NakagamiDist
extends ContinuousDistribution {
    protected double a;
    protected double lambda;
    protected double c;
    private double factor;
    private double ratio;

    public NakagamiDist(double a, double lambda, double c) {
        this.setParams(a, lambda, c);
    }

    public double density(double x) {
        if (x <= this.a) {
            return 0.0;
        }
        return 2.0 * Math.exp(this.factor + Math.log(x - this.a) * (2.0 * this.c - 1.0) - this.lambda * (x - this.a) * (x - this.a));
    }

    public double cdf(double x) {
        return NakagamiDist.cdf(this.a, this.lambda, this.c, x);
    }

    public double barF(double x) {
        return NakagamiDist.barF(this.a, this.lambda, this.c, x);
    }

    public double inverseF(double u) {
        return NakagamiDist.inverseF(this.a, this.lambda, this.c, u);
    }

    public double getMean() {
        return this.a + this.ratio / Math.sqrt(this.lambda);
    }

    public double getVariance() {
        return (this.c - this.ratio * this.ratio) / this.lambda;
    }

    public double getStandardDeviation() {
        return Math.sqrt(this.getVariance());
    }

    public static double density(double a, double lambda, double c, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (c <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        if (x <= a) {
            return 0.0;
        }
        return 2.0 * Math.exp(Math.log(lambda) * c - Num.lnGamma(c) + Math.log(x - a) * (2.0 * c - 1.0) - lambda * (x - a) * (x - a));
    }

    public static double cdf(double a, double lambda, double c, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (c <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        if (x <= a) {
            return 0.0;
        }
        return GammaDist.cdf(c, 12, lambda * (x - a) * (x - a));
    }

    public static double barF(double a, double lambda, double c, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (c <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        if (x <= a) {
            return 1.0;
        }
        return GammaDist.barF(c, 12, lambda * (x - a) * (x - a));
    }

    public static double inverseF(double a, double lambda, double c, double u) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (c <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u <= 0.0) {
            return a;
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double res = GammaDist.inverseF(c, 12, u);
        return a + Math.sqrt(res / lambda);
    }

    public static double getMean(double a, double lambda, double c) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (c <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        return a + Num.gammaRatioHalf(c) / Math.sqrt(lambda);
    }

    public static double getVariance(double a, double lambda, double c) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (c <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        double rat = Num.gammaRatioHalf(c);
        return (c - rat * rat) / lambda;
    }

    public static double getStandardDeviation(double a, double lambda, double c) {
        return Math.sqrt(NakagamiDist.getVariance(a, lambda, c));
    }

    public double getA() {
        return this.a;
    }

    public double getLambda() {
        return this.lambda;
    }

    public double getC() {
        return this.c;
    }

    public void setParams(double a, double lambda, double c) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (c <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        this.a = a;
        this.lambda = lambda;
        this.c = c;
        this.factor = Math.log(lambda) * c - Num.lnGamma(c);
        this.ratio = Num.gammaRatioHalf(c);
    }

    public double[] getParams() {
        double[] retour = new double[]{this.a, this.lambda, this.c};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : a = " + this.a + ", lambda = " + this.lambda + ", c = " + this.c;
    }
}

