/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.charts;

import cern.colt.list.DoubleArrayList;
import java.awt.Color;
import java.awt.Paint;
import java.util.Formatter;
import java.util.Locale;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import umontreal.iro.lecuyer.charts.SSJXYSeriesCollection;
import umontreal.iro.lecuyer.functionfit.SmoothingCubicSpline;
import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.util.RootFinder;

public class XYListSeriesCollection
extends SSJXYSeriesCollection {
    protected String[] marksType;
    protected String[] dashPattern;
    protected String[] plotStyle;
    private boolean autoCompletion = false;

    public XYListSeriesCollection() {
        this.renderer = new XYLineAndShapeRenderer(true, false);
        this.seriesCollection = new XYSeriesCollection();
    }

    public XYListSeriesCollection(double[][] ... data) {
        int i;
        this.renderer = new XYLineAndShapeRenderer(true, false);
        this.seriesCollection = new XYSeriesCollection();
        XYSeriesCollection tempSeriesCollection = (XYSeriesCollection)this.seriesCollection;
        for (i = 0; i < data.length; ++i) {
            int j;
            if (data[i].length < 2) {
                throw new IllegalArgumentException("Unable to render the plot. data[" + i + "] contains less than two rows");
            }
            for (j = 0; j < data[i].length - 1; ++j) {
                if (data[i][j].length == data[i][j + 1].length) continue;
                throw new IllegalArgumentException("data[" + i + "][" + j + "] and data[" + i + "][" + (j + 1) + "] must share the same length");
            }
            for (j = 1; j < data[i].length; ++j) {
                XYSeries serie = new XYSeries((Comparable)((Object)" "));
                for (int k = 0; k < data[i][0].length; ++k) {
                    serie.add(data[i][0][k], data[i][j][k]);
                }
                tempSeriesCollection.addSeries(serie);
            }
        }
        for (i = 0; i < tempSeriesCollection.getSeriesCount(); ++i) {
            this.renderer.setSeriesPaint(i, (Paint)XYListSeriesCollection.getDefaultColor(i));
        }
        this.plotStyle = new String[tempSeriesCollection.getSeriesCount()];
        this.marksType = new String[tempSeriesCollection.getSeriesCount()];
        this.dashPattern = new String[tempSeriesCollection.getSeriesCount()];
        for (i = 0; i < tempSeriesCollection.getSeriesCount(); ++i) {
            this.marksType[i] = " ";
            this.plotStyle[i] = "smooth";
            this.dashPattern[i] = "solid";
        }
    }

    public XYListSeriesCollection(double[][] data, int numPoints) {
        int i;
        this.renderer = new XYLineAndShapeRenderer(true, false);
        this.seriesCollection = new XYSeriesCollection();
        XYSeriesCollection tempSeriesCollection = (XYSeriesCollection)this.seriesCollection;
        if (data.length < 2) {
            throw new IllegalArgumentException("Unable to render the plot. data contains less than two rows");
        }
        for (int j = 1; j < data.length; ++j) {
            XYSeries serie = new XYSeries((Comparable)((Object)" "));
            for (int k = 0; k < numPoints; ++k) {
                serie.add(data[0][k], data[j][k]);
            }
            tempSeriesCollection.addSeries(serie);
        }
        for (i = 0; i < tempSeriesCollection.getSeriesCount(); ++i) {
            this.renderer.setSeriesPaint(i, (Paint)XYListSeriesCollection.getDefaultColor(i));
        }
        this.plotStyle = new String[tempSeriesCollection.getSeriesCount()];
        this.marksType = new String[tempSeriesCollection.getSeriesCount()];
        this.dashPattern = new String[tempSeriesCollection.getSeriesCount()];
        for (i = 0; i < tempSeriesCollection.getSeriesCount(); ++i) {
            this.marksType[i] = " ";
            this.plotStyle[i] = "smooth";
            this.dashPattern[i] = "solid";
        }
    }

    public XYListSeriesCollection(DoubleArrayList ... data) {
        int i;
        this.renderer = new XYLineAndShapeRenderer(true, false);
        this.seriesCollection = new XYSeriesCollection();
        XYSeriesCollection tempSeriesCollection = (XYSeriesCollection)this.seriesCollection;
        int count = 0;
        for (i = 0; i < data.length; ++i) {
            XYSeries serie = new XYSeries((Comparable)((Object)" "));
            DoubleArrayList temp = data[i].copy();
            temp.trimToSize();
            temp.quickSortFromTo(0, temp.size() - 1);
            double[] elements = temp.elements();
            int j = 0;
            int l = 0;
            while (j < elements.length) {
                while (j < elements.length && elements[j] == elements[l]) {
                    ++j;
                    ++count;
                }
                serie.add(elements[l], (double)count);
                count = 0;
                l = j;
            }
            tempSeriesCollection.addSeries(serie);
        }
        for (i = 0; i < tempSeriesCollection.getSeriesCount(); ++i) {
            this.renderer.setSeriesPaint(i, (Paint)XYListSeriesCollection.getDefaultColor(i));
        }
        this.plotStyle = new String[tempSeriesCollection.getSeriesCount()];
        this.marksType = new String[tempSeriesCollection.getSeriesCount()];
        this.dashPattern = new String[tempSeriesCollection.getSeriesCount()];
        for (i = 0; i < tempSeriesCollection.getSeriesCount(); ++i) {
            this.marksType[i] = " ";
            this.plotStyle[i] = "smooth";
            this.dashPattern[i] = "solid";
        }
    }

    public XYListSeriesCollection(XYSeriesCollection data) {
        int i;
        this.renderer = new XYLineAndShapeRenderer(true, false);
        this.seriesCollection = data;
        for (i = 0; i < data.getSeriesCount(); ++i) {
            XYSeries xYSeries = data.getSeries(i);
        }
        for (i = 0; i < data.getSeriesCount(); ++i) {
            this.renderer.setSeriesPaint(i, (Paint)XYListSeriesCollection.getDefaultColor(i));
        }
        this.plotStyle = new String[data.getSeriesCount()];
        this.marksType = new String[data.getSeriesCount()];
        this.dashPattern = new String[data.getSeriesCount()];
        for (i = 0; i < data.getSeriesCount(); ++i) {
            this.marksType[i] = " ";
            this.plotStyle[i] = "smooth";
            this.dashPattern[i] = "solid";
        }
    }

    public int add(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("x and y must have the same length");
        }
        return this.add(x, y, x.length);
    }

    public int add(double[] x, double[] y, int numPoints) {
        XYSeries serie = new XYSeries((Comparable)((Object)" "));
        XYSeriesCollection tempSeriesCollection = (XYSeriesCollection)this.seriesCollection;
        serie.setNotify(true);
        if (x.length < numPoints || y.length < numPoints) {
            throw new IllegalArgumentException("numPoints > length of x or y");
        }
        for (int i = 0; i < numPoints; ++i) {
            serie.add(x[i], y[i]);
        }
        tempSeriesCollection.addSeries(serie);
        int j = tempSeriesCollection.getSeriesCount() - 1;
        this.renderer.setSeriesPaint(j, (Paint)XYListSeriesCollection.getDefaultColor(j));
        int co = tempSeriesCollection.getSeriesCount();
        String[] newPlotStyle = new String[co];
        String[] newMarksType = new String[co];
        String[] newDashPattern = new String[co];
        for (j = 0; j < co - 1; ++j) {
            newPlotStyle[j] = this.plotStyle[j];
            newMarksType[j] = this.marksType[j];
            newDashPattern[j] = this.dashPattern[j];
        }
        newPlotStyle[j] = "smooth";
        newMarksType[j] = " ";
        newDashPattern[j] = "solid";
        this.plotStyle = newPlotStyle;
        this.marksType = newMarksType;
        this.dashPattern = newDashPattern;
        return tempSeriesCollection.getSeriesCount() - 1;
    }

    public int add(double[][] data) {
        return this.add(data, data[0].length);
    }

    public int add(double[][] data, int numPoints) {
        int j;
        int j2;
        XYSeriesCollection tempSeriesCollection = (XYSeriesCollection)this.seriesCollection;
        int n = tempSeriesCollection.getSeriesCount();
        if (data.length < 2) {
            throw new IllegalArgumentException("Unable to render the plot. data contains less than two rows");
        }
        for (j2 = 0; j2 < data.length; ++j2) {
            if (data[j2].length >= numPoints) continue;
            throw new IllegalArgumentException("data[" + j2 + "] has not enough points");
        }
        for (j2 = 1; j2 < data.length; ++j2) {
            XYSeries serie = new XYSeries((Comparable)((Object)" "));
            serie.setNotify(true);
            for (int k = 0; k < numPoints; ++k) {
                serie.add(data[0][k], data[j2][k]);
            }
            tempSeriesCollection.addSeries(serie);
        }
        for (j2 = n; j2 < tempSeriesCollection.getSeriesCount(); ++j2) {
            this.renderer.setSeriesPaint(j2, (Paint)XYListSeriesCollection.getDefaultColor(j2));
        }
        String[] newPlotStyle = new String[tempSeriesCollection.getSeriesCount()];
        String[] newMarksType = new String[tempSeriesCollection.getSeriesCount()];
        String[] newDashPattern = new String[tempSeriesCollection.getSeriesCount()];
        for (j = 0; j < n; ++j) {
            newPlotStyle[j] = this.plotStyle[j];
            newMarksType[j] = this.marksType[j];
            newDashPattern[j] = this.dashPattern[j];
        }
        for (j = n; j < tempSeriesCollection.getSeriesCount(); ++j) {
            newPlotStyle[j] = "smooth";
            newMarksType[j] = " ";
            newDashPattern[j] = "solid";
        }
        this.plotStyle = newPlotStyle;
        this.marksType = newMarksType;
        this.dashPattern = newDashPattern;
        return tempSeriesCollection.getSeriesCount() - n;
    }

    public int add(DoubleArrayList data) {
        XYSeries serie = new XYSeries((Comparable)((Object)" "));
        DoubleArrayList temp = data.copy();
        XYSeriesCollection tempSeriesCollection = (XYSeriesCollection)this.seriesCollection;
        temp.trimToSize();
        temp.quickSortFromTo(0, temp.size() - 1);
        double[] elements = temp.elements();
        int count = 0;
        int j = 0;
        int l = 0;
        while (j < elements.length) {
            while (j < elements.length && elements[j] == elements[l]) {
                ++j;
                ++count;
            }
            serie.add(elements[l], (double)count);
            count = 0;
            l = j;
        }
        tempSeriesCollection.addSeries(serie);
        j = tempSeriesCollection.getSeriesCount() - 1;
        this.renderer.setSeriesPaint(j, (Paint)XYListSeriesCollection.getDefaultColor(j));
        String[] newPlotStyle = new String[tempSeriesCollection.getSeriesCount()];
        String[] newMarksType = new String[tempSeriesCollection.getSeriesCount()];
        String[] newDashPattern = new String[tempSeriesCollection.getSeriesCount()];
        for (j = 0; j < tempSeriesCollection.getSeriesCount() - 1; ++j) {
            newPlotStyle[j] = this.plotStyle[j];
            newMarksType[j] = this.marksType[j];
            newDashPattern[j] = this.dashPattern[j];
        }
        newPlotStyle[j] = "smooth";
        newMarksType[j] = " ";
        newDashPattern[j] = "solid";
        this.plotStyle = newPlotStyle;
        this.marksType = newMarksType;
        this.dashPattern = newDashPattern;
        return tempSeriesCollection.getSeriesCount() - 1;
    }

    public String getName(int series) {
        return (String)((Object)((XYSeriesCollection)this.seriesCollection).getSeries(series).getKey());
    }

    public void setName(int series, String name) {
        if (name == null) {
            name = " ";
        }
        ((XYSeriesCollection)this.seriesCollection).getSeries(series).setKey((Comparable)((Object)name));
    }

    public void enableAutoCompletion() {
        this.autoCompletion = true;
    }

    public void disableAutoCompletion() {
        this.autoCompletion = false;
    }

    public String getMarksType(int series) {
        return this.marksType[series];
    }

    public void setMarksType(int series, String marksType) {
        this.marksType[series] = marksType;
    }

    public String getDashPattern(int series) {
        return this.dashPattern[series];
    }

    public void setDashPattern(int series, String dashPattern) {
        this.dashPattern[series] = dashPattern;
        if (dashPattern.equals("only marks")) {
            ((XYLineAndShapeRenderer)this.renderer).setSeriesLinesVisible(series, false);
            ((XYLineAndShapeRenderer)this.renderer).setSeriesShapesVisible(series, true);
        } else {
            ((XYLineAndShapeRenderer)this.renderer).setSeriesLinesVisible(series, true);
            ((XYLineAndShapeRenderer)this.renderer).setSeriesShapesVisible(series, false);
        }
    }

    public String getPlotStyle(int series) {
        return this.plotStyle[series];
    }

    public void setPlotStyle(int series, String plotStyle) {
        this.plotStyle[series] = plotStyle;
    }

    public String toLatex(double XScale, double YScale, double XShift, double YShift, double xmin, double xmax, double ymin, double ymax) {
        int i;
        xmin = Math.min(XShift, xmin);
        xmax = Math.max(XShift, xmax);
        ymin = Math.min(YShift, ymin);
        ymax = Math.max(YShift, ymax);
        Formatter formatter = new Formatter(Locale.US);
        XYSeriesCollection tempSeriesCollection = (XYSeriesCollection)this.seriesCollection;
        double XEPSILON = 1.0E-4 / XScale + XShift;
        double YEPSILON = 1.0E-4 / YScale + YShift;
        boolean outOfBounds = false;
        SmoothingCubicSpline[] spline = null;
        double[] xBounds = this.getRangeBounds();
        double[] yBounds = this.getDomainBounds();
        spline = new SmoothingCubicSpline[tempSeriesCollection.getSeriesCount()];
        for (i = 0; i < tempSeriesCollection.getSeriesCount(); ++i) {
            spline[i] = new SmoothingCubicSpline(tempSeriesCollection.getSeries(i).toArray()[0], tempSeriesCollection.getSeries(i).toArray()[1], 1.0);
        }
        for (i = tempSeriesCollection.getSeriesCount() - 1; i >= 0; --i) {
            XYSeries temp = tempSeriesCollection.getSeries(i);
            if (temp.getItemCount() < 2) {
                throw new IllegalArgumentException("Unable to plot series " + i + ": this series must have two points at least");
            }
            Color color = (Color)this.renderer.getSeriesPaint(i);
            String colorString = XYListSeriesCollection.detectXColorClassic(color);
            if (colorString == null) {
                colorString = "color" + i;
                formatter.format("\\definecolor{%s}{rgb}{%.2f, %.2f, %.2f}%n", colorString, (double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0);
            }
            if (temp.getX(0).doubleValue() >= xmin && temp.getX(0).doubleValue() <= xmax && temp.getY(0).doubleValue() >= ymin && temp.getY(0).doubleValue() <= ymax) {
                outOfBounds = false;
                formatter.format("\\draw [%s, color=%s, mark=%s, style=%s] plot coordinates {%%%n", this.plotStyle[i], colorString, this.marksType[i], this.dashPattern[i]);
            } else {
                outOfBounds = true;
                formatter.format("%% ", new Object[0]);
            }
            formatter.format("(%.2f,%.4f)", (temp.getX(0).doubleValue() - XShift) * XScale, (temp.getY(0).doubleValue() - YShift) * YScale);
            formatter.format(" %%   (%f,  %f)%n", temp.getX(0).doubleValue(), temp.getY(0).doubleValue());
            for (int j = 1; j < temp.getItemCount(); ++j) {
                double[] result;
                if (!outOfBounds) {
                    result = XYListSeriesCollection.evalLimitValues(xmin, xmax, ymin, ymax, XEPSILON, YEPSILON, spline[i], temp, j, false);
                    if (result != null) {
                        outOfBounds = true;
                        if (this.autoCompletion) {
                            formatter.format("(%.2f,%.4f) %%%n", (result[0] - XShift) * XScale, (result[1] - YShift) * YScale);
                        }
                        formatter.format("}%%%n%% ", new Object[0]);
                    }
                } else if (temp.getX(j).doubleValue() >= xmin && temp.getX(j).doubleValue() <= xmax && temp.getY(j).doubleValue() >= ymin && temp.getY(j).doubleValue() <= ymax) {
                    result = XYListSeriesCollection.evalLimitValues(xmin, xmax, ymin, ymax, XEPSILON, YEPSILON, spline[i], temp, --j, true);
                    formatter.format(";%%%n\\draw [%s, color=%s, mark=%s, style=%s] plot coordinates {%%%n", this.plotStyle[i], colorString, this.marksType[i], this.dashPattern[i]);
                    if (this.autoCompletion) {
                        formatter.format("(%.2f,%.4f) %%%n ", (result[0] - XShift) * XScale, (result[1] - YShift) * YScale);
                    }
                    formatter.format("%% ", new Object[0]);
                    outOfBounds = false;
                } else {
                    formatter.format("%% ", new Object[0]);
                }
                formatter.format("(%.2f,%.4f)", (temp.getX(j).doubleValue() - XShift) * XScale, (temp.getY(j).doubleValue() - YShift) * YScale);
                if (j == temp.getItemCount() - 1) {
                    formatter.format("}", new Object[0]);
                }
                formatter.format(" %%   (%f,  %f)%n", temp.getX(j).doubleValue(), temp.getY(j).doubleValue());
            }
            formatter.format(" node[right] {%s};%n", (String)((Object)temp.getKey()));
        }
        return formatter.toString();
    }

    private static double[] evalLimitValues(double xmin, double xmax, double ymin, double ymax, double XEPSILON, double YEPSILON, MathFunction spline, XYSeries temp, int numPoint, boolean sens) {
        double y;
        double x;
        int j = numPoint;
        int k = 0;
        k = sens ? j + 1 : j - 1;
        if (temp.getX(j).doubleValue() < xmin) {
            x = xmin;
            y = spline.evaluate(xmin);
            while (y < ymin) {
                y = spline.evaluate(x += XEPSILON);
            }
            while (y > ymax) {
                y = spline.evaluate(x += XEPSILON);
            }
        } else if (temp.getX(j).doubleValue() > xmax) {
            x = xmax;
            y = spline.evaluate(xmax);
            while (y < ymin) {
                y = spline.evaluate(x -= XEPSILON);
            }
            while (y > ymax) {
                y = spline.evaluate(x -= XEPSILON);
            }
        } else if (temp.getY(j).doubleValue() < ymin) {
            y = ymin;
            x = XYListSeriesCollection.evaluateX(spline, y, temp.getX(j).doubleValue(), temp.getX(k).doubleValue());
            while (x < xmin) {
                x = XYListSeriesCollection.evaluateX(spline, y += YEPSILON, x, temp.getX(k).doubleValue());
            }
            while (x > xmax) {
                x = XYListSeriesCollection.evaluateX(spline, y += YEPSILON, x, temp.getX(k).doubleValue());
            }
        } else if (temp.getY(j).doubleValue() > ymax) {
            y = ymax;
            x = XYListSeriesCollection.evaluateX(spline, y, temp.getX(j).doubleValue(), temp.getX(k).doubleValue());
            while (x < xmin) {
                x = XYListSeriesCollection.evaluateX(spline, y -= YEPSILON, x, temp.getX(k).doubleValue());
            }
            while (x > xmax) {
                x = XYListSeriesCollection.evaluateX(spline, y -= YEPSILON, x, temp.getX(k).doubleValue());
            }
        } else {
            return null;
        }
        double[] retour = new double[]{x, y};
        return retour;
    }

    private static double evaluateX(final MathFunction spline, final double y, double xPrincipal, double xAnnexe) {
        MathFunction xFunction = new MathFunction(){

            public double evaluate(double t) {
                return spline.evaluate(t) - y;
            }
        };
        return RootFinder.brentDekker(xPrincipal, xAnnexe - 1.0E-6, xFunction, 1.0E-6);
    }

    private class AffineFit
    implements MathFunction {
        double[] x;
        double[] y;

        public AffineFit(double[] x, double[] y) {
            this.x = x;
            this.y = y;
        }

        public double evaluate(double t) {
            int i;
            if (t <= this.x[0]) {
                return this.y[0];
            }
            for (i = 0; i < this.x.length && t > this.x[i]; ++i) {
            }
            if (--i == this.x.length) {
                return this.x[this.x.length - 1];
            }
            return this.y[i] + (t - this.x[i]) / (this.x[i + 1] - this.x[i]) * (this.y[i + 1] - this.y[i]);
        }
    }
}

