/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import umontreal.iro.lecuyer.randvar.ExponentialGen;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.MRG32k3a;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stat.ObservationListener;
import umontreal.iro.lecuyer.stat.StatProbe;
import umontreal.iro.lecuyer.stat.Tally;

public class QueueObs {
    Tally waitingTimes = new Tally("Waiting times");
    Tally averageWaits = new Tally("Average wait");
    RandomVariateGen genArr;
    RandomVariateGen genServ;
    int cust;

    public QueueObs(double lambda, double mu, int step) {
        this.genArr = new ExponentialGen((RandomStream)new MRG32k3a(), lambda);
        this.genServ = new ExponentialGen((RandomStream)new MRG32k3a(), mu);
        this.waitingTimes.setBroadcasting(true);
        this.waitingTimes.addObservationListener(new ObservationTrace(step));
        this.waitingTimes.addObservationListener(new LargeWaitsCollector(2.0));
    }

    public double simulateOneRun(int numCust) {
        this.waitingTimes.init();
        double Wi = 0.0;
        this.waitingTimes.add(Wi);
        this.cust = 2;
        while (this.cust <= numCust) {
            if ((Wi += this.genServ.nextDouble() - this.genArr.nextDouble()) < 0.0) {
                Wi = 0.0;
            }
            this.waitingTimes.add(Wi);
            ++this.cust;
        }
        return this.waitingTimes.average();
    }

    public void simulateRuns(int n, int numCust) {
        this.averageWaits.init();
        for (int i = 0; i < n; ++i) {
            this.averageWaits.add(this.simulateOneRun(numCust));
        }
    }

    public static void main(String[] args) {
        QueueObs queue = new QueueObs(1.0, 2.0, 5);
        queue.simulateRuns(2, 100);
        System.out.println("\n\n" + queue.averageWaits.report());
    }

    public class LargeWaitsCollector
    implements ObservationListener {
        double threshold;
        ArrayList<Double> largeWaits = new ArrayList();

        public LargeWaitsCollector(double threshold) {
            this.threshold = threshold;
        }

        public void newObservation(StatProbe probe, double x) {
            if (x > this.threshold) {
                this.largeWaits.add(x);
            }
        }

        public String formatLargeWaits() {
            return "not yet implemented...";
        }
    }

    public class ObservationTrace
    implements ObservationListener {
        private int step;

        public ObservationTrace(int step) {
            this.step = step;
        }

        public void newObservation(StatProbe probe, double x) {
            if (QueueObs.this.cust % this.step == 0) {
                System.out.println("Customer " + QueueObs.this.cust + " waited " + x + " time units.");
            }
        }
    }
}

