/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import umontreal.iro.lecuyer.randvar.ExponentialGen;
import umontreal.iro.lecuyer.rng.MRG32k3a;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.Sim;
import umontreal.iro.lecuyer.simprocs.Resource;
import umontreal.iro.lecuyer.simprocs.SimProcess;
import umontreal.iro.lecuyer.stat.Tally;

public class Jobshop {
    int nbMachTypes;
    int nbTaskTypes;
    double warmupTime;
    double horizonTime;
    boolean warmupDone;
    Resource[] machType;
    TaskType[] taskType;
    RandomStream streamArr = new MRG32k3a();
    BufferedReader input;
    Event endWarmup = new Event(){

        public void actions() {
            for (int m = 0; m < Jobshop.this.nbMachTypes; ++m) {
                Jobshop.this.machType[m].setStatCollecting(true);
            }
            Jobshop.this.warmupDone = true;
        }
    };
    Event endOfSim = new Event(){

        public void actions() {
            Sim.stop();
        }
    };

    public Jobshop() throws IOException {
        this.readData();
    }

    void readData() throws IOException {
        this.input = new BufferedReader(new FileReader("Jobshop.dat"));
        StringTokenizer line = new StringTokenizer(this.input.readLine());
        this.warmupTime = Double.parseDouble(line.nextToken());
        line = new StringTokenizer(this.input.readLine());
        this.horizonTime = Double.parseDouble(line.nextToken());
        line = new StringTokenizer(this.input.readLine());
        this.nbMachTypes = Integer.parseInt(line.nextToken());
        this.nbTaskTypes = Integer.parseInt(line.nextToken());
        this.machType = new Resource[this.nbMachTypes];
        for (int m = 0; m < this.nbMachTypes; ++m) {
            line = new StringTokenizer(this.input.readLine());
            String name = line.nextToken();
            int nb = Integer.parseInt(line.nextToken());
            this.machType[m] = new Resource(nb, name);
        }
        this.taskType = new TaskType[this.nbTaskTypes];
        for (int n = 0; n < this.nbTaskTypes; ++n) {
            this.taskType[n] = new TaskType();
        }
        this.input.close();
    }

    public void simulateOneRun() {
        SimProcess.init();
        this.endOfSim.schedule(this.horizonTime);
        this.endWarmup.schedule(this.warmupTime);
        this.warmupDone = false;
        for (int n = 0; n < this.nbTaskTypes; ++n) {
            new Task(this.taskType[n]).schedule(ExponentialGen.nextDouble(this.streamArr, this.taskType[n].arrivalRate));
        }
        Sim.start();
    }

    public void printReportOneRun() {
        for (int m = 0; m < this.nbMachTypes; ++m) {
            System.out.println(this.machType[m].report());
        }
        for (int n = 0; n < this.nbTaskTypes; ++n) {
            System.out.println(this.taskType[n].statSojourn.report());
        }
    }

    public static void main(String[] args) throws IOException {
        Jobshop shop = new Jobshop();
        shop.simulateOneRun();
        shop.printReportOneRun();
    }

    public class Task
    extends SimProcess {
        TaskType type;

        Task(TaskType type) {
            this.type = type;
        }

        public void actions() {
            new Task(this.type).schedule(ExponentialGen.nextDouble(Jobshop.this.streamArr, this.type.arrivalRate));
            this.type.performTask(this);
        }
    }

    class TaskType {
        public String name;
        public double arrivalRate;
        public int nbOper;
        public Resource[] machOper;
        public double[] lengthOper;
        public Tally statSojourn;

        TaskType() throws IOException {
            StringTokenizer line = new StringTokenizer(Jobshop.this.input.readLine());
            this.name = line.nextToken();
            this.statSojourn = new Tally(this.name);
            this.arrivalRate = Double.parseDouble(line.nextToken());
            this.nbOper = Integer.parseInt(line.nextToken());
            this.machOper = new Resource[this.nbOper];
            this.lengthOper = new double[this.nbOper];
            for (int i = 0; i < this.nbOper; ++i) {
                int p = Integer.parseInt(line.nextToken());
                this.machOper[i] = Jobshop.this.machType[p - 1];
                this.lengthOper[i] = Double.parseDouble(line.nextToken());
            }
        }

        public void performTask(SimProcess p) {
            double arrivalTime = Sim.time();
            for (int i = 0; i < this.nbOper; ++i) {
                this.machOper[i].request(1);
                p.delay(this.lengthOper[i]);
                this.machOper[i].release(1);
            }
            if (Jobshop.this.warmupDone) {
                this.statSojourn.add(Sim.time() - arrivalTime);
            }
        }
    }
}

