/*
 * Decompiled with CFR 0.152.
 */
import umontreal.iro.lecuyer.rng.MRG32k3a;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stat.Tally;

public class Collision {
    int k;
    int m;
    double lambda;
    boolean[] used;

    public Collision(int k, int m) {
        this.k = k;
        this.m = m;
        this.lambda = (double)m * (double)m / (2.0 * (double)k);
        this.used = new boolean[k];
    }

    public int generateC(RandomStream stream) {
        int C = 0;
        for (int i = 0; i < this.k; ++i) {
            this.used[i] = false;
        }
        for (int j = 0; j < this.m; ++j) {
            int loc = stream.nextInt(0, this.k - 1);
            if (this.used[loc]) {
                ++C;
                continue;
            }
            this.used[loc] = true;
        }
        return C;
    }

    public void simulateRuns(int n, RandomStream stream, Tally statC) {
        statC.init();
        for (int i = 0; i < n; ++i) {
            statC.add(this.generateC(stream));
        }
        statC.setConfidenceIntervalStudent();
        System.out.println(statC.report(0.95, 3));
        System.out.println(" Theoretical mean: " + this.lambda);
    }

    public static void main(String[] args) {
        Tally statC = new Tally("Statistics on collisions");
        Collision col = new Collision(10000, 500);
        col.simulateRuns(100000, new MRG32k3a(), statC);
    }
}

