/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Scanner;
import umontreal.iro.lecuyer.probdist.ExponentialDist;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.randvar.GammaAcceptanceRejectionGen;
import umontreal.iro.lecuyer.randvar.GammaGen;
import umontreal.iro.lecuyer.rng.MRG32k3a;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.Sim;
import umontreal.iro.lecuyer.stat.Tally;

public class CallCenter {
    static final double HOUR = 3600.0;
    double openingTime;
    int numPeriods;
    int[] numAgents;
    double[] lambda;
    double alpha0;
    double p;
    double nu;
    double alpha;
    double beta;
    double s;
    double busyness;
    double arrRate = 0.0;
    int nAgents;
    int nBusy;
    int nArrivals;
    int nAbandon;
    int nGoodQoS;
    double nCallsExpected;
    Event nextArrival = new Arrival();
    LinkedList<Call> waitList = new LinkedList();
    RandomStream streamB = new MRG32k3a();
    RandomStream streamArr = new MRG32k3a();
    RandomStream streamPatience = new MRG32k3a();
    GammaGen genServ;
    Tally[] allTal = new Tally[4];
    Tally statArrivals;
    Tally statWaits;
    Tally statGoodQoS;
    Tally statAbandon;
    Tally statWaitsDay;

    public CallCenter(String fileName) throws IOException {
        this.statArrivals = this.allTal[0] = new Tally("Number of arrivals per day");
        this.statWaits = this.allTal[1] = new Tally("Average waiting time per customer");
        this.statGoodQoS = this.allTal[2] = new Tally("Proportion of waiting times < s");
        this.statAbandon = this.allTal[3] = new Tally("Proportion of calls lost");
        this.statWaitsDay = new Tally("Waiting times within a day");
        this.readData(fileName);
        this.genServ = new GammaAcceptanceRejectionGen((RandomStream)new MRG32k3a(), this.alpha, this.beta);
    }

    public void readData(String fileName) throws IOException {
        Locale loc = Locale.getDefault();
        Locale.setDefault(Locale.US);
        BufferedReader input = new BufferedReader(new FileReader(fileName));
        Scanner scan = new Scanner(input);
        this.openingTime = scan.nextDouble();
        scan.nextLine();
        this.numPeriods = scan.nextInt();
        scan.nextLine();
        this.numAgents = new int[this.numPeriods];
        this.lambda = new double[this.numPeriods];
        this.nCallsExpected = 0.0;
        for (int j = 0; j < this.numPeriods; ++j) {
            this.numAgents[j] = scan.nextInt();
            this.lambda[j] = scan.nextDouble();
            this.nCallsExpected += this.lambda[j];
            scan.nextLine();
        }
        this.alpha0 = scan.nextDouble();
        scan.nextLine();
        this.p = scan.nextDouble();
        scan.nextLine();
        this.nu = scan.nextDouble();
        scan.nextLine();
        this.alpha = scan.nextDouble();
        scan.nextLine();
        this.beta = scan.nextDouble();
        scan.nextLine();
        this.s = scan.nextDouble();
        scan.close();
        Locale.setDefault(loc);
    }

    public void checkQueue() {
        while (this.waitList.size() > 0 && this.nBusy < this.nAgents) {
            this.waitList.removeFirst().endWait();
        }
    }

    public double generPatience() {
        double u = this.streamPatience.nextDouble();
        if (u <= this.p) {
            return 0.0;
        }
        return ExponentialDist.inverseF(this.nu, (1.0 - u) / (1.0 - this.p));
    }

    public void simulateOneDay(double busyness) {
        Sim.init();
        this.statWaitsDay.init();
        this.nArrivals = 0;
        this.nAbandon = 0;
        this.nGoodQoS = 0;
        this.nBusy = 0;
        this.busyness = busyness;
        new NextPeriod(0).schedule(this.openingTime * 3600.0);
        Sim.start();
        this.statArrivals.add(this.nArrivals);
        this.statAbandon.add((double)this.nAbandon / this.nCallsExpected);
        this.statGoodQoS.add((double)this.nGoodQoS / this.nCallsExpected);
        this.statWaits.add(this.statWaitsDay.sum() / this.nCallsExpected);
    }

    public void simulateOneDay() {
        this.simulateOneDay(GammaDist.inverseF(this.alpha0, this.alpha0, 8, this.streamB.nextDouble()));
    }

    public static void main(String[] args) throws IOException {
        int i;
        CallCenter cc = new CallCenter("CallCenter.dat");
        for (i = 0; i < 1000; ++i) {
            cc.simulateOneDay();
        }
        System.out.println("\nNum. calls expected = " + cc.nCallsExpected + "\n");
        for (i = 0; i < cc.allTal.length; ++i) {
            cc.allTal[i].setConfidenceIntervalStudent();
            cc.allTal[i].setConfidenceLevel(0.9);
        }
        System.out.println(Tally.report("CallCenter:", cc.allTal));
    }

    class CallCompletion
    extends Event {
        CallCompletion() {
        }

        public void actions() {
            --CallCenter.this.nBusy;
            CallCenter.this.checkQueue();
        }
    }

    class Arrival
    extends Event {
        Arrival() {
        }

        public void actions() {
            CallCenter.this.nextArrival.schedule(ExponentialDist.inverseF(CallCenter.this.arrRate, CallCenter.this.streamArr.nextDouble()));
            ++CallCenter.this.nArrivals;
            new Call();
        }
    }

    class NextPeriod
    extends Event {
        int j;

        public NextPeriod(int period) {
            this.j = period;
        }

        public void actions() {
            if (this.j < CallCenter.this.numPeriods) {
                CallCenter.this.nAgents = CallCenter.this.numAgents[this.j];
                CallCenter.this.arrRate = CallCenter.this.busyness * CallCenter.this.lambda[this.j] / 3600.0;
                if (this.j == 0) {
                    CallCenter.this.nextArrival.schedule(ExponentialDist.inverseF(CallCenter.this.arrRate, CallCenter.this.streamArr.nextDouble()));
                } else {
                    CallCenter.this.checkQueue();
                    CallCenter.this.nextArrival.reschedule((CallCenter.this.nextArrival.time() - Sim.time()) * CallCenter.this.lambda[this.j - 1] / CallCenter.this.lambda[this.j]);
                }
                new NextPeriod(this.j + 1).schedule(3600.0);
            } else {
                CallCenter.this.nextArrival.cancel();
            }
        }
    }

    class Call {
        double arrivalTime;
        double serviceTime;
        double patienceTime;

        public Call() {
            this.serviceTime = CallCenter.this.genServ.nextDouble();
            if (CallCenter.this.nBusy < CallCenter.this.nAgents) {
                ++CallCenter.this.nBusy;
                ++CallCenter.this.nGoodQoS;
                CallCenter.this.statWaitsDay.add(0.0);
                new CallCompletion().schedule(this.serviceTime);
            } else {
                this.patienceTime = CallCenter.this.generPatience();
                this.arrivalTime = Sim.time();
                CallCenter.this.waitList.addLast(this);
            }
        }

        public void endWait() {
            double wait = Sim.time() - this.arrivalTime;
            if (this.patienceTime < wait) {
                ++CallCenter.this.nAbandon;
                wait = this.patienceTime;
            } else {
                ++CallCenter.this.nBusy;
                new CallCompletion().schedule(this.serviceTime);
            }
            if (wait < CallCenter.this.s) {
                ++CallCenter.this.nGoodQoS;
            }
            CallCenter.this.statWaitsDay.add(wait);
        }
    }
}

