/*
 * Decompiled with CFR 0.152.
 */
import umontreal.iro.lecuyer.randvar.ExponentialGen;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.randvar.UniformGen;
import umontreal.iro.lecuyer.rng.MRG32k3a;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.simevents.Accumulate;
import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.Sim;
import umontreal.iro.lecuyer.simprocs.Resource;
import umontreal.iro.lecuyer.simprocs.SimProcess;
import umontreal.iro.lecuyer.stat.Tally;

public class Cafeteria {
    static final int Hotfood = 0;
    static final int Sandwich = 1;
    static final int Drinks = 2;
    static final double minHotST = 50.0;
    static final double maxHotST = 120.0;
    static final double minSandST = 60.0;
    static final double maxSandST = 180.0;
    static final double minDrinkST = 5.0;
    static final double maxDrinkST = 20.0;
    static final double minHotACT = 20.0;
    static final double maxHotACT = 40.0;
    static final double minSandACT = 5.0;
    static final double maxSandACT = 15.0;
    static final double minDrinkACT = 5.0;
    static final double maxDrinkACT = 10.0;
    static final double meanArr = 30.0;
    int NbCaisses;
    double Nb;
    int NbAttente = 0;
    double NbHot;
    double NbSand;
    RandomStream streamArr = new MRG32k3a();
    RandomStream streamGrSize = new MRG32k3a();
    RandomStream streamRoute = new MRG32k3a();
    RandomStream streamHotServ = new MRG32k3a();
    RandomStream streamSandServ = new MRG32k3a();
    RandomStream streamDrinksServ = new MRG32k3a();
    RandomStream streamHotACT = new MRG32k3a();
    RandomStream streamSandACT = new MRG32k3a();
    RandomStream streamDrinksACT = new MRG32k3a();
    RandomVariateGen genArr = new ExponentialGen(this.streamArr, 0.03333333333333333);
    Resource HotServ = new Resource(1, "Service repas chauds");
    Resource SandServ = new Resource(1, "Service sandwich");
    Resource[] Caisse = new Resource[3];
    Accumulate NbClients = new Accumulate("Nb. de clients dans le systeme");
    Accumulate CaissesNb = new Accumulate("Nb. en attente pour les caisses");
    Tally CaissesAttente = new Tally("Temps d'attente pour caisses");
    Tally[] AttClient = new Tally[3];

    public void SimCafeteria(int Ncais, double Nhot, double Nsand) {
        System.out.print(Ncais + " caisses, " + (int)Nhot + " aux repas chauds et " + (int)Nsand + " aux sandwichs\n");
        this.NbCaisses = Ncais;
        this.NbHot = Nhot;
        this.NbSand = Nsand;
        this.Nb = 0.0;
        this.NbAttente = 0;
        SimProcess.init();
        this.HotServ.init();
        this.SandServ.init();
        this.NbClients.init();
        this.CaissesNb.init();
        this.CaissesAttente.init();
        for (int i = 0; i < 3; ++i) {
            this.Caisse[i].init();
            this.AttClient[i].init();
        }
        new ProcFinSim().schedule(4500.0);
        new ProcGenArr().schedule(0.0);
        Sim.start();
    }

    public Cafeteria() {
        this.AttClient[0] = new Tally("Temps d'attente repas chauds");
        this.AttClient[1] = new Tally("Temps d'attente sandwich");
        this.AttClient[2] = new Tally("Temps d'attente breuvages");
        for (int i = 0; i < 3; ++i) {
            this.Caisse[i] = new Resource(1, "Une caisse");
            this.Caisse[i].setStatCollecting(true);
        }
        this.HotServ.setStatCollecting(true);
        this.SandServ.setStatCollecting(true);
        this.SimCafeteria(2, 1.0, 1.0);
        this.SimCafeteria(3, 1.0, 1.0);
        this.SimCafeteria(2, 2.0, 1.0);
        this.SimCafeteria(2, 1.0, 2.0);
        this.SimCafeteria(2, 2.0, 2.0);
        this.SimCafeteria(3, 2.0, 1.0);
        this.SimCafeteria(3, 1.0, 2.0);
        this.SimCafeteria(3, 2.0, 2.0);
    }

    public static void main(String[] args) {
        new Cafeteria();
    }

    class ProcFinSim
    extends Event {
        ProcFinSim() {
        }

        public void actions() {
            System.out.println(Cafeteria.this.HotServ.report());
            System.out.println(Cafeteria.this.SandServ.report());
            System.out.println(Cafeteria.this.CaissesNb.report());
            System.out.println(Cafeteria.this.CaissesAttente.report());
            System.out.println(Cafeteria.this.NbClients.report());
            System.out.println(Cafeteria.this.AttClient[0].report());
            System.out.println(Cafeteria.this.AttClient[1].report());
            System.out.println(Cafeteria.this.AttClient[2].report());
            System.out.print("\nAttente moyenne globale: " + (0.8 * Cafeteria.this.AttClient[0].average() + 0.15 * Cafeteria.this.AttClient[1].average() + 0.05 * Cafeteria.this.AttClient[2].average()) + "\n\n");
            Sim.stop();
            System.out.print("==========================================\n");
        }
    }

    class ProcClient
    extends SimProcess {
        double u;
        double ACT;
        double TArr;
        double Attente;
        int T;

        ProcClient() {
        }

        public void actions() {
            Cafeteria.this.Nb += 1.0;
            Cafeteria.this.NbClients.update(Cafeteria.this.Nb);
            this.TArr = Sim.time();
            this.u = Cafeteria.this.streamRoute.nextDouble();
            if (this.u < 0.8) {
                this.T = 0;
                Cafeteria.this.HotServ.request(1);
                this.Attente = Sim.time() - this.TArr;
                this.delay(UniformGen.nextDouble(Cafeteria.this.streamHotServ, 50.0 / Cafeteria.this.NbHot, 120.0 / Cafeteria.this.NbHot));
                Cafeteria.this.HotServ.release(1);
                this.ACT = UniformGen.nextDouble(Cafeteria.this.streamHotACT, 20.0, 40.0);
            } else if (this.u < 0.95) {
                this.T = 1;
                Cafeteria.this.SandServ.request(1);
                this.Attente = Sim.time() - this.TArr;
                this.delay(UniformGen.nextDouble(Cafeteria.this.streamSandServ, 60.0 / Cafeteria.this.NbSand, 180.0 / Cafeteria.this.NbSand));
                Cafeteria.this.SandServ.release(1);
                this.ACT = UniformGen.nextDouble(Cafeteria.this.streamSandACT, 5.0, 15.0);
            } else {
                this.T = 2;
            }
            this.delay(UniformGen.nextDouble(Cafeteria.this.streamDrinksServ, 5.0, 20.0));
            this.ACT += UniformGen.nextDouble(Cafeteria.this.streamDrinksACT, 5.0, 10.0);
            int c = 0;
            for (int i = 1; i < Cafeteria.this.NbCaisses; ++i) {
                if (Cafeteria.this.Caisse[i].waitList().size() >= Cafeteria.this.Caisse[c].waitList().size()) continue;
                c = i;
            }
            this.TArr = Sim.time();
            Cafeteria.this.CaissesNb.update(++Cafeteria.this.NbAttente);
            Cafeteria.this.Caisse[c].request(1);
            Cafeteria.this.CaissesNb.update(--Cafeteria.this.NbAttente);
            Cafeteria.this.AttClient[this.T].add(this.Attente + Sim.time() - this.TArr);
            Cafeteria.this.CaissesAttente.add(Sim.time() - this.TArr);
            this.delay(this.ACT);
            Cafeteria.this.Caisse[c].release(1);
            Cafeteria.this.Nb -= 1.0;
            Cafeteria.this.NbClients.update(Cafeteria.this.Nb);
        }
    }

    class ProcGenArr
    extends SimProcess {
        ProcGenArr() {
        }

        public void actions() {
            while (true) {
                this.delay(Cafeteria.this.genArr.nextDouble());
                double u = Cafeteria.this.streamGrSize.nextDouble();
                new ProcClient().schedule(0.0);
                if (u > 0.5) {
                    new ProcClient().schedule(0.0);
                }
                if (u > 0.8) {
                    new ProcClient().schedule(0.0);
                }
                if (!(u > 0.9)) continue;
                new ProcClient().schedule(0.0);
            }
        }
    }
}

