/*
 * Decompiled with CFR 0.152.
 */
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.rng.MRG32k3a;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stat.Tally;
import umontreal.iro.lecuyer.util.Chrono;

public class Asian {
    double strike;
    int s;
    double discount;
    double[] muDelta;
    double[] sigmaSqrtDelta;
    double[] logS;

    public Asian(double r, double sigma, double strike, double s0, int s, double[] zeta) {
        this.strike = strike;
        this.s = s;
        this.discount = Math.exp(-r * zeta[s]);
        double mu = r - 0.5 * sigma * sigma;
        this.muDelta = new double[s];
        this.sigmaSqrtDelta = new double[s];
        this.logS = new double[s + 1];
        for (int j = 0; j < s; ++j) {
            double delta = zeta[j + 1] - zeta[j];
            this.muDelta[j] = mu * delta;
            this.sigmaSqrtDelta[j] = sigma * Math.sqrt(delta);
        }
        this.logS[0] = Math.log(s0);
    }

    public void generatePath(RandomStream stream) {
        for (int j = 0; j < this.s; ++j) {
            this.logS[j + 1] = this.logS[j] + this.muDelta[j] + this.sigmaSqrtDelta[j] * NormalDist.inverseF01(stream.nextDouble());
        }
    }

    public double getPayoff() {
        double average = 0.0;
        for (int j = 1; j <= this.s; ++j) {
            average += Math.exp(this.logS[j]);
        }
        if ((average /= (double)this.s) > this.strike) {
            return this.discount * (average - this.strike);
        }
        return 0.0;
    }

    public void simulateRuns(int n, RandomStream stream, Tally statValue) {
        statValue.init();
        for (int i = 0; i < n; ++i) {
            this.generatePath(stream);
            statValue.add(this.getPayoff());
            stream.resetNextSubstream();
        }
    }

    public static void main(String[] args) {
        int s = 12;
        double[] zeta = new double[s + 1];
        zeta[0] = 0.0;
        for (int j = 1; j <= s; ++j) {
            zeta[j] = (double)j / (double)s;
        }
        Asian process = new Asian(0.05, 0.5, 100.0, 100.0, s, zeta);
        Tally statValue = new Tally("Stats on value of Asian option");
        Chrono timer = new Chrono();
        int n = 100000;
        process.simulateRuns(n, new MRG32k3a(), statValue);
        statValue.setConfidenceIntervalStudent();
        System.out.println(statValue.report(0.95, 3));
        System.out.println("Total CPU time:      " + timer.format() + "\n");
    }
}

