/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stat;

import java.util.ArrayList;
import java.util.Arrays;

public class PgfDataTable {
    String tableName;
    String tableLabel;
    String[] fields;
    double[][] data;
    int numFields;
    int numObservations;

    public PgfDataTable(String tableName, String tableLabel, String[] fields, double[][] data) {
        this.tableName = tableName;
        this.tableLabel = tableLabel;
        this.fields = fields;
        this.data = data;
        this.numFields = fields.length;
        this.numObservations = data.length;
    }

    public String formatTable() {
        StringBuffer sb = new StringBuffer("");
        sb.append("%      " + this.tableName + "\n      ");
        for (int j = 0; j < this.numFields; ++j) {
            sb.append(this.fields[j] + "  ");
        }
        sb.append("\n");
        for (int s = 0; s < this.numObservations; ++s) {
            for (int j = 0; j < this.numFields; ++j) {
                sb.append("      " + this.data[s][j]);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String formatTableTwoFields(int j1, int j2) {
        StringBuffer sb = new StringBuffer("");
        sb.append("      " + this.fields[j1] + "  " + this.fields[j2] + " \n");
        for (int s = 0; s < this.numObservations; ++s) {
            sb.append("      " + this.data[s][j1] + "  " + this.data[s][j2] + " \n");
        }
        return sb.toString();
    }

    public String formatPgfCurveAddPlot(int j1, int j2, String plotoptions) {
        StringBuffer sb = new StringBuffer("");
        sb.append("      \\addplot table[x=" + this.fields[j1] + ",y=" + this.fields[j2] + "] { \n");
        sb.append(this.formatTableTwoFields(j1, j2) + " }; \n");
        sb.append("      \\addlegendentry{" + this.tableLabel + "}\n");
        sb.append("      \\label{" + this.tableLabel + "}\n");
        sb.append("%   \n");
        return sb.toString();
    }

    public String formatPgfCurveAddPlot(String xaxis, String yaxis, String plotoptions) {
        int j1 = Arrays.asList(this.fields).indexOf(xaxis);
        int j2 = Arrays.asList(this.fields).indexOf(yaxis);
        return this.formatPgfCurveAddPlot(j1, j2, plotoptions);
    }

    public String drawPgfPlotSingleCurve(String title, String axistype, String xaxis, String yaxis, int logbasis, String axisoptions, String plotoptions) {
        int j1 = Arrays.asList(this.fields).indexOf(xaxis);
        int j2 = Arrays.asList(this.fields).indexOf(yaxis);
        return this.drawPgfPlotSingleCurve(title, axistype, j1, j2, logbasis, axisoptions, plotoptions);
    }

    public String drawPgfPlotSingleCurve(String title, String axistype, int j1, int j2, int logbasis, String axisoptions, String plotoptions) {
        StringBuffer sb = new StringBuffer("");
        sb.append("  \\begin{tikzpicture} \n");
        sb.append("    \\begin{" + axistype + "}[ \n");
        sb.append("      title ={" + title + "},\n");
        sb.append("      xlabel=" + this.fields[j1] + ",\n");
        sb.append("      ylabel=" + this.fields[j2] + ",\n");
        if (axistype == "loglogaxis") {
            sb.append("     log basis x=" + logbasis + ", log basis y=" + logbasis + ",\n");
        }
        sb.append("       grid,\n");
        sb.append(axisoptions + ",\n");
        sb.append("      ] \n");
        sb.append(this.formatPgfCurveAddPlot(j1, j2, plotoptions));
        sb.append("    \\end{" + axistype + "}\n");
        sb.append("  \\end{tikzpicture}\n");
        sb.append("  ");
        return sb.toString();
    }

    public static String drawPgfPlotManyCurves(String title, String axistype, int j1, int j2, ArrayList<PgfDataTable> listCurves, int logbasis, String axisoptions, String plotoptions) {
        StringBuffer sb = new StringBuffer("");
        sb.append("  \\begin{tikzpicture} \n");
        sb.append("    \\begin{" + axistype + "}[ \n");
        sb.append("      title ={" + title + "},\n");
        sb.append("      xlabel=" + listCurves.get((int)0).fields[j1] + ",\n");
        sb.append("      ylabel=" + listCurves.get((int)0).fields[j2] + ",\n");
        if (axistype == "loglogaxis") {
            sb.append("      log basis x=" + logbasis + ", log basis y=" + logbasis + ",\n");
        }
        sb.append("       grid,\n");
        sb.append(axisoptions + ",\n");
        sb.append("      ] \n");
        for (PgfDataTable curve : listCurves) {
            sb.append(curve.formatPgfCurveAddPlot(j1, j2, plotoptions));
        }
        sb.append("    \\end{" + axistype + "}\n");
        sb.append("  \\end{tikzpicture}\n");
        sb.append("  ");
        return sb.toString();
    }

    public String formatTableThreeFields(int j1, int j2, int j3) {
        StringBuffer sb = new StringBuffer("");
        for (int s = 0; s < this.numObservations; ++s) {
            sb.append("  (     " + this.data[s][j1] + " , " + this.data[s][j2] + "  ," + this.data[s][j3] + ") \n");
        }
        return sb.toString();
    }

    public String formatPgfCurveAddPlot(int j1, int j2, int j3, String plotoptions) {
        StringBuffer sb = new StringBuffer("");
        sb.append("      \\addplot3 [" + plotoptions + "]coordinates { \n");
        sb.append(this.formatTableThreeFields(j1, j2, j3) + "      }; \n");
        sb.append("      \\addlegendentry{" + this.tableLabel + "}\n");
        sb.append("      \\label{" + this.tableLabel + "}\n");
        return sb.toString();
    }

    public String drawPgfPlotSingleCurve(String title, String axistype, int j1, int j2, int j3, int logbasis, String axisoptions, String plotoptions) {
        StringBuffer sb = new StringBuffer("");
        sb.append("  \\begin{tikzpicture} \n");
        sb.append("    \\begin{" + axistype + "}[ \n");
        sb.append("      title ={" + title + "},\n");
        sb.append("      xlabel=" + this.fields[j1] + ",\n");
        sb.append("      ylabel=" + this.fields[j2] + ",\n");
        sb.append("      zlabel=" + this.fields[j3] + ",\n");
        if (axistype == "loglogaxis") {
            sb.append("     log basis x=" + logbasis + ", log basis y=" + logbasis + ",\n");
        }
        sb.append("       grid,\n");
        sb.append("      " + axisoptions + ",\n");
        sb.append("      ] \n");
        sb.append(this.formatPgfCurveAddPlot(j1, j2, j3, plotoptions));
        sb.append("    \\end{" + axistype + "}\n");
        sb.append("  \\end{tikzpicture}\n");
        sb.append("  ");
        return sb.toString();
    }

    public static String pgfplotFileHeader() {
        StringBuffer sb = new StringBuffer("");
        sb.append("\\documentclass[12pt]{article}\n\\usepackage{pgfplots}\n\\pgfplotsset{compat=1.12}\n\\usepackage{xcolor}\n\\usetikzlibrary{shapes,decorations,arrows,automata,plotmarks,patterns}\n\\usepackage{tikz-inet}\n\\usepgfplotslibrary{groupplots}\n%\n\\pgfplotscreateplotcyclelist{defaultcolorlist}{%\n  {blue!85!black,line width=0.9pt,mark=*,solid},\n  {red!85!black,line width=0.9pt,mark=square*,dashed},\n  {lime!60!black,line width=0.9pt,mark=triangle*,dotted},\n  {orange!90!black,line width=0.9pt,mark=diamond*,loosely dashed},\n  {black,mark=star,loosely dotted},\n  {violet!85!black,mark=o,solid},\n  {brown!85!black,mark=square,dashed},\n  {purple!85!black,mark=triangle,dotted}}\n%\n\\pgfplotsset{\n  every axis/.append style={\n    font=\\footnotesize,\n    width=.8\\columnwidth,\n    height=.6\\columnwidth,\n    %!line width=0.6pt,\n    legend style={at={(1.02,1)}, anchor={north west}},\n    cycle list name=defaultcolorlist,\n  },\n  every axis title/.style={\n    at={(0.5,1)},\n    below\n  },\n }\n%\n\\begin{document}\n\n");
        return sb.toString();
    }

    public static String pgfplotEndDocument() {
        return "\\end{document}\n";
    }
}

