/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.latnetbuilder;

import java.util.ArrayList;
import umontreal.ssj.hups.DigitalNetBase2;
import umontreal.ssj.latnetbuilder.Search;

public class DigitalNetSearch
extends Search {
    String construction;
    int interlacing;

    public DigitalNetSearch(String construction) {
        this.construction = construction;
        this.interlacing = 1;
    }

    @Override
    public DigitalNetBase2 search() throws RuntimeException {
        int col;
        ArrayList<String> res = this.executeCommandLine();
        int numCols = Integer.parseInt(res.get(0).split("  //")[0]);
        int numRows = Integer.parseInt(res.get(1).split("  //")[0]);
        int interlacing = Integer.parseInt(res.get(4).split("  //")[0]);
        int dimension = Integer.parseInt(res.get(3).split("  //")[0]);
        int[][][] mats = new int[dimension][numRows][numCols];
        for (int coord = 0; coord < dimension; ++coord) {
            for (int row = 0; row < numRows; ++row) {
                String[] tmp = res.get(coord * (numRows + 1) + row + this.offsetForParsingGeneratingMatrix(dimension)).split(" ");
                for (col = 0; col < numCols; ++col) {
                    mats[coord][row][col] = Integer.parseInt(tmp[col]);
                }
            }
        }
        int[] genMat = new int[(dimension /= interlacing) * numCols];
        int trueNumRows = Math.min(31, numRows * interlacing);
        for (int coord = 0; coord < dimension; ++coord) {
            for (col = 0; col < numCols; ++col) {
                genMat[coord * numCols + col] = 0;
                for (int row = 0; row < trueNumRows; ++row) {
                    int n = coord * numCols + col;
                    genMat[n] = genMat[n] + (1 << 30 - row) * mats[coord * interlacing + row % interlacing][row / interlacing][col];
                }
            }
        }
        this.merit = Double.parseDouble(res.get(res.size() - 2).split("  //")[0]);
        this.time = Double.parseDouble(res.get(res.size() - 1).split("  //")[0]);
        this.successful = true;
        return new DigitalNetBase2FromLatNetBuilder(trueNumRows, numCols, dimension, genMat);
    }

    private int offsetForParsingGeneratingMatrix(int dimension) {
        if (this.construction == "sobol") {
            return 7 + dimension;
        }
        if (this.construction == "explicit") {
            return 7;
        }
        return 8 + dimension;
    }

    @Override
    public String pointSetType() {
        return "net";
    }

    @Override
    public int interlacing() {
        return this.interlacing;
    }

    public void setInterlacing(int interlacing) {
        this.interlacing = interlacing;
    }

    @Override
    public String construction() {
        return this.construction;
    }

    public void setConstruction(String construction) {
        this.construction = construction;
    }

    protected class DigitalNetBase2FromLatNetBuilder
    extends DigitalNetBase2 {
        public DigitalNetBase2FromLatNetBuilder(int numRows, int numCols, int dim, int[] matrices) {
            this.numCols = numCols;
            this.numRows = Math.min(numRows, 31);
            this.numPoints = 1 << this.numCols;
            this.dim = dim;
            this.genMat = matrices;
            this.outDigits = 31;
            this.normFactor = 1.0 / (double)(1L << this.outDigits);
        }
    }
}

