/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import umontreal.ssj.hups.ContainerPointSet;
import umontreal.ssj.hups.PointSet;
import umontreal.ssj.hups.PointSetIterator;
import umontreal.ssj.util.PrintfFormat;

public class BakerTransformedPointSet
extends ContainerPointSet {
    public BakerTransformedPointSet(PointSet P) {
        this.init(P);
    }

    @Override
    public double getCoordinate(int i, int j) {
        double u = this.P.getCoordinate(i, j);
        if (u < 0.5) {
            return 2.0 * u;
        }
        return 2.0 * (1.0 - u);
    }

    @Override
    public PointSetIterator iterator() {
        return new BakerTransformedPointSetIterator();
    }

    @Override
    public String toString() {
        return "Baker transformed point set of: {" + PrintfFormat.NEWLINE + this.P.toString() + PrintfFormat.NEWLINE + "}";
    }

    protected class BakerTransformedPointSetIterator
    extends ContainerPointSet.ContainerPointSetIterator {
        protected BakerTransformedPointSetIterator() {
        }

        @Override
        public double nextCoordinate() {
            double u = this.innerIterator.nextCoordinate();
            if (u < 0.5) {
                return 2.0 * u;
            }
            return 2.0 * (1.0 - u);
        }

        @Override
        public double nextDouble() {
            double u = this.innerIterator.nextCoordinate();
            if (u < 0.5) {
                return 2.0 * u;
            }
            return 2.0 * (1.0 - u);
        }

        @Override
        public void nextCoordinates(double[] p, int d) {
            this.innerIterator.nextCoordinates(p, d);
            for (int j = 0; j < d; ++j) {
                if (p[j] < 0.5) {
                    int n = j;
                    p[n] = p[n] * 2.0;
                    continue;
                }
                p[j] = 2.0 * (1.0 - p[j]);
            }
        }

        @Override
        public int nextPoint(double[] p, int d) {
            this.innerIterator.nextPoint(p, d);
            for (int j = 0; j < d; ++j) {
                if (p[j] < 0.5) {
                    int n = j;
                    p[n] = p[n] * 2.0;
                    continue;
                }
                p[j] = 2.0 * (1.0 - p[j]);
            }
            return this.getCurPointIndex();
        }
    }
}

