/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.MFN_M03_MFEOM1Hxx;
import ca.uhn.hl7v2.model.v231.segment.MFI;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class MFN_M03
extends AbstractMessage {
    public MFN_M03() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public MFN_M03(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MFI.class, true, false);
            this.add(MFN_M03_MFEOM1Hxx.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating MFN_M03 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFI getMFI() {
        MFI ret = null;
        try {
            ret = (MFI)this.get("MFI");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M03_MFEOM1Hxx getMFEOM1Hxx() {
        MFN_M03_MFEOM1Hxx ret = null;
        try {
            ret = (MFN_M03_MFEOM1Hxx)this.get("MFEOM1Hxx");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M03_MFEOM1Hxx getMFEOM1Hxx(int rep) {
        MFN_M03_MFEOM1Hxx ret = null;
        try {
            ret = (MFN_M03_MFEOM1Hxx)this.get("MFEOM1Hxx", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getMFEOM1HxxReps() {
        int reps = -1;
        try {
            reps = this.getAll("MFEOM1Hxx").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertMFEOM1Hxx(MFN_M03_MFEOM1Hxx structure, int rep) throws HL7Exception {
        super.insertRepetition("MFEOM1Hxx", (Structure)structure, rep);
    }

    public MFN_M03_MFEOM1Hxx insertMFEOM1Hxx(int rep) throws HL7Exception {
        return (MFN_M03_MFEOM1Hxx)super.insertRepetition("MFEOM1Hxx", rep);
    }

    public MFN_M03_MFEOM1Hxx removeMFEOM1Hxx(int rep) throws HL7Exception {
        return (MFN_M03_MFEOM1Hxx)super.removeRepetition("MFEOM1Hxx", rep);
    }
}

