/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.impl;

import ca.uhn.hl7v2.validation.impl.RegexPrimitiveRule;
import ca.uhn.hl7v2.validation.impl.RuleBinding;
import ca.uhn.hl7v2.validation.impl.SizeRule;
import ca.uhn.hl7v2.validation.impl.TrimLeadingWhitespace;
import ca.uhn.hl7v2.validation.impl.ValidationContextImpl;
import ca.uhn.hl7v2.validation.impl.WithdrawnDatatypeRule;

public class DefaultValidation
extends ValidationContextImpl {
    public DefaultValidation() {
        TrimLeadingWhitespace trim = new TrimLeadingWhitespace();
        this.getPrimitiveRuleBindings().add(new RuleBinding("*", "FT", trim));
        this.getPrimitiveRuleBindings().add(new RuleBinding("*", "ST", trim));
        this.getPrimitiveRuleBindings().add(new RuleBinding("*", "TX", trim));
        SizeRule size200 = new SizeRule(200);
        SizeRule size32000 = new SizeRule(32000);
        this.getPrimitiveRuleBindings().add(new RuleBinding("*", "FT", size32000));
        this.getPrimitiveRuleBindings().add(new RuleBinding("*", "ID", size200));
        this.getPrimitiveRuleBindings().add(new RuleBinding("*", "IS", size200));
        RegexPrimitiveRule nonNegativeInteger = new RegexPrimitiveRule("\\d*", "");
        this.getPrimitiveRuleBindings().add(new RuleBinding("*", "SI", nonNegativeInteger));
        RegexPrimitiveRule number = new RegexPrimitiveRule("(\\+|\\-)?\\d*\\.?\\d*", "");
        this.getPrimitiveRuleBindings().add(new RuleBinding("*", "NM", number));
        RegexPrimitiveRule telephoneNumber = new RegexPrimitiveRule("(\\d{1,2} )?(\\(\\d{3}\\))?\\d{3}-\\d{4}(X\\d{1,5})?(B\\d{1,5})?(C.*)?", "Version 2.4 Section 2.9.45");
        this.getPrimitiveRuleBindings().add(new RuleBinding("*", "TN", telephoneNumber));
        String datePattern = "(\\d{4}([01]\\d(\\d{2})?)?)?";
        RegexPrimitiveRule date = new RegexPrimitiveRule(datePattern, "Version 2.5 Section 2.16.24");
        this.getPrimitiveRuleBindings().add(new RuleBinding("*", "DT", date));
        String timePattern = "([012]\\d([0-5]\\d([0-5]\\d(\\.\\d(\\d(\\d(\\d)?)?)?)?)?)?)?([\\+\\-]\\d{4})?";
        RegexPrimitiveRule time = new RegexPrimitiveRule(timePattern, "Version 2.5 Section 2.16.79");
        this.getPrimitiveRuleBindings().add(new RuleBinding("*", "TM", time));
        String datetimePattern = "(\\d{4}([01]\\d(\\d{2}([012]\\d([0-5]\\d([0-5]\\d(\\.\\d(\\d(\\d(\\d)?)?)?)?)?)?)?)?)?)?([\\+\\-]\\d{4})?";
        RegexPrimitiveRule datetime = new RegexPrimitiveRule(datetimePattern, "Version 2.5 Section 2.16.25");
        this.getPrimitiveRuleBindings().add(new RuleBinding("*", "TSComponentOne", datetime));
        this.getPrimitiveRuleBindings().add(new RuleBinding("*", "DTM", datetime));
        this.getPrimitiveRuleBindings().add(new RuleBinding("*", "NULLDT", new WithdrawnDatatypeRule()));
    }
}

