/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.DefaultApplication;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.protocol.AcceptValidator;
import ca.uhn.hl7v2.protocol.ProcessorContext;
import ca.uhn.hl7v2.protocol.Transportable;
import ca.uhn.hl7v2.protocol.impl.TransportableImpl;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.io.IOException;

public class AcceptAcknowledger {
    private static final HapiLog log = HapiLogFactory.getHapiLog(AcceptAcknowledger.class);
    private static Parser ourParser = new GenericParser();

    public static AcceptACK validate(ProcessorContext theContext, Transportable theMessage) throws HL7Exception {
        AcceptACK ruling = null;
        AcceptValidator[] validators = theContext.getValidators();
        for (int i = 0; i < validators.length && ruling == null; ++i) {
            AcceptValidator.AcceptRuling vr = validators[i].check(theMessage);
            if (vr.isAcceptable()) continue;
            String description = vr.getReasons().length > 0 ? vr.getReasons()[0] : null;
            Transportable ack = AcceptAcknowledger.makeAcceptAck(theMessage, vr.getAckCode(), vr.getErrorCode(), description);
            ruling = new AcceptACK(false, ack);
        }
        if (ruling == null) {
            try {
                theContext.getSafeStorage().store(theMessage);
                Transportable ack = AcceptAcknowledger.makeAcceptAck(theMessage, "CA", 0, "");
                ruling = new AcceptACK(true, ack);
            }
            catch (HL7Exception e) {
                log.error(e);
                int code = 207;
                Transportable ack = AcceptAcknowledger.makeAcceptAck(theMessage, "CR", code, e.getMessage());
                ruling = new AcceptACK(false, ack);
            }
        }
        return ruling;
    }

    private static Transportable makeAcceptAck(Transportable theMessage, String theAckCode, int theErrorCode, String theDescription) throws HL7Exception {
        Message out;
        Segment header = ourParser.getCriticalResponseData(theMessage.getMessage());
        try {
            out = DefaultApplication.makeACK(header);
        }
        catch (IOException e) {
            throw new HL7Exception(e);
        }
        Terser t = new Terser(out);
        t.set("/MSA-1", theAckCode);
        if (theErrorCode != 0) {
            t.set("/MSA-3", theDescription.substring(0, Math.min(80, theDescription.length())));
            t.set("/ERR-1-4-1", String.valueOf(theErrorCode));
            t.set("/ERR-1-4-3", "HL70357");
        }
        String originalEncoding = ourParser.getEncoding(theMessage.getMessage());
        String ackText = ourParser.encode(out, originalEncoding);
        return new TransportableImpl(ackText);
    }

    public static class AcceptACK {
        private Transportable myAck;
        private boolean myIsAcceptable;

        public AcceptACK(boolean isAcceptable, Transportable theAck) {
            this.myIsAcceptable = isAcceptable;
            this.myAck = theAck;
        }

        public boolean isAcceptable() {
            return this.myIsAcceptable;
        }

        public Transportable getMessage() {
            return this.myAck;
        }
    }
}

