/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.validation.PrimitiveTypeRule;
import ca.uhn.hl7v2.validation.ValidationContext;

public abstract class AbstractPrimitive
extends AbstractType
implements Primitive {
    private String myValue;

    public AbstractPrimitive(Message message) {
        super(message);
    }

    public String toString() {
        return this.getValue();
    }

    public String getValue() {
        return this.myValue;
    }

    public void setValue(String theValue) throws DataTypeException {
        Message message = this.getMessage();
        if (message != null) {
            ValidationContext context = message.getValidationContext();
            String version = message.getVersion();
            if (context != null) {
                PrimitiveTypeRule[] rules = context.getPrimitiveRules(version, this.getName(), this);
                for (int i = 0; i < rules.length; ++i) {
                    if (rules[i].test(theValue = rules[i].correct(theValue))) continue;
                    throw new DataTypeException("Failed validation rule for value \"" + theValue + "\": " + rules[i].getDescription());
                }
            }
        }
        this.myValue = theValue;
    }

    public String encode() throws HL7Exception {
        Parser p = this.getMessage().getParser();
        return p.doEncode(this, EncodingCharacters.getInstance(this.getMessage()));
    }

    public void parse(String string) throws HL7Exception {
        EncodingCharacters encodingCharacters = EncodingCharacters.getInstance(this.getMessage());
        char subc = encodingCharacters.getSubcomponentSeparator();
        char cmpc = encodingCharacters.getComponentSeparator();
        this.clear();
        int subcIndex = string.indexOf(subc);
        int cmpcIndex = string.indexOf(cmpc);
        if (subcIndex != -1 || cmpcIndex != -1) {
            this.setValue(string.substring(0, subcIndex));
            while (subcIndex != -1) {
                int prevIndex = subcIndex + 1;
                if ((subcIndex = string.indexOf(subc, prevIndex)) == -1) continue;
                String nextSubComponent = string.substring(prevIndex, subcIndex);
                this.getExtraComponents().getComponent(this.getExtraComponents().numComponents()).parse(nextSubComponent);
            }
        } else {
            this.setValue(string);
        }
    }

    public void clear() {
        super.clear();
        this.myValue = null;
        this.getExtraComponents().clear();
    }
}

