/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2;

import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;

public class HL7Exception
extends Exception {
    private static final HapiLog ourLog = HapiLogFactory.getHapiLog(HL7Exception.class);
    public static final int ACK_AA = 1;
    public static final int ACK_AE = 2;
    public static final int ACK_AR = 3;
    public static final int ACK_CA = 4;
    public static final int ACK_CE = 5;
    public static final int ACK_CR = 6;
    public static final int MESSAGE_ACCEPTED = 0;
    public static final int SEGMENT_SEQUENCE_ERROR = 100;
    public static final int REQUIRED_FIELD_MISSING = 101;
    public static final int DATA_TYPE_ERROR = 102;
    public static final int TABLE_VALUE_NOT_FOUND = 103;
    public static final int UNSUPPORTED_MESSAGE_TYPE = 200;
    public static final int UNSUPPORTED_EVENT_CODE = 201;
    public static final int UNSUPPORTED_PROCESSING_ID = 202;
    public static final int UNSUPPORTED_VERSION_ID = 203;
    public static final int UNKNOWN_KEY_IDENTIFIER = 204;
    public static final int DUPLICATE_KEY_IDENTIFIER = 205;
    public static final int APPLICATION_RECORD_LOCKED = 206;
    public static final int APPLICATION_INTERNAL_ERROR = 207;
    private String segment = null;
    private int segmentRep = -1;
    private int fieldPosition = -1;
    private int errCode = -1;

    public HL7Exception(String message, int errorCondition, Throwable cause) {
        super(message, cause);
        this.errCode = errorCondition;
    }

    public HL7Exception(String message, int errorCondition) {
        super(message);
        this.errCode = errorCondition;
    }

    public HL7Exception(String message, Throwable cause) {
        super(message, cause);
        this.errCode = 207;
    }

    public HL7Exception(Throwable cause) {
        super(cause);
        this.errCode = 207;
    }

    public HL7Exception(String message) {
        super(message);
        this.errCode = 207;
    }

    public void setSegmentName(String segmentName) {
        this.segment = segmentName;
    }

    public String getSegmentName() {
        return this.segment;
    }

    public void setSegmentRepetition(int sequenceNum) {
        this.segmentRep = sequenceNum;
    }

    public int getSegmentRepetition() {
        return this.segmentRep;
    }

    public void setFieldPosition(int fieldNum) {
        this.fieldPosition = fieldNum;
    }

    public int getFieldPosition() {
        return this.fieldPosition;
    }

    public int getErrorCode() {
        return this.errCode;
    }

    public String getMessage() {
        StringBuffer msg = new StringBuffer();
        msg.append(super.getMessage());
        if (this.getSegmentName() != null) {
            msg.append(": Segment: ");
            msg.append(this.getSegmentName());
        }
        if (this.getSegmentRepetition() != -1) {
            msg.append(" (rep ");
            msg.append(this.getSegmentRepetition());
            msg.append(")");
        }
        if (this.getFieldPosition() != -1) {
            msg.append(" Field #");
            msg.append(this.getFieldPosition());
        }
        return msg.toString();
    }

    public void populate(Segment errorSegment, String theJdbcUrl) throws HL7Exception {
        if (!errorSegment.getName().equals("ERR")) {
            throw new HL7Exception("Can only populate an ERR segment with an exception -- got: " + errorSegment.getClass().getName());
        }
        int rep = errorSegment.getField(1).length;
        if (this.getSegmentName() != null) {
            Terser.set(errorSegment, 1, rep, 1, 1, this.getSegmentName());
        }
        if (this.getSegmentRepetition() >= 0) {
            Terser.set(errorSegment, 1, rep, 2, 1, String.valueOf(this.getSegmentRepetition()));
        }
        if (this.getFieldPosition() >= 0) {
            Terser.set(errorSegment, 1, rep, 3, 1, String.valueOf(this.getFieldPosition()));
        }
        Terser.set(errorSegment, 1, rep, 4, 1, String.valueOf(this.errCode));
        Terser.set(errorSegment, 1, rep, 4, 3, "hl70357");
        Terser.set(errorSegment, 1, rep, 4, 5, this.getMessage());
        String desc = "ERROR";
        Terser.set(errorSegment, 1, rep, 4, 2, desc);
    }
}

