/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum DeviceStatusEnum {
    AVAILABLE("available", "http://hl7.org/fhir/devicestatus"),
    NOT_AVAILABLE("not-available", "http://hl7.org/fhir/devicestatus"),
    ENTERED_IN_ERROR("entered-in-error", "http://hl7.org/fhir/devicestatus");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "DeviceStatus";
    private static Map<String, DeviceStatusEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, DeviceStatusEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<DeviceStatusEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static DeviceStatusEnum forCode(String theCode) {
        DeviceStatusEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private DeviceStatusEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, DeviceStatusEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, DeviceStatusEnum>>();
        for (DeviceStatusEnum next : DeviceStatusEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<DeviceStatusEnum>(){

            public String toCodeString(DeviceStatusEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(DeviceStatusEnum theEnum) {
                return theEnum.getSystem();
            }

            public DeviceStatusEnum fromCodeString(String theCodeString) {
                return (DeviceStatusEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public DeviceStatusEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (DeviceStatusEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

