/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.util.concurrent;

import ca.odell.glazedlists.util.concurrent.Lock;

class LockPair
implements Lock {
    private Lock first;
    private Lock second;

    public LockPair(Lock first, Lock second) {
        this.first = first;
        this.second = second;
    }

    public void lock() {
        this.first.lock();
        this.second.lock();
    }

    public boolean tryLock() {
        boolean firstSuccess = this.first.tryLock();
        if (!firstSuccess) {
            return false;
        }
        boolean secondSuccess = this.second.tryLock();
        if (!secondSuccess) {
            this.first.unlock();
            return false;
        }
        return true;
    }

    public void unlock() {
        this.second.unlock();
        this.first.unlock();
    }
}

