/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swt;

import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.AbstractTableComparatorChooser;
import ca.odell.glazedlists.swt.EventTableViewer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public final class TableComparatorChooser
extends AbstractTableComparatorChooser {
    private Table table;
    private List sortListeners = new ArrayList();
    private ColumnListener columnListener = new ColumnListener();

    public TableComparatorChooser(EventTableViewer eventTableViewer, SortedList sortedList, boolean multipleColumnSort) {
        super(sortedList, eventTableViewer.getTableFormat(), multipleColumnSort);
        this.table = eventTableViewer.getTable();
        for (int c = 0; c < this.table.getColumnCount(); ++c) {
            this.table.getColumn(c).addSelectionListener((SelectionListener)this.columnListener);
        }
    }

    public void addSortListener(Listener sortListener) {
        this.sortListeners.add(sortListener);
    }

    public void removeSortActionListener(Listener sortListener) {
        Iterator i = this.sortListeners.iterator();
        while (i.hasNext()) {
            if (sortListener != i.next()) continue;
            i.remove();
            return;
        }
        throw new IllegalArgumentException("Cannot remove nonexistant listener " + sortListener);
    }

    protected final void rebuildComparator() {
        super.rebuildComparator();
        Event sortEvent = new Event();
        sortEvent.widget = this.table;
        Iterator i = this.sortListeners.iterator();
        while (i.hasNext()) {
            Listener listener = (Listener)i.next();
            listener.handleEvent(sortEvent);
        }
    }

    public void dispose() {
        for (int c = 0; c < this.table.getColumnCount(); ++c) {
            this.table.getColumn(c).removeSelectionListener((SelectionListener)this.columnListener);
        }
    }

    class ColumnListener
    implements SelectionListener {
        ColumnListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn column = (TableColumn)e.widget;
            Table table = column.getParent();
            int columnIndex = table.indexOf(column);
            TableComparatorChooser.this.columnClicked(columnIndex, 1);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

