/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swt;

import ca.odell.glazedlists.AbstractFilterList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.CheckableTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swt.CheckWrapped;
import ca.odell.glazedlists.swt.CheckableWrapperList;
import ca.odell.glazedlists.swt.EventTableViewer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

final class TableCheckFilterList
extends AbstractFilterList
implements SelectionListener {
    private boolean checkedOnly = false;
    private Table table;
    private CheckableTableFormat checkableTableFormat;

    public TableCheckFilterList(EventList source, Table table, TableFormat tableFormat) {
        super(tableFormat instanceof CheckableTableFormat ? source : new CheckableWrapperList(source));
        this.table = table;
        this.checkableTableFormat = tableFormat instanceof CheckableTableFormat ? (CheckableTableFormat)tableFormat : null;
        table.addSelectionListener((SelectionListener)this);
        this.handleFilterChanged();
    }

    private void setChecked(Object element, boolean checked) {
        if (this.checkableTableFormat != null) {
            this.checkableTableFormat.setChecked(element, checked);
        } else {
            ((CheckWrapped)element).setChecked(checked);
        }
    }

    private void setChecked(int index, boolean checked) {
        this.setChecked(this.source.get(this.getSourceIndex(index)), checked);
    }

    private boolean getChecked(Object element) {
        if (this.checkableTableFormat != null) {
            return this.checkableTableFormat.getChecked(element);
        }
        return ((CheckWrapped)element).getChecked();
    }

    private boolean getChecked(int index) {
        return this.getChecked(this.source.get(this.getSourceIndex(index)));
    }

    public boolean filterMatches(Object element) {
        if (this.checkedOnly) {
            return this.getChecked(element);
        }
        return true;
    }

    public List getAllChecked() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < this.size(); ++i) {
            if (!this.getChecked(i)) continue;
            result.add(this.get(i));
        }
        return result;
    }

    public void setCheckedOnly(boolean checkedOnly) {
        if (checkedOnly != this.checkedOnly) {
            this.checkedOnly = checkedOnly;
            this.handleFilterChanged();
        }
    }

    public boolean getCheckedOnly() {
        return this.checkedOnly;
    }

    public Object get(int index) {
        if (this.checkableTableFormat != null) {
            return super.get(index);
        }
        CheckWrapped checkWrapped = (CheckWrapped)super.get(index);
        return checkWrapped.getWrapped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void widgetSelected(SelectionEvent e) {
        if (e.detail == 32) {
            this.getReadWriteLock().writeLock().lock();
            try {
                this.updateItemChecked((TableItem)e.item);
            }
            finally {
                this.getReadWriteLock().writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.detail == 32) {
            this.getReadWriteLock().writeLock().lock();
            try {
                this.updateItemChecked((TableItem)e.item);
            }
            finally {
                this.getReadWriteLock().writeLock().unlock();
            }
        }
    }

    private void updateItemChecked(TableItem updated) {
        if (updated == null) {
            return;
        }
        int index = this.table.indexOf(updated);
        boolean checked = updated.getChecked();
        this.setChecked(index, checked);
        int sourceIndex = this.getSourceIndex(index);
        this.source.set(sourceIndex, this.source.get(sourceIndex));
    }

    public void addListEventListener(ListEventListener listChangeListener) {
        super.addListEventListener(listChangeListener);
        if (listChangeListener instanceof EventTableViewer) {
            super.addListEventListener(new TableChecker());
        }
    }

    public void dispose() {
        if (this.source instanceof CheckableWrapperList) {
            ((CheckableWrapperList)this.source).dispose();
        }
        super.dispose();
    }

    private class TableChecker
    implements ListEventListener {
        public TableChecker() {
            for (int i = 0; i < TableCheckFilterList.this.size(); ++i) {
                boolean checked = TableCheckFilterList.this.getChecked(i);
                TableCheckFilterList.this.table.getItem(i).setChecked(checked);
            }
        }

        public void listChanged(ListEvent listChanges) {
            while (listChanges.next()) {
                int changeIndex = listChanges.getIndex();
                int changeType = listChanges.getType();
                if (changeType != 2 && changeType != 1) continue;
                boolean checked = TableCheckFilterList.this.getChecked(changeIndex);
                TableCheckFilterList.this.table.getItem(changeIndex).setChecked(checked);
            }
        }
    }
}

