/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.TextMatcherEditor;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextFilterList
extends TransformedList {
    private TextMatcherEditor textMatcherEditor;
    private JTextField filterEdit = null;
    private FilterEditListener filterEditListener = null;
    private FilterActionListener filterActionListener = new FilterActionListener();

    public TextFilterList(EventList source) {
        this(source, (TextFilterator)null, new JTextField(""));
    }

    public TextFilterList(EventList source, TextFilterator filterator) {
        this(source, filterator, new JTextField(""));
    }

    public TextFilterList(EventList source, String[] propertyNames) {
        this(source, GlazedLists.textFilterator(propertyNames), new JTextField(""));
    }

    public TextFilterList(EventList source, String[] propertyNames, JTextField filterEdit) {
        this(source, GlazedLists.textFilterator(propertyNames), filterEdit);
    }

    public TextFilterList(EventList source, TextFilterator filterator, JTextField filterEdit) {
        super(new FilterList(source));
        this.textMatcherEditor = new TextMatcherEditor(filterator);
        ((FilterList)this.source).setMatcherEditor(this.textMatcherEditor);
        this.setFilterEdit(filterEdit);
        this.source.addListEventListener(this);
    }

    public JTextField getFilterEdit() {
        return this.filterEdit;
    }

    public void setFilterEdit(JTextField filterEdit) {
        boolean live = true;
        if (this.filterEdit != null) {
            this.filterEdit.removeActionListener(this.filterActionListener);
            live = this.filterEditListener != null;
            this.setLive(false);
        }
        this.filterEdit = filterEdit;
        filterEdit.addActionListener(this.filterActionListener);
        this.setLive(live);
        this.reFilter();
    }

    public void setLive(boolean live) {
        if (live) {
            if (this.filterEditListener == null) {
                this.filterEditListener = new FilterEditListener();
                this.filterEdit.getDocument().addDocumentListener(this.filterEditListener);
            }
        } else if (this.filterEditListener != null) {
            this.filterEdit.getDocument().removeDocumentListener(this.filterEditListener);
            this.filterEditListener = null;
        }
    }

    public ActionListener getFilterActionListener() {
        return this.filterActionListener;
    }

    private void reFilter() {
        this.textMatcherEditor.setFilterText(this.filterEdit.getText().split("[ \t]"));
    }

    public void listChanged(ListEvent listChanges) {
        this.updates.forwardEvent(listChanges);
    }

    protected boolean isWritable() {
        return true;
    }

    public void dispose() {
        FilterList filteredSource = (FilterList)this.source;
        super.dispose();
        filteredSource.dispose();
    }

    private class FilterActionListener
    implements ActionListener {
        private FilterActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            TextFilterList.this.reFilter();
        }
    }

    private class FilterEditListener
    implements DocumentListener {
        private FilterEditListener() {
        }

        public void changedUpdate(DocumentEvent e) {
            TextFilterList.this.reFilter();
        }

        public void insertUpdate(DocumentEvent e) {
            TextFilterList.this.reFilter();
        }

        public void removeUpdate(DocumentEvent e) {
            TextFilterList.this.reFilter();
        }
    }
}

