/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.TextMatcherEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class TextComponentMatcherEditor
extends TextMatcherEditor {
    private Document document;
    private JTextField textField;
    private FilterHandler filterHandler = new FilterHandler();

    public TextComponentMatcherEditor(JTextComponent textComponent, TextFilterator textFilterator) {
        this(textComponent, textFilterator, true);
    }

    public TextComponentMatcherEditor(JTextComponent textComponent, TextFilterator textFilterator, boolean live) {
        super(textFilterator);
        if (live) {
            this.document = textComponent.getDocument();
            this.document.addDocumentListener(this.filterHandler);
        } else {
            if (!(textComponent instanceof JTextField)) {
                throw new IllegalArgumentException("Non-live filtering supported only for JTextField (argument class " + textComponent.getClass().getName() + ")");
            }
            this.textField = (JTextField)textComponent;
            this.document = this.textField.getDocument();
            this.textField.addActionListener(this.filterHandler);
        }
        this.refilter();
    }

    public TextComponentMatcherEditor(Document document, TextFilterator textFilterator) {
        super(textFilterator);
        this.document = document;
        this.document.addDocumentListener(this.filterHandler);
        this.refilter();
    }

    public void dispose() {
        if (this.textField != null) {
            this.textField.removeActionListener(this.filterHandler);
        } else {
            this.document.removeDocumentListener(this.filterHandler);
        }
    }

    private void refilter() {
        try {
            this.setFilterText(this.document.getText(0, this.document.getLength()).split("[ \t]"));
        }
        catch (BadLocationException ble) {
            throw new RuntimeException(ble);
        }
    }

    private class FilterHandler
    implements DocumentListener,
    ActionListener {
        private FilterHandler() {
        }

        public void insertUpdate(DocumentEvent e) {
            TextComponentMatcherEditor.this.refilter();
        }

        public void removeUpdate(DocumentEvent e) {
            TextComponentMatcherEditor.this.refilter();
        }

        public void changedUpdate(DocumentEvent e) {
            TextComponentMatcherEditor.this.refilter();
        }

        public void actionPerformed(ActionEvent e) {
            TextComponentMatcherEditor.this.refilter();
        }
    }
}

