/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.gui.WritableTableFormat;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.MutableTableModelEvent;
import javax.swing.table.AbstractTableModel;

public class EventTableModel
extends AbstractTableModel
implements ListEventListener {
    private TransformedList swingSource = null;
    private TableFormat tableFormat;
    private MutableTableModelEvent tableModelEvent = new MutableTableModelEvent(this);

    public EventTableModel(EventList source, TableFormat tableFormat) {
        this.swingSource = GlazedListsSwing.swingThreadProxyList(source);
        this.tableFormat = tableFormat;
        this.swingSource.addListEventListener(this);
    }

    public EventTableModel(EventList source, String[] propertyNames, String[] columnLabels, boolean[] writable) {
        this(source, GlazedLists.tableFormat(propertyNames, columnLabels, writable));
    }

    public TableFormat getTableFormat() {
        return this.tableFormat;
    }

    public void setTableFormat(TableFormat tableFormat) {
        this.tableFormat = tableFormat;
        this.tableModelEvent.setStructureChanged();
        this.fireTableChanged(this.tableModelEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getElementAt(int index) {
        this.swingSource.getReadWriteLock().readLock().lock();
        try {
            if (index < this.swingSource.size()) {
                Object object = this.swingSource.get(index);
                return object;
            }
            Object var2_3 = null;
            return var2_3;
        }
        finally {
            this.swingSource.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listChanged(ListEvent listChanges) {
        this.swingSource.getReadWriteLock().readLock().lock();
        try {
            while (listChanges.nextBlock()) {
                int startIndex = listChanges.getBlockStartIndex();
                int endIndex = listChanges.getBlockEndIndex();
                int changeType = listChanges.getType();
                this.tableModelEvent.setValues(startIndex, endIndex, changeType);
                this.fireTableChanged(this.tableModelEvent);
            }
        }
        finally {
            this.swingSource.getReadWriteLock().readLock().unlock();
        }
    }

    public String getColumnName(int column) {
        return this.tableFormat.getColumnName(column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        this.swingSource.getReadWriteLock().readLock().lock();
        try {
            int n = this.swingSource.size();
            return n;
        }
        finally {
            this.swingSource.getReadWriteLock().readLock().unlock();
        }
    }

    public int getColumnCount() {
        return this.tableFormat.getColumnCount();
    }

    public Class getColumnClass(int columnIndex) {
        if (this.tableFormat instanceof AdvancedTableFormat) {
            return ((AdvancedTableFormat)this.tableFormat).getColumnClass(columnIndex);
        }
        return super.getColumnClass(columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int row, int column) {
        this.swingSource.getReadWriteLock().readLock().lock();
        try {
            if (row < this.getRowCount()) {
                Object object = this.tableFormat.getColumnValue(this.swingSource.get(row), column);
                return object;
            }
            Object var3_4 = null;
            return var3_4;
        }
        finally {
            this.swingSource.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCellEditable(int row, int column) {
        if (this.tableFormat instanceof WritableTableFormat) {
            WritableTableFormat writableTableFormat = (WritableTableFormat)this.tableFormat;
            this.swingSource.getReadWriteLock().readLock().lock();
            try {
                Object toEdit = this.swingSource.get(row);
                boolean bl = writableTableFormat.isEditable(toEdit, column);
                return bl;
            }
            finally {
                this.swingSource.getReadWriteLock().readLock().unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValueAt(Object editedValue, int row, int column) {
        if (!(this.tableFormat instanceof WritableTableFormat)) throw new UnsupportedOperationException("Unexpected set() on read-only table");
        this.swingSource.getReadWriteLock().writeLock().lock();
        try {
            WritableTableFormat writableTableFormat = (WritableTableFormat)this.tableFormat;
            Object baseObject = this.swingSource.get(row);
            Object updatedObject = writableTableFormat.setColumnValue(baseObject, editedValue, column);
            if (updatedObject == null) return;
            this.swingSource.set(row, updatedObject);
            return;
        }
        finally {
            this.swingSource.getReadWriteLock().writeLock().unlock();
        }
    }

    public void dispose() {
        this.swingSource.dispose();
    }
}

