/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.filter;

import ca.odell.glazedlists.Matcher;
import ca.odell.glazedlists.TextFilterable;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.impl.filter.BoyerMooreCaseInsensitiveTextSearchStrategy;
import ca.odell.glazedlists.impl.filter.SingleCharacterCaseInsensitiveTextSearchStrategy;
import ca.odell.glazedlists.impl.filter.TextSearchStrategy;
import java.util.ArrayList;
import java.util.List;

public class TextMatcher
implements Matcher {
    private final TextFilterator filterator;
    private final TextSearchStrategy[] filterStrategies;
    private final List filterStrings = new ArrayList();

    public TextMatcher(String[] filters, TextFilterator filterator) {
        this.filterator = filterator;
        this.filterStrategies = new TextSearchStrategy[filters.length];
        for (int i = 0; i < filters.length; ++i) {
            this.filterStrategies[i] = TextMatcher.selectTextSearchStrategy(filters[i]);
        }
    }

    public boolean matches(Object element) {
        this.filterStrings.clear();
        if (this.filterator == null) {
            ((TextFilterable)element).getFilterStrings(this.filterStrings);
        } else {
            this.filterator.getFilterStrings(this.filterStrings, element);
        }
        block0: for (int f = 0; f < this.filterStrategies.length; ++f) {
            TextSearchStrategy textSearchStrategy = this.filterStrategies[f];
            for (int c = 0; c < this.filterStrings.size(); ++c) {
                Object filterString = this.filterStrings.get(c);
                if (filterString != null && textSearchStrategy.indexOf(filterString.toString()) != -1) continue block0;
            }
            return false;
        }
        return true;
    }

    private static TextSearchStrategy selectTextSearchStrategy(String filter) {
        TextSearchStrategy result = null;
        result = filter.length() == 1 ? new SingleCharacterCaseInsensitiveTextSearchStrategy() : new BoyerMooreCaseInsensitiveTextSearchStrategy();
        result.setSubtext(filter);
        return result;
    }

    public static String[] normalizeFilters(String[] filterStrings) {
        int i;
        boolean[] minimalFilter = new boolean[filterStrings.length];
        int validFilters = 0;
        for (i = 0; i < filterStrings.length; ++i) {
            if (filterStrings[i] == null || filterStrings[i].length() <= 0) continue;
            ++validFilters;
            minimalFilter[i] = true;
        }
        block1: for (i = 0; i < minimalFilter.length; ++i) {
            if (!minimalFilter[i]) continue;
            for (int j = 0; j < minimalFilter.length; ++j) {
                if (!minimalFilter[j] || i == j || filterStrings[j].indexOf(filterStrings[i]) == -1) continue;
                minimalFilter[i] = false;
                --validFilters;
                continue block1;
            }
        }
        String[] upperCaseFilterStrings = new String[validFilters];
        int i2 = 0;
        int j = 0;
        while (j < validFilters) {
            if (minimalFilter[i2]) {
                upperCaseFilterStrings[j++] = filterStrings[i2].toUpperCase();
            }
            ++i2;
        }
        return upperCaseFilterStrings;
    }

    public static boolean isFilterEqual(String[] oldFilters, String[] newFilters) {
        int j;
        int i;
        block0: for (i = 0; i < newFilters.length; ++i) {
            for (j = 0; j < oldFilters.length; ++j) {
                if (oldFilters[j].equals(newFilters[i])) continue block0;
            }
            return false;
        }
        block2: for (i = 0; i < oldFilters.length; ++i) {
            for (j = 0; j < newFilters.length; ++j) {
                if (newFilters[j].equals(oldFilters[i])) continue block2;
            }
            return false;
        }
        return true;
    }

    public static boolean isFilterRelaxed(String[] oldFilters, String[] newFilters) {
        int j;
        int i;
        block0: for (i = 0; i < newFilters.length; ++i) {
            for (j = 0; j < oldFilters.length; ++j) {
                if (oldFilters[j].indexOf(newFilters[i]) != -1) continue block0;
            }
            return false;
        }
        block2: for (i = 0; i < oldFilters.length; ++i) {
            for (j = 0; j < newFilters.length; ++j) {
                if (newFilters[j].indexOf(oldFilters[i]) != -1) continue block2;
            }
            return true;
        }
        return false;
    }

    public static boolean isFilterConstrained(String[] oldFilter, String[] newFilter) {
        return TextMatcher.isFilterRelaxed(newFilter, oldFilter);
    }
}

