/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.filter;

import ca.odell.glazedlists.impl.filter.TextSearchStrategy;
import java.util.Arrays;

public class BoyerMooreCaseInsensitiveTextSearchStrategy
implements TextSearchStrategy {
    private static final int CHARACTER_CACHE_SIZE = 256;
    private int subtextLength;
    private int lastSubtextIndex;
    private char[] subtextChars;
    private int[] shiftTable = new int[256];
    private static final char[] UPPER_CASE_CACHE = new char[256];

    public void setSubtext(String subtext) {
        this.subtextLength = subtext.length();
        this.lastSubtextIndex = this.subtextLength - 1;
        this.subtextChars = subtext.toUpperCase().toCharArray();
        Arrays.fill(this.shiftTable, 0, this.shiftTable.length, this.subtextLength);
        for (int i = 0; i < this.lastSubtextIndex; ++i) {
            this.shiftTable[this.subtextChars[i] % 256] = this.lastSubtextIndex - i;
        }
    }

    public int indexOf(String text) {
        int subtextPosition;
        if (this.subtextChars == null) {
            throw new IllegalStateException("setSubtext must be called with a valid value before this method can operate");
        }
        char upperCase = ' ';
        int textLength = text.length();
        for (int textPosition = this.lastSubtextIndex; textPosition < textLength; textPosition += Math.max(this.shiftTable[upperCase % 256], this.subtextLength - subtextPosition)) {
            subtextPosition = this.lastSubtextIndex;
            if (subtextPosition >= 0) {
                upperCase = BoyerMooreCaseInsensitiveTextSearchStrategy.toUpperCase(text.charAt(textPosition));
                while (subtextPosition >= 0 && this.subtextChars[subtextPosition] == upperCase) {
                    --subtextPosition;
                    if (--textPosition == -1) continue;
                    upperCase = BoyerMooreCaseInsensitiveTextSearchStrategy.toUpperCase(text.charAt(textPosition));
                }
            }
            if (subtextPosition != -1) continue;
            return textPosition + 1;
        }
        return -1;
    }

    private static char toUpperCase(char anyCase) {
        return anyCase < UPPER_CASE_CACHE.length ? UPPER_CASE_CACHE[anyCase] : Character.toUpperCase(anyCase);
    }

    static {
        for (char c = '\u0000'; c < UPPER_CASE_CACHE.length; c = (char)(c + '\u0001')) {
            BoyerMooreCaseInsensitiveTextSearchStrategy.UPPER_CASE_CACHE[c] = Character.toUpperCase(c);
        }
    }
}

