/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.impl.adt.IndexedTreeIterator;
import ca.odell.glazedlists.impl.adt.IndexedTreeNode;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Random;

public final class IndexedTree {
    private Comparator comparator;
    IndexedTreeNode root = null;

    public IndexedTree(Comparator comparator) {
        this.comparator = comparator;
    }

    public IndexedTree() {
        this.comparator = null;
    }

    public Object get(int index) {
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("cannot get from tree of size " + this.size() + " at " + index);
        }
        IndexedTreeNode treeNode = this.root.getNodeWithIndex(index);
        return treeNode.getValue();
    }

    public IndexedTreeNode getNode(int index) {
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("cannot get from tree of size " + this.size() + " at " + index);
        }
        return this.root.getNodeWithIndex(index);
    }

    public IndexedTreeNode getNode(Object value) {
        if (this.root == null) {
            return null;
        }
        return this.root.getNodeByValue(this.comparator, value);
    }

    public int size() {
        if (this.root == null) {
            return 0;
        }
        return this.root.size();
    }

    public Iterator iterator() {
        return new IndexedTreeIterator(this);
    }

    public ListIterator listIterator() {
        return new IndexedTreeIterator(this);
    }

    public ListIterator listIterator(int index) {
        return new IndexedTreeIterator(this, index);
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public IndexedTreeNode removeByIndex(int index) {
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("cannot get from tree of size " + this.size() + " at " + index);
        }
        return this.root.removeNode(this, index);
    }

    public IndexedTreeNode addByNode(Object value) {
        if (this.root == null) {
            this.root = new IndexedTreeNode(null);
        }
        return this.root.insert(this, value);
    }

    public IndexedTreeNode addByNode(int index, Object value) {
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("cannot insert into tree of size " + this.size() + " at " + index);
        }
        if (value == null) {
            throw new NullPointerException("cannot insert a value that is null");
        }
        if (this.root == null && index == 0) {
            this.root = new IndexedTreeNode(null);
        }
        return this.root.insert(this, index, value);
    }

    public boolean contains(Object object) {
        if (this.root == null) {
            return false;
        }
        return this.root.contains(this.comparator, object);
    }

    public boolean containsAll(Collection collection) {
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Object a = i.next();
            if (this.contains(a)) continue;
            return false;
        }
        return true;
    }

    public int indexOf(Object object) {
        if (this.root == null) {
            return -1;
        }
        return this.root.indexOf(this.comparator, object, false);
    }

    public int lastIndexOf(Object object) {
        if (this.root == null) {
            return -1;
        }
        return this.root.lastIndexOf(this.comparator, object);
    }

    public int indexOfSimulated(Object object) {
        if (this.root == null) {
            return 0;
        }
        return this.root.indexOf(this.comparator, object, true);
    }

    void validate() {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            IndexedTreeNode node = (IndexedTreeNode)i.next();
            node.validate(this);
        }
    }

    public String toString() {
        if (this.root == null) {
            return ".";
        }
        return this.root.toString();
    }

    void setRootNode(IndexedTreeNode root) {
        this.root = root;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: IndexedTree <operations> <repetitions>");
            return;
        }
        int operations = Integer.parseInt(args[0]);
        int repetitions = Integer.parseInt(args[1]);
        Random random = new Random();
        System.out.print("Indexed Tree ");
        long start = System.currentTimeMillis();
        for (int r = 0; r < repetitions; ++r) {
            IndexedTree tree = new IndexedTree(GlazedLists.comparableComparator());
            for (int i = 0; i < operations; ++i) {
                int operation = (int)(random.nextDouble() * 3.0);
                if (operation <= 1 || tree.size() == 0) {
                    Integer value = new Integer((int)(random.nextDouble() * 2.147483647E9));
                    tree.addByNode(value);
                    continue;
                }
                int index = (int)(random.nextDouble() * (double)tree.size());
                tree.removeByIndex(index);
            }
        }
        long total = System.currentTimeMillis() - start;
        System.out.println("time: " + total);
    }
}

