/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.gui;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.sort.ComparatorChain;
import ca.odell.glazedlists.impl.sort.ReverseComparator;
import ca.odell.glazedlists.impl.sort.TableColumnComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractTableComparatorChooser {
    protected SortedList sortedList;
    private TableFormat tableFormat;
    protected Comparator sortedListComparator = null;
    protected ColumnClickTracker[] columnClickTrackers;
    protected int primaryColumn = -1;
    protected ArrayList recentlyClickedColumns = new ArrayList();
    protected boolean multipleColumnSort;
    protected static final int COLUMN_UNSORTED = 0;
    protected static final int COLUMN_PRIMARY_SORTED = 1;
    protected static final int COLUMN_PRIMARY_SORTED_REVERSE = 2;
    protected static final int COLUMN_PRIMARY_SORTED_ALTERNATE = 3;
    protected static final int COLUMN_PRIMARY_SORTED_ALTERNATE_REVERSE = 4;
    protected static final int COLUMN_SECONDARY_SORTED = 5;
    protected static final int COLUMN_SECONDARY_SORTED_REVERSE = 6;
    protected static final int COLUMN_SECONDARY_SORTED_ALTERNATE = 7;
    protected static final int COLUMN_SECONDARY_SORTED_ALTERNATE_REVERSE = 8;
    static /* synthetic */ Class class$ca$odell$glazedlists$gui$AbstractTableComparatorChooser;

    protected AbstractTableComparatorChooser(SortedList sortedList, TableFormat tableFormat, boolean multipleColumnSort) {
        this.sortedList = sortedList;
        this.tableFormat = tableFormat;
        this.multipleColumnSort = multipleColumnSort;
        this.rebuildColumns();
    }

    protected void rebuildColumns() {
        this.columnClickTrackers = new ColumnClickTracker[this.tableFormat.getColumnCount()];
        for (int i = 0; i < this.columnClickTrackers.length; ++i) {
            this.columnClickTrackers[i] = new ColumnClickTracker(this.tableFormat, i);
        }
        this.primaryColumn = -1;
        this.recentlyClickedColumns.clear();
    }

    public List getComparatorsForColumn(int column) {
        return this.columnClickTrackers[column].getComparators();
    }

    public List getSortingColumns() {
        ArrayList<Integer> sortingColumns = new ArrayList<Integer>();
        for (int c = 0; c < this.recentlyClickedColumns.size(); ++c) {
            ColumnClickTracker clickedColumn = (ColumnClickTracker)this.recentlyClickedColumns.get(c);
            sortingColumns.add(new Integer(clickedColumn.getColumn()));
        }
        return sortingColumns;
    }

    public int getColumnComparatorIndex(int column) {
        return this.columnClickTrackers[column].getComparatorIndex();
    }

    public boolean isColumnReverse(int column) {
        return this.columnClickTrackers[column].isReverse();
    }

    public void chooseComparator(int column, int comparatorIndex, boolean reverse) {
        if (column > this.columnClickTrackers.length) {
            throw new IllegalArgumentException("invalid column " + column + ", must be in range 0, " + this.columnClickTrackers.length);
        }
        if (comparatorIndex > this.getComparatorsForColumn(column).size()) {
            throw new IllegalArgumentException("invalid comparator index " + comparatorIndex + ", must be in range 0, " + this.getComparatorsForColumn(column).size());
        }
        Iterator i = this.recentlyClickedColumns.iterator();
        while (i.hasNext()) {
            ColumnClickTracker columnClickTracker = (ColumnClickTracker)i.next();
            columnClickTracker.resetClickCount();
        }
        this.primaryColumn = -1;
        this.recentlyClickedColumns.clear();
        ColumnClickTracker currentTracker = this.columnClickTrackers[column];
        currentTracker.setComparatorIndex(comparatorIndex);
        currentTracker.setReverse(reverse);
        this.primaryColumn = column;
        this.recentlyClickedColumns.add(currentTracker);
        this.rebuildComparator();
    }

    protected void columnClicked(int column, int clicks) {
        ColumnClickTracker currentTracker = this.columnClickTrackers[column];
        if (currentTracker.getComparators().isEmpty()) {
            return;
        }
        if (clicks == 2) {
            Iterator i = this.recentlyClickedColumns.iterator();
            while (i.hasNext()) {
                ColumnClickTracker columnClickTracker = (ColumnClickTracker)i.next();
                columnClickTracker.resetClickCount();
            }
            this.primaryColumn = -1;
            this.recentlyClickedColumns.clear();
        } else if (!this.multipleColumnSort) {
            Iterator i = this.recentlyClickedColumns.iterator();
            while (i.hasNext()) {
                ColumnClickTracker columnClickTracker = (ColumnClickTracker)i.next();
                if (columnClickTracker == currentTracker) continue;
                columnClickTracker.resetClickCount();
            }
            this.primaryColumn = -1;
            this.recentlyClickedColumns.clear();
        }
        currentTracker.addClick();
        if (this.recentlyClickedColumns.isEmpty()) {
            this.recentlyClickedColumns.add(currentTracker);
            this.primaryColumn = column;
        } else if (!this.recentlyClickedColumns.contains(currentTracker)) {
            this.recentlyClickedColumns.add(currentTracker);
        }
        this.rebuildComparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildComparator() {
        if (!this.recentlyClickedColumns.isEmpty()) {
            ArrayList<Comparator> comparators = new ArrayList<Comparator>();
            Iterator i = this.recentlyClickedColumns.iterator();
            while (i.hasNext()) {
                ColumnClickTracker columnClickTracker = (ColumnClickTracker)i.next();
                Comparator comparator = columnClickTracker.getComparator();
                comparators.add(comparator);
            }
            ComparatorChain comparatorChain = (ComparatorChain)GlazedLists.chainComparators(comparators);
            this.sortedList.getReadWriteLock().writeLock().lock();
            try {
                this.sortedListComparator = comparatorChain;
                this.sortedList.setComparator(comparatorChain);
            }
            finally {
                this.sortedList.getReadWriteLock().writeLock().unlock();
            }
        }
    }

    protected void redetectComparator(Comparator currentComparator) {
        this.sortedListComparator = currentComparator;
        for (int c = 0; c < this.columnClickTrackers.length; ++c) {
            this.columnClickTrackers[c].resetClickCount();
        }
        this.primaryColumn = -1;
        this.recentlyClickedColumns.clear();
        ArrayList<Comparator> comparatorsList = new ArrayList<Comparator>();
        if (this.sortedListComparator != null) {
            if (this.sortedListComparator instanceof ComparatorChain) {
                ComparatorChain chain = (ComparatorChain)this.sortedListComparator;
                comparatorsList.addAll(chain.getComparators());
            } else {
                comparatorsList.add(this.sortedListComparator);
            }
        }
        Iterator i = comparatorsList.iterator();
        block1: while (i.hasNext()) {
            Comparator comparator = (Comparator)i.next();
            boolean reverse = false;
            if (comparator instanceof ReverseComparator) {
                reverse = true;
                comparator = ((ReverseComparator)comparator).getSourceComparator();
            }
            for (int c = 0; c < this.columnClickTrackers.length; ++c) {
                int comparatorIndex;
                if (this.recentlyClickedColumns.contains(this.columnClickTrackers[c]) || (comparatorIndex = this.columnClickTrackers[c].getComparators().indexOf(comparator)) == -1) continue;
                this.columnClickTrackers[c].setComparatorIndex(comparatorIndex);
                this.columnClickTrackers[c].setReverse(reverse);
                if (this.recentlyClickedColumns.isEmpty()) {
                    this.primaryColumn = c;
                }
                this.recentlyClickedColumns.add(this.columnClickTrackers[c]);
                if (!this.multipleColumnSort) break block1;
            }
        }
    }

    protected int getSortingStyle(int column) {
        return this.columnClickTrackers[column].getSortingStyle();
    }

    public Comparator createComparatorForElement(Comparator comparatorForColumn, int column) {
        return new TableColumnComparator(this.tableFormat, column, comparatorForColumn);
    }

    public void dispose() {
        this.sortedList = null;
        this.tableFormat = null;
        this.sortedListComparator = null;
    }

    private final class ColumnClickTracker {
        private int column = 0;
        private int clickCount = 0;
        private List comparators = new ArrayList();
        static final /* synthetic */ boolean $assertionsDisabled;

        public ColumnClickTracker(TableFormat tableFormat, int column) {
            this.column = column;
            if (tableFormat instanceof AdvancedTableFormat) {
                AdvancedTableFormat advancedTableFormat = (AdvancedTableFormat)tableFormat;
                Comparator columnComparator = advancedTableFormat.getColumnComparator(column);
                if (columnComparator != null) {
                    this.comparators.add(new TableColumnComparator(tableFormat, column, columnComparator));
                }
            } else {
                this.comparators.add(new TableColumnComparator(tableFormat, column));
            }
        }

        public void addClick() {
            ++this.clickCount;
        }

        public void resetClickCount() {
            this.clickCount = 0;
        }

        public int getColumn() {
            return this.column;
        }

        public void setReverse(boolean reverse) {
            if (this.isReverse() != reverse) {
                this.clickCount = reverse ? ++this.clickCount : --this.clickCount;
            }
        }

        public boolean isReverse() {
            return this.clickCount % 2 == 0;
        }

        public void setComparatorIndex(int comparatorIndex) {
            if (!$assertionsDisabled && comparatorIndex >= this.comparators.size()) {
                throw new AssertionError();
            }
            boolean wasReverse = this.isReverse();
            this.clickCount = comparatorIndex * 2 + 1;
            if (!wasReverse) {
                ++this.clickCount;
            }
        }

        public int getComparatorIndex() {
            if (this.comparators.size() == 0 || this.clickCount == 0) {
                return -1;
            }
            return (this.clickCount - 1) / 2 % this.comparators.size();
        }

        public List getComparators() {
            return this.comparators;
        }

        public Comparator getComparator() {
            Comparator comparator = (Comparator)this.comparators.get(this.getComparatorIndex());
            if (this.isReverse()) {
                comparator = GlazedLists.reverseComparator(comparator);
            }
            return comparator;
        }

        public int getSortingStyle() {
            if (this.clickCount == 0) {
                return 0;
            }
            if (this.column == AbstractTableComparatorChooser.this.primaryColumn) {
                if (!this.isReverse()) {
                    if (this.getComparatorIndex() == 0) {
                        return 1;
                    }
                    return 3;
                }
                if (this.getComparatorIndex() == 0) {
                    return 2;
                }
                return 4;
            }
            if (!this.isReverse()) {
                if (this.getComparatorIndex() == 0) {
                    return 5;
                }
                return 7;
            }
            if (this.getComparatorIndex() == 0) {
                return 6;
            }
            return 8;
        }

        static {
            $assertionsDisabled = !(class$ca$odell$glazedlists$gui$AbstractTableComparatorChooser == null ? (class$ca$odell$glazedlists$gui$AbstractTableComparatorChooser = AbstractTableComparatorChooser.class$("ca.odell.glazedlists.gui.AbstractTableComparatorChooser")) : class$ca$odell$glazedlists$gui$AbstractTableComparatorChooser).desiredAssertionStatus();
        }
    }
}

