/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.demo.issuebrowser.swt;

import ca.odell.glazedlists.AbstractFilterList;
import ca.odell.glazedlists.CollectionList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.UniqueList;
import ca.odell.glazedlists.demo.issuebrowser.Issue;
import ca.odell.glazedlists.demo.issuebrowser.IssueUserator;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.Iterator;
import java.util.List;

public class IssuesUserFilter
extends AbstractFilterList {
    EventList usersEventList = null;
    EventList usersSelectedList = null;

    public IssuesUserFilter(EventList source) {
        super(source);
        this.usersEventList = new UniqueList(new CollectionList(source, new IssueUserator()));
    }

    public void setSelectionList(EventList usersSelectedList) {
        this.usersSelectedList = usersSelectedList;
        usersSelectedList.addListEventListener(new SelectionChangeEventList());
    }

    public boolean filterMatches(Object o) {
        if (o == null) {
            return false;
        }
        if (this.usersSelectedList.isEmpty()) {
            return true;
        }
        Issue issue = (Issue)o;
        List users = issue.getAllUsers();
        Iterator u = users.iterator();
        while (u.hasNext()) {
            String user = (String)u.next();
            if (!this.usersSelectedList.contains(user)) continue;
            return true;
        }
        return false;
    }

    EventList getUsersList() {
        return this.usersEventList;
    }

    private final class SelectionChangeEventList
    implements ListEventListener {
        private SelectionChangeEventList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void listChanged(ListEvent listChanges) {
            IssuesUserFilter.this.getReadWriteLock().writeLock().lock();
            try {
                IssuesUserFilter.this.handleFilterChanged();
            }
            finally {
                IssuesUserFilter.this.getReadWriteLock().writeLock().unlock();
            }
        }
    }
}

