/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.demo.issuebrowser.swt;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.ThresholdList;
import ca.odell.glazedlists.UniqueList;
import ca.odell.glazedlists.demo.issuebrowser.Description;
import ca.odell.glazedlists.demo.issuebrowser.Issue;
import ca.odell.glazedlists.demo.issuebrowser.IssueLoader;
import ca.odell.glazedlists.demo.issuebrowser.IssueTableFormat;
import ca.odell.glazedlists.demo.issuebrowser.Project;
import ca.odell.glazedlists.demo.issuebrowser.Throbber;
import ca.odell.glazedlists.demo.issuebrowser.swt.IssuesUserFilter;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.matchers.ThreadedMatcherEditor;
import ca.odell.glazedlists.swt.EventListViewer;
import ca.odell.glazedlists.swt.EventTableViewer;
import ca.odell.glazedlists.swt.GlazedListsSWT;
import ca.odell.glazedlists.swt.TableComparatorChooser;
import ca.odell.glazedlists.swt.TextWidgetMatcherEditor;
import java.util.List;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class IssuesBrowser {
    private UniqueList issuesEventList = new UniqueList(new BasicEventList());
    private IssuesUserFilter issuesUserFiltered = null;
    private org.eclipse.swt.widgets.List usersList = null;
    private Text statusText = null;
    private IssueLoader issueLoader = new IssueLoader(this.issuesEventList, new IndeterminateToggler());

    private IssuesBrowser(Shell shell) {
        this.issuesUserFiltered = new IssuesUserFilter(this.issuesEventList);
        FilterList issuesTextFiltered = new FilterList(this.issuesUserFiltered);
        ThresholdList priorityList = new ThresholdList((EventList)issuesTextFiltered, "priority.rating");
        SortedList issuesSortedList = new SortedList(priorityList);
        SashForm demoForm = new SashForm((Composite)shell, 256);
        GridData demoFormLayout = new GridData();
        demoFormLayout.horizontalAlignment = 4;
        demoFormLayout.verticalAlignment = 4;
        demoFormLayout.grabExcessHorizontalSpace = true;
        demoFormLayout.grabExcessVerticalSpace = true;
        demoForm.setLayoutData((Object)demoFormLayout);
        GridLayout demoFormContentLayout = new GridLayout(2, false);
        demoFormContentLayout.marginHeight = 0;
        demoFormContentLayout.marginWidth = 0;
        demoForm.setLayout((Layout)demoFormContentLayout);
        Canvas filterPanel = new Canvas((Composite)demoForm, 2048);
        GridData filterPanelLayout = new GridData();
        filterPanelLayout.horizontalAlignment = 4;
        filterPanelLayout.verticalAlignment = 4;
        filterPanelLayout.grabExcessHorizontalSpace = true;
        filterPanelLayout.grabExcessVerticalSpace = true;
        filterPanel.setLayoutData((Object)filterPanelLayout);
        GridLayout filterPanelContentLayout = new GridLayout(1, false);
        filterPanelContentLayout.marginHeight = 10;
        filterPanelContentLayout.marginWidth = 10;
        filterPanelContentLayout.verticalSpacing = 15;
        filterPanel.setLayout((Layout)filterPanelContentLayout);
        Text filterText = this.createFilterText((Composite)filterPanel);
        issuesTextFiltered.setMatcherEditor(new ThreadedMatcherEditor(new TextWidgetMatcherEditor(filterText, null)));
        this.createPrioritySlider((Composite)filterPanel, priorityList);
        this.createUsersList(shell, (Composite)filterPanel);
        SashForm issuePanel = new SashForm((Composite)demoForm, 512);
        GridData issuePanelLayout = new GridData();
        issuePanelLayout.horizontalAlignment = 4;
        issuePanelLayout.verticalAlignment = 4;
        issuePanelLayout.grabExcessHorizontalSpace = true;
        issuePanelLayout.grabExcessVerticalSpace = true;
        issuePanel.setLayoutData((Object)issuePanelLayout);
        GridLayout issuePanelContentLayout = new GridLayout(1, false);
        issuePanelContentLayout.marginHeight = 0;
        issuePanelContentLayout.marginWidth = 0;
        issuePanel.setLayout((Layout)issuePanelContentLayout);
        Table issuesTable = this.createIssuesTable((Composite)issuePanel);
        EventTableViewer issuesTableViewer = new EventTableViewer(issuesSortedList, issuesTable, new IssueTableFormat());
        issuesTable = this.formatIssuesTable(issuesTable);
        new TableComparatorChooser(issuesTableViewer, issuesSortedList, false);
        this.createDescriptionsTable((Composite)issuePanel, issuesTableViewer);
        issuePanel.setWeights(new int[]{50, 50});
        demoForm.setWeights(new int[]{30, 70});
        this.issueLoader.start();
        this.issueLoader.setProject((Project)Project.getProjects().get(0));
    }

    private Text createFilterText(Composite parent) {
        Canvas textPanel = new Canvas(parent, 0);
        GridData textPanelLayout = new GridData();
        textPanelLayout.horizontalAlignment = 4;
        textPanelLayout.verticalAlignment = 1;
        textPanelLayout.grabExcessHorizontalSpace = true;
        textPanelLayout.grabExcessVerticalSpace = false;
        textPanel.setLayoutData((Object)textPanelLayout);
        GridLayout textPanelContentLayout = new GridLayout(1, false);
        textPanelContentLayout.marginHeight = 0;
        textPanelContentLayout.marginWidth = 0;
        textPanelContentLayout.verticalSpacing = 5;
        textPanel.setLayout((Layout)textPanelContentLayout);
        Label filterLabel = new Label((Composite)textPanel, 0x1000120);
        filterLabel.setText("Text Filter");
        FontData[] fontData = filterLabel.getFont().getFontData();
        fontData[0].setStyle(1);
        filterLabel.setFont(new Font((Device)textPanel.getDisplay(), fontData));
        GridData filterLabelLayout = new GridData();
        filterLabelLayout.horizontalAlignment = 1;
        filterLabelLayout.verticalAlignment = 2;
        filterLabelLayout.horizontalSpan = 2;
        filterLabel.setLayoutData((Object)filterLabelLayout);
        Text filterText = new Text((Composite)textPanel, 18436);
        GridData filterTextLayout = new GridData();
        filterTextLayout.horizontalAlignment = 4;
        filterTextLayout.verticalAlignment = 1;
        filterTextLayout.horizontalSpan = 2;
        filterTextLayout.grabExcessHorizontalSpace = true;
        filterTextLayout.grabExcessVerticalSpace = false;
        filterText.setLayoutData((Object)filterTextLayout);
        return filterText;
    }

    private void createPrioritySlider(Composite parent, ThresholdList priorityList) {
        Canvas priorityPanel = new Canvas(parent, 0);
        GridData priorityPanelLayout = new GridData();
        priorityPanelLayout.horizontalAlignment = 4;
        priorityPanelLayout.verticalAlignment = 1;
        priorityPanelLayout.grabExcessHorizontalSpace = true;
        priorityPanelLayout.grabExcessVerticalSpace = false;
        priorityPanel.setLayoutData((Object)priorityPanelLayout);
        GridLayout priorityPanelContentLayout = new GridLayout(2, false);
        priorityPanelContentLayout.marginHeight = 0;
        priorityPanelContentLayout.marginWidth = 0;
        priorityPanelContentLayout.verticalSpacing = 5;
        priorityPanel.setLayout((Layout)priorityPanelContentLayout);
        Label priorityLabel = new Label((Composite)priorityPanel, 0x1000120);
        priorityLabel.setText("Minimum Priority");
        FontData[] fontData = priorityLabel.getFont().getFontData();
        fontData[0].setStyle(1);
        priorityLabel.setFont(new Font((Device)priorityPanel.getDisplay(), fontData));
        GridData priorityLabelLayout = new GridData();
        priorityLabelLayout.horizontalAlignment = 1;
        priorityLabelLayout.verticalAlignment = 2;
        priorityLabelLayout.horizontalSpan = 2;
        priorityLabel.setLayoutData((Object)priorityLabelLayout);
        Slider prioritySlider = new Slider((Composite)priorityPanel, 256);
        prioritySlider.setValues(0, 0, 100, 10, 1, 25);
        GlazedListsSWT.lowerThresholdViewer(priorityList, prioritySlider);
        GridData prioritySliderLayout = new GridData();
        prioritySliderLayout.horizontalAlignment = 4;
        prioritySliderLayout.verticalAlignment = 1;
        prioritySliderLayout.horizontalSpan = 2;
        prioritySliderLayout.grabExcessHorizontalSpace = true;
        prioritySliderLayout.grabExcessVerticalSpace = false;
        prioritySlider.setLayoutData((Object)prioritySliderLayout);
        Label lowPriorityLabel = new Label((Composite)priorityPanel, 0x1000120);
        lowPriorityLabel.setText("Low");
        FontData[] lowerEndFontData = lowPriorityLabel.getFont().getFontData();
        lowerEndFontData[0].setStyle(1);
        lowPriorityLabel.setFont(new Font((Device)priorityPanel.getDisplay(), lowerEndFontData));
        GridData lowPriorityLabelLayout = new GridData();
        lowPriorityLabelLayout.horizontalAlignment = 1;
        lowPriorityLabelLayout.verticalAlignment = 2;
        lowPriorityLabel.setLayoutData((Object)lowPriorityLabelLayout);
        Label highPriorityLabel = new Label((Composite)priorityPanel, 0x1000120);
        highPriorityLabel.setText("High");
        FontData[] higherEndFontData = highPriorityLabel.getFont().getFontData();
        higherEndFontData[0].setStyle(1);
        highPriorityLabel.setFont(new Font((Device)priorityPanel.getDisplay(), higherEndFontData));
        GridData highPriorityLabelLayout = new GridData();
        highPriorityLabelLayout.horizontalAlignment = 3;
        highPriorityLabelLayout.verticalAlignment = 2;
        highPriorityLabel.setLayoutData((Object)highPriorityLabelLayout);
    }

    private void createUsersList(Shell shell, Composite parent) {
        Canvas usersListPanel = new Canvas(parent, 0);
        GridData usersListPanelLayout = new GridData();
        usersListPanelLayout.horizontalAlignment = 4;
        usersListPanelLayout.verticalAlignment = 4;
        usersListPanelLayout.grabExcessHorizontalSpace = true;
        usersListPanelLayout.grabExcessVerticalSpace = true;
        usersListPanel.setLayoutData((Object)usersListPanelLayout);
        GridLayout usersListPanelContentLayout = new GridLayout(1, false);
        usersListPanelContentLayout.marginHeight = 0;
        usersListPanelContentLayout.marginWidth = 0;
        usersListPanelContentLayout.verticalSpacing = 5;
        usersListPanel.setLayout((Layout)usersListPanelContentLayout);
        Label usersListLabel = new Label((Composite)usersListPanel, 0x1000120);
        usersListLabel.setText("User");
        FontData[] fontData = usersListLabel.getFont().getFontData();
        fontData[0].setStyle(1);
        usersListLabel.setFont(new Font((Device)usersListPanel.getDisplay(), fontData));
        GridData usersListLabelLayout = new GridData();
        usersListLabelLayout.horizontalAlignment = 1;
        usersListLabelLayout.verticalAlignment = 1;
        usersListLabelLayout.horizontalSpan = 2;
        usersListLabel.setLayoutData((Object)usersListLabelLayout);
        this.usersList = new org.eclipse.swt.widgets.List((Composite)usersListPanel, 2562);
        GridData usersListLayout = new GridData();
        usersListLayout.horizontalAlignment = 4;
        usersListLayout.verticalAlignment = 4;
        usersListLayout.horizontalSpan = 2;
        usersListLayout.grabExcessHorizontalSpace = true;
        usersListLayout.grabExcessVerticalSpace = true;
        this.usersList.setLayoutData((Object)usersListLayout);
        EventListViewer listViewer = new EventListViewer(this.issuesUserFiltered.getUsersList(), this.usersList);
        this.issuesUserFiltered.setSelectionList(listViewer.getSelected());
    }

    private Table createIssuesTable(Composite parent) {
        Table issuesTable = new Table(parent, 268503554);
        GridData issuesTableLayout = new GridData();
        issuesTableLayout.horizontalSpan = 2;
        issuesTableLayout.verticalSpan = 1;
        issuesTableLayout.horizontalAlignment = 4;
        issuesTableLayout.verticalAlignment = 4;
        issuesTableLayout.grabExcessHorizontalSpace = true;
        issuesTableLayout.grabExcessVerticalSpace = true;
        issuesTable.setLayoutData((Object)issuesTableLayout);
        return issuesTable;
    }

    private Table formatIssuesTable(Table issuesTable) {
        issuesTable.getVerticalBar().setEnabled(true);
        issuesTable.getColumn(0).setWidth(30);
        issuesTable.getColumn(0).setResizable(false);
        issuesTable.getColumn(1).setWidth(50);
        issuesTable.getColumn(2).setWidth(46);
        issuesTable.getColumn(2).setResizable(false);
        issuesTable.getColumn(3).setWidth(50);
        issuesTable.getColumn(4).setWidth(60);
        issuesTable.getColumn(5).setWidth(250);
        return issuesTable;
    }

    private void createDescriptionsHeader(Composite parent) {
        Label descriptionsLabel = new Label(parent, 0x1000120);
        descriptionsLabel.setText("Description");
        GridData descriptionsLabelLayout = new GridData();
        descriptionsLabelLayout.horizontalAlignment = 4;
        descriptionsLabelLayout.verticalAlignment = 1;
        descriptionsLabelLayout.grabExcessHorizontalSpace = true;
        descriptionsLabelLayout.grabExcessVerticalSpace = false;
        descriptionsLabel.setLayoutData((Object)descriptionsLabelLayout);
    }

    private void createDescriptionsTable(Composite parent, EventTableViewer issuesTableViewer) {
        Table descriptionsTable = new Table(parent, 68098);
        GridData descriptionsTableLayout = new GridData();
        descriptionsTableLayout.horizontalAlignment = 4;
        descriptionsTableLayout.verticalAlignment = 4;
        descriptionsTableLayout.grabExcessHorizontalSpace = true;
        descriptionsTableLayout.grabExcessVerticalSpace = true;
        descriptionsTable.setLayoutData((Object)descriptionsTableLayout);
        descriptionsTable.showColumn(new TableColumn(descriptionsTable, 16384));
        descriptionsTable.getColumn(0).setWidth(618);
        descriptionsTable.getColumn(0).setText("Descriptions");
        descriptionsTable.setHeaderVisible(true);
        new IssueSelectionListener(issuesTableViewer.getSelected(), descriptionsTable);
    }

    public static void main(String[] args) {
        System.setProperty("java.library.path", ".");
        Display display = new Display();
        Shell parent = new Shell(display);
        parent.setText("Issues");
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        parent.setLayout((Layout)gridLayout);
        new IssuesBrowser(parent);
        parent.setSize(640, 480);
        parent.open();
        while (!parent.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
        System.exit(0);
    }

    private class IndeterminateToggler
    implements Runnable,
    Throbber {
        private boolean on = false;

        private IndeterminateToggler() {
        }

        public synchronized void setOn() {
            this.on = true;
            System.out.println("THROB ON");
        }

        public synchronized void setOff() {
            this.on = false;
            System.out.println("THROB OFF");
        }

        public synchronized void run() {
        }
    }

    class IssueSelectionListener
    implements ListEventListener {
        private EventList source = null;
        private Table descriptionsTable = null;

        IssueSelectionListener(EventList source, Table descriptionsTable) {
            this.source = source;
            this.descriptionsTable = descriptionsTable;
            source.addListEventListener(this);
        }

        public void listChanged(ListEvent listChanges) {
            boolean selectionAffected = false;
            while (listChanges.next()) {
                if (selectionAffected) continue;
                selectionAffected = listChanges.getIndex() == 0;
            }
            if (selectionAffected) {
                this.descriptionsTable.removeAll();
                if (this.source.size() != 0) {
                    Issue selected = (Issue)this.source.get(0);
                    List descriptions = selected.getDescriptions();
                    for (int i = 0; i < descriptions.size(); ++i) {
                        int rowOffset = this.descriptionsTable.getItemCount();
                        this.formatDescription((Description)descriptions.get(i), rowOffset);
                    }
                }
            }
        }

        private void formatDescription(Description description, int rowOffset) {
            TableItem userName = new TableItem(this.descriptionsTable, 16384, rowOffset);
            FontData[] userNameFontData = userName.getFont().getFontData();
            userNameFontData[0].setStyle(1);
            Font userNameFont = new Font((Device)this.descriptionsTable.getDisplay(), userNameFontData);
            userName.setFont(userNameFont);
            userName.setText(description.getWho() + ":");
            ++rowOffset;
            String[] detailLines = description.getText().split("\n");
            for (int i = 0; i < detailLines.length; ++i) {
                TableItem details = new TableItem(this.descriptionsTable, 16384, rowOffset);
                details.setText(detailLines[i]);
                ++rowOffset;
            }
            TableItem seperator = new TableItem(this.descriptionsTable, 16384, rowOffset);
            seperator.setText("___________________________________________________________________");
        }
    }
}

