/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.demo.issuebrowser.swing;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.Matcher;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.ThresholdList;
import ca.odell.glazedlists.UniqueList;
import ca.odell.glazedlists.demo.Launcher;
import ca.odell.glazedlists.demo.issuebrowser.Issue;
import ca.odell.glazedlists.demo.issuebrowser.IssueLoader;
import ca.odell.glazedlists.demo.issuebrowser.IssueTableFormat;
import ca.odell.glazedlists.demo.issuebrowser.IssuesUserFilter;
import ca.odell.glazedlists.demo.issuebrowser.Priority;
import ca.odell.glazedlists.demo.issuebrowser.Project;
import ca.odell.glazedlists.demo.issuebrowser.Throbber;
import ca.odell.glazedlists.demo.issuebrowser.swing.DescriptionRenderer;
import ca.odell.glazedlists.demo.issuebrowser.swing.DescriptionTableFormat;
import ca.odell.glazedlists.demo.issuebrowser.swing.PriorityTableCellRenderer;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.ThreadedMatcherEditor;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import ca.odell.glazedlists.swing.TextComponentMatcherEditor;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class IssuesBrowser
extends Applet {
    private static final Color GLAZED_LISTS_ORANGE = new Color(255, 119, 0);
    private static final Color GLAZED_LISTS_ORANGE_LIGHT = new Color(241, 212, 189);
    private static final Color FILTER_PANEL_BLUE = new Color(126, 165, 232);
    private static final Color FILTER_PANEL_BLUE_LIGHT = new Color(197, 210, 232);
    private static final Border BLACK_LINE_BORDER = BorderFactory.createLineBorder(Color.BLACK);
    private UniqueList issuesEventList = new UniqueList(new BasicEventList());
    private EventSelectionModel issuesSelectionModel = null;
    private TableModel issuesTableModel = null;
    private Issue descriptionIssue = null;
    private EventList descriptions = new BasicEventList();
    private JLabel throbber = null;
    private ImageIcon throbberActive = null;
    private ImageIcon throbberStatic = null;
    private IssueCounterLabel issueCounter = null;
    private IssueLoader issueLoader = new IssueLoader(this.issuesEventList, new IndeterminateToggler());

    public IssuesBrowser() {
        this(true);
    }

    public IssuesBrowser(boolean applet) {
        if (applet) {
            this.constructApplet();
        } else {
            this.constructStandalone();
        }
        if (Thread.currentThread().isInterrupted()) {
            new Exception("thread has been interrupted").printStackTrace();
        }
        this.issueLoader.start();
    }

    private void constructApplet() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.constructView(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void constructStandalone() {
        JFrame frame = new JFrame("Issues");
        if (!Launcher.runningInLauncher()) {
            frame.setDefaultCloseOperation(3);
        } else {
            frame.setDefaultCloseOperation(2);
        }
        frame.setSize(800, 600);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().setLayout(new GridBagLayout());
        frame.getContentPane().add((Component)this.constructView(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        frame.setVisible(true);
    }

    private JPanel constructView() {
        JTextField filterTextField = new JTextField();
        filterTextField.setBorder(BLACK_LINE_BORDER);
        ThreadedMatcherEditor textFilterMatcherEditor = new ThreadedMatcherEditor(new TextComponentMatcherEditor(filterTextField, null));
        StateMatcherEditor stateMatcherEditor = new StateMatcherEditor();
        IssuesUserFilter issuesUserFiltered = new IssuesUserFilter(this.issuesEventList);
        FilterList issuesStateFiltered = new FilterList((EventList)issuesUserFiltered, stateMatcherEditor);
        FilterList issuesTextFiltered = new FilterList((EventList)issuesStateFiltered, textFilterMatcherEditor);
        ThresholdList priorityList = new ThresholdList((EventList)issuesTextFiltered, "priority.rating");
        final SortedList issuesSortedList = new SortedList(priorityList);
        this.issuesTableModel = new EventTableModel(issuesSortedList, new IssueTableFormat());
        issuesSortedList.addListEventListener(new ListEventListener(){

            public void listChanged(ListEvent listChanges) {
                IssuesBrowser.this.issueCounter.setIssueCount(issuesSortedList.size());
            }
        });
        JTable issuesJTable = new JTable(this.issuesTableModel);
        this.issuesSelectionModel = new EventSelectionModel(issuesSortedList);
        this.issuesSelectionModel.setSelectionMode(103);
        this.issuesSelectionModel.addListSelectionListener(new IssuesSelectionListener());
        issuesJTable.setSelectionModel(this.issuesSelectionModel);
        issuesJTable.getColumnModel().getColumn(0).setPreferredWidth(10);
        issuesJTable.getColumnModel().getColumn(1).setPreferredWidth(30);
        issuesJTable.getColumnModel().getColumn(2).setPreferredWidth(10);
        issuesJTable.getColumnModel().getColumn(3).setPreferredWidth(30);
        issuesJTable.getColumnModel().getColumn(4).setPreferredWidth(30);
        issuesJTable.getColumnModel().getColumn(5).setPreferredWidth(200);
        issuesJTable.setDefaultRenderer(Priority.class, new PriorityTableCellRenderer());
        new TableComparatorChooser(issuesJTable, issuesSortedList, true);
        JScrollPane issuesTableScrollPane = new JScrollPane(issuesJTable, 22, 31);
        issuesTableScrollPane.setBorder(BLACK_LINE_BORDER);
        issuesTableScrollPane.setOpaque(false);
        issuesTableScrollPane.getViewport().setOpaque(false);
        JScrollPane usersListScrollPane = new JScrollPane(issuesUserFiltered.getUserSelect(), 22, 31);
        usersListScrollPane.setBorder(BLACK_LINE_BORDER);
        EventTableModel descriptionsTableModel = new EventTableModel(this.descriptions, new DescriptionTableFormat());
        JTable descriptionsTable = new JTable(descriptionsTableModel);
        descriptionsTable.getColumnModel().getColumn(0).setCellRenderer(new DescriptionRenderer());
        JScrollPane descriptionsTableScrollPane = new JScrollPane(descriptionsTable, 22, 31);
        descriptionsTableScrollPane.setBorder(BLACK_LINE_BORDER);
        descriptionsTableScrollPane.setOpaque(false);
        descriptionsTableScrollPane.getViewport().setBackground(UIManager.getColor("List.background"));
        BoundedRangeModel priorityRangeModel = GlazedListsSwing.lowerRangeModel(priorityList);
        priorityRangeModel.setRangeProperties(0, 0, 0, 100, false);
        JSlider prioritySlider = new JSlider(priorityRangeModel);
        Hashtable<Integer, JLabel> prioritySliderLabels = new Hashtable<Integer, JLabel>();
        prioritySliderLabels.put(new Integer(0), new JLabel("Low"));
        prioritySliderLabels.put(new Integer(100), new JLabel("High"));
        prioritySlider.setOpaque(false);
        prioritySlider.setLabelTable(prioritySliderLabels);
        prioritySlider.setSnapToTicks(true);
        prioritySlider.setPaintLabels(true);
        prioritySlider.setPaintTicks(true);
        prioritySlider.setForeground(UIManager.getColor("Label.foreground"));
        prioritySlider.setMajorTickSpacing(25);
        EventList projects = Project.getProjects();
        EventComboBoxModel projectsComboModel = new EventComboBoxModel(projects);
        JComboBox projectsCombo = new JComboBox(projectsComboModel);
        projectsCombo.setEditable(false);
        projectsCombo.setBackground(GLAZED_LISTS_ORANGE_LIGHT);
        projectsCombo.addItemListener(new ProjectChangeListener());
        projectsComboModel.setSelectedItem(new Project(null, "Select a Java.net project..."));
        JPanel iconBar = new JPanel();
        iconBar.setBackground(GLAZED_LISTS_ORANGE);
        iconBar.setLayout(new GridBagLayout());
        ClassLoader jarLoader = IssuesBrowser.class.getClassLoader();
        URL url = jarLoader.getResource("resources/demo/throbber-static.gif");
        if (url != null) {
            this.throbberStatic = new ImageIcon(url);
        }
        if ((url = jarLoader.getResource("resources/demo/throbber-active.gif")) != null) {
            this.throbberActive = new ImageIcon(url);
        }
        this.throbber = new JLabel(this.throbberStatic);
        iconBar.add(projectsCombo, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        iconBar.add((Component)this.throbber, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        GradientPanel filtersPanel = new GradientPanel(FILTER_PANEL_BLUE, FILTER_PANEL_BLUE_LIGHT);
        filtersPanel.setBorder(BLACK_LINE_BORDER);
        filtersPanel.setPreferredSize(new Dimension(200, 400));
        filtersPanel.setLayout(new GridBagLayout());
        filtersPanel.add((Component)new JLabel("Text Filter"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 10), 0, 0));
        filtersPanel.add((Component)filterTextField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 15, 10), 0, 0));
        filtersPanel.add((Component)new JLabel("State"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        filtersPanel.add(stateMatcherEditor.getComponent(), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 15, 10), 0, 0));
        filtersPanel.add((Component)new JLabel("Minimum Priority"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        filtersPanel.add((Component)prioritySlider, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 15, 10), 0, 0));
        filtersPanel.add((Component)new JLabel("User"), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        filtersPanel.add((Component)usersListScrollPane, new GridBagConstraints(0, 7, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
        GradientPanel filterSpacerPanel = new GradientPanel(GLAZED_LISTS_ORANGE, GLAZED_LISTS_ORANGE_LIGHT);
        filterSpacerPanel.setLayout(new GridBagLayout());
        filterSpacerPanel.add((Component)filtersPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 5, 5, 5), 0, 0));
        this.issueCounter = new IssueCounterLabel();
        GradientPanel dataPanel = new GradientPanel(GLAZED_LISTS_ORANGE, GLAZED_LISTS_ORANGE_LIGHT);
        dataPanel.setLayout(new GridBagLayout());
        dataPanel.add((Component)issuesTableScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 10, 1, new Insets(10, 5, 0, 5), 0, 0));
        dataPanel.add((Component)this.issueCounter, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        dataPanel.add((Component)descriptionsTableScrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.5, 10, 1, new Insets(10, 5, 5, 5), 0, 0));
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)iconBar, "North");
        mainPanel.add((Component)filterSpacerPanel, "West");
        mainPanel.add((Component)dataPanel, "Center");
        return mainPanel;
    }

    public static void main(String[] args) {
        IssuesBrowser browser = new IssuesBrowser(false);
        if (args.length == 1) {
            Project initialProject = new Project("url", "Url", args[0]);
            browser.issueLoader.setProject(initialProject);
        }
    }

    private static class GradientPanel
    extends JPanel {
        private Color gradientStartColor;
        private Color gradientEndColor;

        public GradientPanel(Color gradientStartColor, Color gradientEndColor) {
            this.gradientStartColor = gradientStartColor;
            this.gradientEndColor = gradientEndColor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics g) {
            if (this.isOpaque()) {
                Graphics2D g2 = (Graphics2D)g;
                Paint oldPainter = g2.getPaint();
                try {
                    g2.setPaint(new GradientPaint(0.0f, 0.0f, this.gradientStartColor, 0.0f, this.getHeight(), this.gradientEndColor));
                    g2.fill(g2.getClip());
                }
                finally {
                    g2.setPaint(oldPainter);
                }
            }
        }
    }

    private static class StateMatcherEditor
    extends AbstractMatcherEditor
    implements ActionListener {
        private JPanel checkBoxPanel = new JPanel(new GridLayout(2, 2));
        private final JCheckBox[] stateCheckBoxes;

        public StateMatcherEditor() {
            JCheckBox newStateCheckBox = StateMatcherEditor.buildCheckBox("New");
            JCheckBox resolvedStateCheckBox = StateMatcherEditor.buildCheckBox("Resolved");
            JCheckBox startedStateCheckBox = StateMatcherEditor.buildCheckBox("Started");
            JCheckBox closeStateCheckBox = StateMatcherEditor.buildCheckBox("Closed");
            this.stateCheckBoxes = new JCheckBox[]{newStateCheckBox, resolvedStateCheckBox, startedStateCheckBox, closeStateCheckBox};
            this.checkBoxPanel.setOpaque(false);
            for (int i = 0; i < this.stateCheckBoxes.length; ++i) {
                this.stateCheckBoxes[i].addActionListener(this);
                this.checkBoxPanel.add(this.stateCheckBoxes[i]);
            }
        }

        public Component getComponent() {
            return this.checkBoxPanel;
        }

        private static JCheckBox buildCheckBox(String name) {
            JCheckBox checkBox = new JCheckBox(name, true);
            checkBox.setOpaque(false);
            checkBox.setFocusable(false);
            checkBox.setMargin(new Insets(0, 0, 0, 0));
            return checkBox;
        }

        private StateMatcher buildMatcher() {
            HashSet<String> allowedStates = new HashSet<String>();
            for (int i = 0; i < this.stateCheckBoxes.length; ++i) {
                if (!this.stateCheckBoxes[i].isSelected()) continue;
                allowedStates.add(this.stateCheckBoxes[i].getText().toUpperCase());
            }
            return new StateMatcher(allowedStates);
        }

        public void actionPerformed(ActionEvent e) {
            boolean isCheckBoxSelected = ((JCheckBox)e.getSource()).isSelected();
            StateMatcher stateMatcher = this.buildMatcher();
            if (stateMatcher.getStateCount() == 0) {
                this.fireMatchNone();
            } else if (stateMatcher.getStateCount() == this.stateCheckBoxes.length) {
                this.fireMatchAll();
            } else if (isCheckBoxSelected) {
                this.fireRelaxed(stateMatcher);
            } else {
                this.fireConstrained(stateMatcher);
            }
        }

        private static class StateMatcher
        implements Matcher {
            private final Set allowedStates;

            public StateMatcher(Set allowedStates) {
                this.allowedStates = allowedStates;
            }

            public int getStateCount() {
                return this.allowedStates.size();
            }

            public boolean matches(Object item) {
                Issue issue = (Issue)item;
                return this.allowedStates.contains(issue.getStatus());
            }
        }
    }

    private static class IssueCounterLabel
    extends JLabel {
        private int issueCount = -1;

        private IssueCounterLabel() {
            this.setIssueCount(0);
        }

        public void setIssueCount(int issueCount) {
            if (this.issueCount != issueCount) {
                this.issueCount = issueCount;
                this.setText(MessageFormat.format("{0} {0,choice,0#issues|1#issue|1<issues}", new Integer(issueCount)));
            }
        }
    }

    private class IndeterminateToggler
    implements Runnable,
    Throbber {
        private boolean on = false;

        private IndeterminateToggler() {
        }

        public synchronized void setOn() {
            if (!this.on) {
                this.on = true;
                SwingUtilities.invokeLater(this);
            }
        }

        public synchronized void setOff() {
            if (this.on) {
                this.on = false;
                SwingUtilities.invokeLater(this);
            }
        }

        public synchronized void run() {
            if (this.on) {
                IssuesBrowser.this.throbber.setIcon(IssuesBrowser.this.throbberActive);
            } else {
                IssuesBrowser.this.throbber.setIcon(IssuesBrowser.this.throbberStatic);
            }
        }
    }

    class ProjectChangeListener
    implements ItemListener {
        ProjectChangeListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            Project selected = (Project)e.getItem();
            if (selected.isValid()) {
                IssuesBrowser.this.issueLoader.setProject(selected);
            }
        }
    }

    class IssuesSelectionListener
    implements ListSelectionListener {
        IssuesSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            Issue selected = null;
            if (IssuesBrowser.this.issuesSelectionModel.getSelected().size() > 0) {
                selected = (Issue)IssuesBrowser.this.issuesSelectionModel.getSelected().get(0);
            }
            if (selected == IssuesBrowser.this.descriptionIssue) {
                return;
            }
            IssuesBrowser.this.descriptionIssue = selected;
            IssuesBrowser.this.descriptions.clear();
            if (IssuesBrowser.this.descriptionIssue != null) {
                IssuesBrowser.this.descriptions.addAll(IssuesBrowser.this.descriptionIssue.getDescriptions());
            }
        }
    }
}

