/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.demo.issuebrowser;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.demo.issuebrowser.Activity;
import ca.odell.glazedlists.demo.issuebrowser.Attachment;
import ca.odell.glazedlists.demo.issuebrowser.Description;
import ca.odell.glazedlists.demo.issuebrowser.Issue;
import ca.odell.glazedlists.demo.issuebrowser.PeerIssue;
import ca.odell.glazedlists.demo.issuebrowser.Priority;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class IssuezillaXMLParser {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SortedSet ISSUE_SIMPLE_FIELDS;
    private static SortedSet DESCRIPTION_SIMPLE_FIELDS;
    private static SortedSet ATTACHMENT_SIMPLE_FIELDS;
    private static SortedSet ACTIVITY_SIMPLE_FIELDS;
    private static SortedSet RELATIONSHIP_SIMPLE_FIELDS;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("Usage: IssuezillaXMLParser <file>");
            return;
        }
        BasicEventList issuesList = new BasicEventList();
        IssuezillaXMLParser.loadIssues((EventList)issuesList, new FileInputStream(args[0]));
        System.out.println(issuesList);
    }

    public static void loadIssues(EventList target, String baseUrl) throws IOException {
        int nextTotal;
        int issuesPerRequest = 100;
        do {
            int currentTotal = target.size();
            nextTotal = currentTotal + issuesPerRequest;
            StringBuffer idArg = new StringBuffer();
            for (int i = currentTotal + 1; i <= nextTotal; ++i) {
                idArg.append(i);
                if (i >= nextTotal) continue;
                idArg.append(":");
            }
            URL issuesUrl = new URL(baseUrl + "?id=" + idArg);
            InputStream issuesInStream = issuesUrl.openStream();
            IssuezillaXMLParser.loadIssues(target, issuesInStream);
        } while (target.size() >= nextTotal);
    }

    public static void loadIssues(EventList target, InputStream source) throws IOException {
        try {
            XMLReader xmlReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            IssuezillaParserSidekick parserSidekick = new IssuezillaParserSidekick();
            xmlReader.setEntityResolver(parserSidekick);
            xmlReader.setErrorHandler(parserSidekick);
            xmlReader.setContentHandler(new IssueHandler(target));
            xmlReader.parse(new InputSource(source));
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IOException("Parsing failed " + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new IOException("Parsing failed " + e.getMessage());
        }
    }

    private static Date parse(String date) {
        try {
            return dateFormat.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String escapeToJava(String text) {
        StringBuffer result = new StringBuffer();
        for (int c = 0; c < text.length(); ++c) {
            char letter = text.charAt(c);
            if (letter == '\"') {
                result.append("\\\"");
                continue;
            }
            if (letter == '\\') {
                result.append("\\\\");
                continue;
            }
            if (letter == '\n') {
                result.append("\\n");
                continue;
            }
            result.append(letter);
        }
        return result.toString();
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("America/Los_Angeles"));
        ISSUE_SIMPLE_FIELDS = new TreeSet();
        ISSUE_SIMPLE_FIELDS.add("issue_id");
        ISSUE_SIMPLE_FIELDS.add("issue_status");
        ISSUE_SIMPLE_FIELDS.add("priority");
        ISSUE_SIMPLE_FIELDS.add("resolution");
        ISSUE_SIMPLE_FIELDS.add("component");
        ISSUE_SIMPLE_FIELDS.add("version");
        ISSUE_SIMPLE_FIELDS.add("rep_platform");
        ISSUE_SIMPLE_FIELDS.add("assigned_to");
        ISSUE_SIMPLE_FIELDS.add("delta_ts");
        ISSUE_SIMPLE_FIELDS.add("subcomponent");
        ISSUE_SIMPLE_FIELDS.add("reporter");
        ISSUE_SIMPLE_FIELDS.add("target_milestone");
        ISSUE_SIMPLE_FIELDS.add("issue_type");
        ISSUE_SIMPLE_FIELDS.add("creation_ts");
        ISSUE_SIMPLE_FIELDS.add("qa_contact");
        ISSUE_SIMPLE_FIELDS.add("status_whiteboard");
        ISSUE_SIMPLE_FIELDS.add("issue_file_loc");
        ISSUE_SIMPLE_FIELDS.add("votes");
        ISSUE_SIMPLE_FIELDS.add("op_sys");
        ISSUE_SIMPLE_FIELDS.add("short_desc");
        ISSUE_SIMPLE_FIELDS.add("keywords");
        ISSUE_SIMPLE_FIELDS.add("cc");
        DESCRIPTION_SIMPLE_FIELDS = new TreeSet();
        DESCRIPTION_SIMPLE_FIELDS.add("who");
        DESCRIPTION_SIMPLE_FIELDS.add("issue_when");
        DESCRIPTION_SIMPLE_FIELDS.add("thetext");
        ATTACHMENT_SIMPLE_FIELDS = new TreeSet();
        ATTACHMENT_SIMPLE_FIELDS.add("mimetype");
        ATTACHMENT_SIMPLE_FIELDS.add("attachid");
        ATTACHMENT_SIMPLE_FIELDS.add("date");
        ATTACHMENT_SIMPLE_FIELDS.add("desc");
        ATTACHMENT_SIMPLE_FIELDS.add("ispatch");
        ATTACHMENT_SIMPLE_FIELDS.add("filename");
        ATTACHMENT_SIMPLE_FIELDS.add("submitter_id");
        ATTACHMENT_SIMPLE_FIELDS.add("submitting_username");
        ATTACHMENT_SIMPLE_FIELDS.add("data");
        ATTACHMENT_SIMPLE_FIELDS.add("attachment_iz_url");
        ACTIVITY_SIMPLE_FIELDS = new TreeSet();
        ACTIVITY_SIMPLE_FIELDS.add("user");
        ACTIVITY_SIMPLE_FIELDS.add("when");
        ACTIVITY_SIMPLE_FIELDS.add("field_name");
        ACTIVITY_SIMPLE_FIELDS.add("field_desc");
        ACTIVITY_SIMPLE_FIELDS.add("oldvalue");
        ACTIVITY_SIMPLE_FIELDS.add("newvalue");
        RELATIONSHIP_SIMPLE_FIELDS = new TreeSet();
        RELATIONSHIP_SIMPLE_FIELDS.add("issue_id");
        RELATIONSHIP_SIMPLE_FIELDS.add("who");
        RELATIONSHIP_SIMPLE_FIELDS.add("when");
    }

    static abstract class AbstractSimpleElementHandler
    extends DefaultHandler {
        protected String currentField = null;
        protected IssueHandler parent;
        protected String hostElement = null;
        private Set acceptableFields = null;
        private StringBuffer currentValue;

        protected AbstractSimpleElementHandler(IssueHandler parent, String hostElement, Set acceptableFields) {
            this.parent = parent;
            this.hostElement = hostElement;
            this.acceptableFields = acceptableFields;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (this.currentField != null) {
                this.parent.addException(this + " expected end of element " + this.currentField + " but found " + qName);
            } else if (this.acceptableFields.contains(qName)) {
                this.currentField = qName;
                this.currentValue = new StringBuffer();
            } else {
                this.parent.addException(this + " encountered unexpected element " + qName);
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (qName.equals(this.hostElement)) {
                this.parent.endSimpleElement();
            } else if (this.currentField == null) {
                this.parent.addException(this + " expected new element but found end of " + qName);
            } else if (this.currentField.equals(qName)) {
                this.addFieldAndValue(this.currentField, this.currentValue.toString());
                this.currentField = null;
                this.currentValue = null;
            } else {
                this.parent.addException(this + " expected end of element " + this.currentField + " but found end of " + qName);
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (this.currentField == null) {
                return;
            }
            this.currentValue.append(ch, start, length);
        }

        protected abstract void addFieldAndValue(String var1, String var2);

        public String toString() {
            return "<" + this.hostElement + ">";
        }
    }

    static class RelationshipHandler
    extends AbstractSimpleElementHandler {
        public PeerIssue peerIssue = new PeerIssue();

        public RelationshipHandler(IssueHandler parent, String type) {
            super(parent, type, RELATIONSHIP_SIMPLE_FIELDS);
        }

        public void addFieldAndValue(String currentField, String value) {
            if (currentField.equals("issue_id")) {
                this.peerIssue.setIssueId(value);
            } else if (currentField.equals("who")) {
                this.peerIssue.setWho(value);
            } else if (currentField.equals("when")) {
                this.peerIssue.setWhen(IssuezillaXMLParser.parse(value));
            } else {
                this.parent.addException(this + " encountered unexpected element " + currentField);
            }
        }
    }

    static class ActivityHandler
    extends AbstractSimpleElementHandler {
        public Activity activity = new Activity();

        public ActivityHandler(IssueHandler parent) {
            super(parent, "activity", ACTIVITY_SIMPLE_FIELDS);
        }

        public void addFieldAndValue(String currentField, String value) {
            if (currentField.equals("user")) {
                this.activity.setUser(value);
            } else if (currentField.equals("when")) {
                this.activity.setWhen(IssuezillaXMLParser.parse(value));
            } else if (currentField.equals("field_name")) {
                this.activity.setField(value);
            } else if (currentField.equals("field_desc")) {
                this.activity.setFieldDescription(value);
            } else if (currentField.equals("oldvalue")) {
                this.activity.setOldValue(value);
            } else if (currentField.equals("newvalue")) {
                this.activity.setNewValue(value);
            } else {
                this.parent.addException(this + " encountered unexpected element " + currentField);
            }
        }
    }

    static class AttachmentHandler
    extends AbstractSimpleElementHandler {
        public Attachment attachment = new Attachment();

        public AttachmentHandler(IssueHandler parent) {
            super(parent, "attachment", ATTACHMENT_SIMPLE_FIELDS);
        }

        public void addFieldAndValue(String currentField, String value) {
            if (currentField.equals("mimetype")) {
                this.attachment.setMimeType(value);
            } else if (currentField.equals("attachid")) {
                this.attachment.setAttachId(value);
            } else if (currentField.equals("date")) {
                this.attachment.setDate(IssuezillaXMLParser.parse(value));
            } else if (currentField.equals("desc")) {
                this.attachment.setDescription(value);
            } else if (currentField.equals("ispatch")) {
                this.attachment.setIsPatch(value);
            } else if (currentField.equals("filename")) {
                this.attachment.setFilename(value);
            } else if (currentField.equals("submitter_id")) {
                this.attachment.setSubmitterId(value);
            } else if (currentField.equals("submitting_username")) {
                this.attachment.setSubmitterUsername(value);
            } else if (currentField.equals("data")) {
                this.attachment.setData(value);
            } else if (currentField.equals("attachment_iz_url")) {
                this.attachment.setAttachmentIzUrl(value);
            } else {
                this.parent.addException(this + " encountered unexpected element " + currentField);
            }
        }
    }

    static class DescriptionHandler
    extends AbstractSimpleElementHandler {
        public Description description = new Description();

        public DescriptionHandler(IssueHandler parent) {
            super(parent, "long_desc", DESCRIPTION_SIMPLE_FIELDS);
        }

        public void addFieldAndValue(String currentField, String value) {
            if (currentField.equals("who")) {
                this.description.setWho(value);
            } else if (currentField.equals("issue_when")) {
                this.description.setWhen(IssuezillaXMLParser.parse(value));
            } else if (currentField.equals("thetext")) {
                this.description.setText(value);
            } else {
                this.parent.addException(this + " encountered unexpected element " + currentField);
            }
        }
    }

    static class IssueHandler
    extends AbstractSimpleElementHandler {
        private EventList issues = null;
        private Issue currentIssue;
        private AbstractSimpleElementHandler simpleElementHandler = null;

        public IssueHandler(EventList issues) {
            super(null, "issue", ISSUE_SIMPLE_FIELDS);
            this.issues = issues;
            this.parent = this;
        }

        public List getIssues() {
            return this.issues;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (!qName.equals("issuezilla")) {
                if (this.currentIssue == null) {
                    if (qName.equals("issue")) {
                        this.currentIssue = new Issue();
                        String statusCode = attributes.getValue("status_code");
                        this.currentIssue.setStatusCode(statusCode != null ? Integer.valueOf(statusCode) : new Integer(404));
                    } else {
                        this.addException(this + " encountered unexpected element \"" + qName + "\"");
                    }
                } else if (this.simpleElementHandler != null) {
                    this.simpleElementHandler.startElement(uri, localName, qName, attributes);
                } else if (qName.equals("long_desc")) {
                    this.simpleElementHandler = new DescriptionHandler(this);
                } else if (qName.equals("attachment")) {
                    this.simpleElementHandler = new AttachmentHandler(this);
                } else if (qName.equals("activity")) {
                    this.simpleElementHandler = new ActivityHandler(this);
                } else if (qName.equals("has_duplicates")) {
                    this.simpleElementHandler = new RelationshipHandler(this, "has_duplicates");
                } else if (qName.equals("dependson")) {
                    this.simpleElementHandler = new RelationshipHandler(this, "dependson");
                } else if (qName.equals("blocks")) {
                    this.simpleElementHandler = new RelationshipHandler(this, "blocks");
                } else if (qName.equals("is_duplicate")) {
                    this.simpleElementHandler = new RelationshipHandler(this, "is_duplicate");
                } else {
                    super.startElement(uri, localName, qName, attributes);
                }
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (this.currentField != null) {
                super.endElement(uri, localName, qName);
            } else if (this.simpleElementHandler != null) {
                this.simpleElementHandler.endElement(uri, localName, qName);
            } else if (qName.equals("issue")) {
                if (Thread.interrupted()) {
                    throw new RuntimeException(new InterruptedException());
                }
                if (this.currentIssue.getStatusCode() != null && this.currentIssue.getStatusCode() == 200) {
                    this.issues.add(this.currentIssue);
                }
                this.currentIssue = null;
            } else if (!qName.equals("issuezilla")) {
                this.addException(this + " encountered unexpected end of element \"" + qName + "\"");
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (this.simpleElementHandler != null) {
                this.simpleElementHandler.characters(ch, start, length);
            } else {
                super.characters(ch, start, length);
            }
        }

        public void addFieldAndValue(String currentField, String value) {
            if (currentField.equals("issue_id")) {
                this.currentIssue.setId(Integer.valueOf(value));
            } else if (currentField.equals("issue_status")) {
                this.currentIssue.setStatus(value.intern());
            } else if (currentField.equals("priority")) {
                this.currentIssue.setPriority(Priority.lookup(value));
            } else if (currentField.equals("resolution")) {
                this.currentIssue.setResolution(value.intern());
            } else if (currentField.equals("component")) {
                this.currentIssue.setComponent(value);
            } else if (currentField.equals("version")) {
                this.currentIssue.setVersion(value);
            } else if (currentField.equals("rep_platform")) {
                this.currentIssue.setRepPlatform(value);
            } else if (currentField.equals("assigned_to")) {
                this.currentIssue.setAssignedTo(value);
            } else if (currentField.equals("delta_ts")) {
                this.currentIssue.setDeltaTimestamp(null);
            } else if (currentField.equals("subcomponent")) {
                this.currentIssue.setSubcomponent(value);
            } else if (currentField.equals("reporter")) {
                this.currentIssue.setReporter(value);
            } else if (currentField.equals("target_milestone")) {
                this.currentIssue.setTargetMilestone(value);
            } else if (currentField.equals("issue_type")) {
                this.currentIssue.setIssueType(value.intern());
            } else if (currentField.equals("creation_ts")) {
                this.currentIssue.setCreationTimestamp(null);
            } else if (currentField.equals("qa_contact")) {
                this.currentIssue.setQAContact(value);
            } else if (currentField.equals("status_whiteboard")) {
                this.currentIssue.setStatusWhiteboard(value);
            } else if (currentField.equals("issue_file_loc")) {
                this.currentIssue.setFileLocation(value);
            } else if (currentField.equals("votes")) {
                this.currentIssue.setVotes(value);
            } else if (currentField.equals("op_sys")) {
                this.currentIssue.setOperatingSystem(value);
            } else if (currentField.equals("short_desc")) {
                this.currentIssue.setShortDescription(value);
            } else if (currentField.equals("keywords")) {
                this.currentIssue.getKeywords().add(value);
            } else if (currentField.equals("cc")) {
                this.currentIssue.getCC().add(value);
            } else {
                this.parent.addException(this + " encountered unexpected element " + currentField);
            }
        }

        public void endSimpleElement() {
            if (this.simpleElementHandler.hostElement.equals("long_desc")) {
                DescriptionHandler descriptionHandler = (DescriptionHandler)this.simpleElementHandler;
                this.currentIssue.getDescriptions().add(descriptionHandler.description);
                this.simpleElementHandler = null;
            } else if (this.simpleElementHandler.hostElement.equals("attachment")) {
                AttachmentHandler attachmentHandler = (AttachmentHandler)this.simpleElementHandler;
                this.currentIssue.getAttachments().add(attachmentHandler.attachment);
                this.simpleElementHandler = null;
            } else if (this.simpleElementHandler.hostElement.equals("activity")) {
                ActivityHandler activityHandler = (ActivityHandler)this.simpleElementHandler;
                this.currentIssue.getActivities().add(activityHandler.activity);
                this.simpleElementHandler = null;
            } else if (this.simpleElementHandler.hostElement.equals("has_duplicates")) {
                RelationshipHandler duplicateHandler = (RelationshipHandler)this.simpleElementHandler;
                this.currentIssue.getDuplicates().add(duplicateHandler.peerIssue);
                this.simpleElementHandler = null;
            } else if (this.simpleElementHandler.hostElement.equals("dependson")) {
                RelationshipHandler dependsOnHandler = (RelationshipHandler)this.simpleElementHandler;
                this.currentIssue.getDependsOn().add(dependsOnHandler.peerIssue);
                this.simpleElementHandler = null;
            } else if (this.simpleElementHandler.hostElement.equals("blocks")) {
                RelationshipHandler blocksHandler = (RelationshipHandler)this.simpleElementHandler;
                this.currentIssue.getBlocks().add(blocksHandler.peerIssue);
                this.simpleElementHandler = null;
            } else if (this.simpleElementHandler.hostElement.equals("is_duplicate")) {
                RelationshipHandler isDuplicateHandler = (RelationshipHandler)this.simpleElementHandler;
                this.currentIssue.setDuplicate(isDuplicateHandler.peerIssue);
                this.simpleElementHandler = null;
            } else {
                this.addException(this + " encountered unexpected end of element " + this.simpleElementHandler);
            }
        }

        public void addException(String message) {
            new Exception(message).printStackTrace();
        }
    }

    static class IssuezillaParserSidekick
    implements EntityResolver,
    ErrorHandler {
        IssuezillaParserSidekick() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId.endsWith("issuezilla.dtd")) {
                byte[] emptyDTDBytes = "<?xml version='1.0' encoding='UTF-8'?>".getBytes();
                return new InputSource(new ByteArrayInputStream(emptyDTDBytes));
            }
            return null;
        }

        public void error(SAXParseException exception) {
            System.out.println("Error: ");
            exception.printStackTrace();
        }

        public void fatalError(SAXParseException exception) {
            System.out.println("Fatal error: ");
            exception.printStackTrace();
        }

        public void warning(SAXParseException exception) {
            System.out.println("Warning: ");
            exception.printStackTrace();
        }
    }
}

