/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.demo.issuebrowser;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.demo.issuebrowser.Issue;
import ca.odell.glazedlists.demo.issuebrowser.Priority;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import java.util.Comparator;

public class IssueTableFormat
implements AdvancedTableFormat {
    public int getColumnCount() {
        return 6;
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "ID";
        }
        if (column == 1) {
            return "Type";
        }
        if (column == 2) {
            return "Priority";
        }
        if (column == 3) {
            return "State";
        }
        if (column == 4) {
            return "Result";
        }
        if (column == 5) {
            return "Summary";
        }
        return null;
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return Integer.class;
            }
            case 2: {
                return Priority.class;
            }
        }
        return String.class;
    }

    public Comparator getColumnComparator(int column) {
        if (column == 5) {
            return GlazedLists.caseInsensitiveComparator();
        }
        return GlazedLists.comparableComparator();
    }

    public Object getColumnValue(Object baseObject, int column) {
        if (baseObject == null) {
            return null;
        }
        Issue issue = (Issue)baseObject;
        if (column == 0) {
            return issue.getId();
        }
        if (column == 1) {
            return issue.getIssueType();
        }
        if (column == 2) {
            return issue.getPriority();
        }
        if (column == 3) {
            return issue.getStatus();
        }
        if (column == 4) {
            return issue.getResolution();
        }
        if (column == 5) {
            return issue.getShortDescription();
        }
        return null;
    }
}

