/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.AbstractEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.Collection;
import java.util.Iterator;

public abstract class TransformedList
extends AbstractEventList
implements ListEventListener {
    protected EventList source;

    protected TransformedList(EventList source) {
        super(source.getPublisher());
        this.source = source;
        this.readWriteLock = source.getReadWriteLock();
    }

    protected int getSourceIndex(int mutationIndex) {
        return mutationIndex;
    }

    protected boolean isWritable() {
        return false;
    }

    public abstract void listChanged(ListEvent var1);

    public boolean add(Object value) {
        if (!this.isWritable()) {
            throw new IllegalStateException("List cannot be modified in the current state");
        }
        return this.source.add(value);
    }

    public void add(int index, Object value) {
        if (!this.isWritable()) {
            throw new IllegalStateException("List cannot be modified in the current state");
        }
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Cannot add at " + index + " on list of size " + this.size());
        }
        int sourceIndex = 0;
        sourceIndex = index < this.size() ? this.getSourceIndex(index) : this.source.size();
        this.source.add(sourceIndex, value);
    }

    public boolean addAll(int index, Collection values) {
        if (!this.isWritable()) {
            throw new IllegalStateException("List cannot be modified in the current state");
        }
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Cannot add at " + index + " on list of size " + this.size());
        }
        int sourceIndex = 0;
        sourceIndex = index < this.size() ? this.getSourceIndex(index) : this.source.size();
        return this.source.addAll(sourceIndex, values);
    }

    public boolean addAll(Collection values) {
        if (!this.isWritable()) {
            throw new IllegalStateException("List cannot be modified in the current state");
        }
        return this.source.addAll(values);
    }

    public void clear() {
        if (!this.isWritable()) {
            throw new IllegalStateException("List cannot be modified in the current state");
        }
        this.updates.beginEvent(true);
        while (!this.isEmpty()) {
            this.remove(0);
        }
        this.updates.commitEvent();
    }

    public Object get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot get at " + index + " on list of size " + this.size());
        }
        return this.source.get(this.getSourceIndex(index));
    }

    public Object remove(int index) {
        if (!this.isWritable()) {
            throw new IllegalStateException("List cannot be modified in the current state");
        }
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot remove at " + index + " on list of size " + this.size());
        }
        return this.source.remove(this.getSourceIndex(index));
    }

    public boolean remove(Object toRemove) {
        if (!this.isWritable()) {
            throw new IllegalStateException("List cannot be modified in the current state");
        }
        int index = this.indexOf(toRemove);
        if (index == -1) {
            return false;
        }
        this.source.remove(this.getSourceIndex(index));
        return true;
    }

    public boolean removeAll(Collection collection) {
        if (!this.isWritable()) {
            throw new IllegalStateException("List cannot be modified in the current state");
        }
        boolean changed = false;
        this.updates.beginEvent(true);
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Object value = i.next();
            int index = -1;
            while ((index = this.indexOf(value)) != -1) {
                this.remove(index);
                changed = true;
            }
        }
        this.updates.commitEvent();
        return changed;
    }

    public boolean retainAll(Collection values) {
        if (!this.isWritable()) {
            throw new IllegalStateException("List cannot be modified in the current state");
        }
        this.updates.beginEvent(true);
        boolean changed = false;
        int i = 0;
        while (i < this.size()) {
            if (!values.contains(this.get(i))) {
                this.remove(i);
                changed = true;
                continue;
            }
            ++i;
        }
        this.updates.commitEvent();
        return changed;
    }

    public Object set(int index, Object value) {
        if (!this.isWritable()) {
            throw new IllegalStateException("List cannot be modified in the current state");
        }
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot set at " + index + " on list of size " + this.size());
        }
        return this.source.set(this.getSourceIndex(index), value);
    }

    public int size() {
        return this.source.size();
    }

    public void dispose() {
        this.source.removeListEventListener(this);
    }
}

