/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.ThresholdEvaluator;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import java.util.Comparator;

public final class ThresholdList
extends TransformedList {
    private int lowerThresholdIndex = 0;
    private int upperThresholdIndex = 0;
    private int lowerThreshold = 0;
    private int upperThreshold = 0;
    private int sourceSize = 0;
    private ThresholdEvaluator evaluator = null;

    public ThresholdList(EventList source, String propertyName) {
        this(source, GlazedLists.thresholdEvaluator(propertyName));
    }

    public ThresholdList(EventList source, ThresholdEvaluator evaluator) {
        super(new SortedList(source, new ThresholdComparator(evaluator)));
        this.source.addListEventListener(this);
        this.evaluator = evaluator;
        this.sourceSize = source.size();
        this.setUpperThreshold(Integer.MAX_VALUE);
        this.setLowerThreshold(Integer.MIN_VALUE);
    }

    public void listChanged(ListEvent listChanges) {
        this.sourceSize = this.source.size();
        this.updates.beginEvent();
        while (listChanges.next()) {
            int transformedIndex;
            int sortedIndex = listChanges.getIndex();
            int type = listChanges.getType();
            int value = Integer.MIN_VALUE;
            if (type != 0 && this.sourceSize > 0) {
                value = this.evaluator.evaluate(this.source.get(sortedIndex));
            }
            if (sortedIndex < this.lowerThresholdIndex - 1) {
                if (type == 2) {
                    ++this.lowerThresholdIndex;
                    ++this.upperThresholdIndex;
                    continue;
                }
                if (type == 0) {
                    --this.lowerThresholdIndex;
                    --this.upperThresholdIndex;
                    continue;
                }
                if (type != 1) continue;
                continue;
            }
            if (sortedIndex == this.lowerThresholdIndex - 1) {
                transformedIndex = sortedIndex - Math.max(this.lowerThresholdIndex, 0);
                if (type == 2) {
                    if (value < this.lowerThreshold) {
                        ++this.lowerThresholdIndex;
                        ++this.upperThresholdIndex;
                        continue;
                    }
                    if (value > this.upperThreshold) continue;
                    ++this.upperThresholdIndex;
                    this.updates.addInsert(transformedIndex);
                    continue;
                }
                if (type == 0) {
                    --this.lowerThresholdIndex;
                    --this.upperThresholdIndex;
                    continue;
                }
                if (type != 1 || value < this.lowerThreshold) continue;
                --this.lowerThresholdIndex;
                this.updates.addInsert(0);
                continue;
            }
            if (sortedIndex >= this.lowerThresholdIndex && sortedIndex <= this.upperThresholdIndex) {
                transformedIndex = sortedIndex - Math.max(this.lowerThresholdIndex, 0);
                if (type == 2) {
                    ++this.upperThresholdIndex;
                    if (value < this.lowerThreshold) {
                        ++this.lowerThresholdIndex;
                        continue;
                    }
                    if (value > this.upperThreshold) {
                        throw new IllegalStateException();
                    }
                    this.updates.addInsert(transformedIndex);
                    continue;
                }
                if (type == 0) {
                    --this.upperThresholdIndex;
                    this.updates.addDelete(transformedIndex);
                    continue;
                }
                if (type != 1) continue;
                if (value < this.lowerThreshold) {
                    ++this.lowerThresholdIndex;
                    this.updates.addDelete(transformedIndex);
                    continue;
                }
                if (value > this.upperThreshold) {
                    --this.upperThresholdIndex;
                    this.updates.addDelete(transformedIndex);
                    continue;
                }
                this.updates.addUpdate(transformedIndex);
                continue;
            }
            if (sortedIndex == this.upperThresholdIndex + 1) {
                transformedIndex = sortedIndex - Math.max(this.lowerThresholdIndex, 0);
                if (type == 2) {
                    if (value >= this.lowerThreshold && value <= this.upperThreshold) {
                        ++this.upperThresholdIndex;
                        this.updates.addInsert(transformedIndex);
                        continue;
                    }
                    if (sortedIndex != this.lowerThresholdIndex || value > this.upperThreshold) continue;
                    ++this.lowerThresholdIndex;
                    ++this.upperThresholdIndex;
                    continue;
                }
                if (type == 0 || type != 1 || value > this.upperThreshold) continue;
                ++this.upperThresholdIndex;
                this.updates.addInsert(transformedIndex);
                continue;
            }
            if (sortedIndex > this.upperThresholdIndex + 1) continue;
            throw new IllegalStateException();
        }
        this.updates.commitEvent();
    }

    public void setLowerThreshold(Object object) {
        this.setLowerThreshold(this.evaluator.evaluate(object));
    }

    public void setLowerThreshold(int threshold) {
        int newListIndex = 0;
        if (this.sourceSize == 0) {
            this.lowerThreshold = threshold;
            this.lowerThresholdIndex = 0;
            return;
        }
        if (threshold == this.lowerThreshold) {
            return;
        }
        newListIndex = ((SortedList)this.source).indexOfSimulated(new Integer(threshold));
        if (newListIndex == 0) {
            newListIndex = this.source.indexOf(new Integer(threshold));
        }
        this.lowerThreshold = threshold;
        if (newListIndex == this.lowerThresholdIndex) {
            return;
        }
        if (newListIndex == -1 && this.lowerThresholdIndex == 0 || newListIndex == 0 && this.lowerThresholdIndex == -1) {
            this.lowerThresholdIndex = newListIndex;
            return;
        }
        this.updates.beginEvent();
        if (newListIndex < this.lowerThresholdIndex) {
            if (newListIndex <= this.upperThresholdIndex) {
                if (this.lowerThresholdIndex > this.upperThresholdIndex) {
                    if (newListIndex != -1 || this.upperThresholdIndex != -1) {
                        this.updates.addInsert(0, this.upperThresholdIndex - Math.max(newListIndex, 0));
                    }
                } else {
                    this.updates.addInsert(0, this.lowerThresholdIndex - Math.max(newListIndex, 0) - 1);
                }
            }
        } else if (newListIndex > this.lowerThresholdIndex && this.lowerThresholdIndex <= this.upperThresholdIndex) {
            if (newListIndex > this.upperThresholdIndex) {
                if (this.lowerThresholdIndex != -1 || this.upperThresholdIndex != -1) {
                    this.updates.addDelete(0, this.upperThresholdIndex - Math.max(this.lowerThresholdIndex, 0));
                }
            } else {
                this.updates.addDelete(0, newListIndex - Math.max(this.lowerThresholdIndex, 0) - 1);
            }
        }
        this.lowerThresholdIndex = newListIndex;
        this.updates.commitEvent();
    }

    public int getLowerThreshold() {
        return this.lowerThreshold;
    }

    public void setUpperThreshold(Object object) {
        this.setUpperThreshold(this.evaluator.evaluate(object));
    }

    public void setUpperThreshold(int threshold) {
        int newListIndex = 0;
        if (this.sourceSize == 0) {
            this.upperThreshold = threshold;
            this.upperThresholdIndex = -1;
            return;
        }
        if (threshold == this.upperThreshold) {
            return;
        }
        newListIndex = threshold == Integer.MAX_VALUE ? this.sourceSize - 1 : ((SortedList)this.source).indexOfSimulated(new Integer(threshold + 1)) - 1;
        this.upperThreshold = threshold;
        if (newListIndex == this.upperThresholdIndex) {
            return;
        }
        if (newListIndex == this.sourceSize && this.upperThresholdIndex == this.sourceSize - 1 || newListIndex == this.sourceSize - 1 && this.upperThresholdIndex == this.sourceSize) {
            this.upperThresholdIndex = newListIndex;
            return;
        }
        this.updates.beginEvent();
        if (newListIndex < this.upperThresholdIndex) {
            if (this.upperThresholdIndex >= this.lowerThresholdIndex) {
                if (newListIndex < this.lowerThresholdIndex) {
                    if (this.lowerThresholdIndex != this.sourceSize || this.upperThresholdIndex != this.sourceSize) {
                        this.updates.addDelete(0, this.upperThresholdIndex - Math.max(this.lowerThresholdIndex, 0));
                    }
                } else {
                    this.updates.addDelete(newListIndex + 1, this.upperThresholdIndex - Math.max(this.lowerThresholdIndex, 0));
                }
            }
        } else if (newListIndex > this.upperThresholdIndex && newListIndex >= this.lowerThresholdIndex) {
            if (this.upperThresholdIndex < this.lowerThresholdIndex) {
                this.updates.addInsert(0, newListIndex - Math.max(this.lowerThresholdIndex, 0));
            } else {
                this.updates.addInsert(this.upperThresholdIndex - Math.max(this.lowerThresholdIndex, 0) + 1, newListIndex);
            }
        }
        this.upperThresholdIndex = newListIndex;
        this.updates.commitEvent();
    }

    public int getUpperThreshold() {
        return this.upperThreshold;
    }

    public ThresholdEvaluator getThresholdEvaluator() {
        return this.evaluator;
    }

    public int size() {
        if (this.lowerThresholdIndex == this.upperThresholdIndex && (this.lowerThresholdIndex == -1 || this.upperThresholdIndex == this.sourceSize)) {
            return 0;
        }
        return Math.min(this.upperThresholdIndex, this.sourceSize - 1) - Math.max(this.lowerThresholdIndex, 0) + 1;
    }

    protected int getSourceIndex(int transformationIndex) {
        return transformationIndex + Math.max(this.lowerThresholdIndex, 0);
    }

    public boolean contains(Object object) {
        int objectEvaluation = this.evaluator.evaluate(object);
        if (objectEvaluation > this.upperThreshold || objectEvaluation < this.lowerThreshold) {
            return false;
        }
        return this.source.contains(object);
    }

    public int indexOf(Object object) {
        int objectEvaluation = this.evaluator.evaluate(object);
        if (objectEvaluation > this.upperThreshold || objectEvaluation < this.lowerThreshold) {
            return -1;
        }
        return this.source.indexOf(object);
    }

    public int lastIndexOf(Object object) {
        int objectEvaluation = this.evaluator.evaluate(object);
        if (objectEvaluation > this.upperThreshold || objectEvaluation < this.lowerThreshold) {
            return -1;
        }
        return this.source.lastIndexOf(object);
    }

    public void dispose() {
        SortedList sortedSource = (SortedList)this.source;
        super.dispose();
        sortedSource.dispose();
    }

    private static final class ThresholdComparator
    implements Comparator {
        private ThresholdEvaluator evaluator = null;

        ThresholdComparator(ThresholdEvaluator evaluator) {
            this.evaluator = evaluator;
        }

        public int compare(Object alpha, Object beta) {
            int alphaValue = 0;
            alphaValue = alpha instanceof Integer ? ((Integer)alpha).intValue() : this.evaluator.evaluate(alpha);
            int betaValue = 0;
            betaValue = beta instanceof Integer ? ((Integer)beta).intValue() : this.evaluator.evaluate(beta);
            if (alphaValue > betaValue) {
                return 1;
            }
            if (alphaValue < betaValue) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof ThresholdComparator)) {
                return false;
            }
            ThresholdComparator other = (ThresholdComparator)object;
            return this.evaluator == other.evaluator;
        }
    }
}

