/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.adt.IndexedTree;
import ca.odell.glazedlists.impl.adt.IndexedTreeNode;
import ca.odell.glazedlists.util.concurrent.InternalReadWriteLock;
import ca.odell.glazedlists.util.concurrent.J2SE12ReadWriteLock;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;

public final class SortedList
extends TransformedList {
    private IndexedTree unsorted = null;
    private IndexedTree sorted = null;
    private Comparator comparator = null;

    public SortedList(EventList source) {
        this(source, GlazedLists.comparableComparator());
    }

    public SortedList(EventList source, Comparator comparator) {
        super(source);
        this.readWriteLock = new InternalReadWriteLock(source.getReadWriteLock(), new J2SE12ReadWriteLock());
        this.setComparator(comparator);
        source.addListEventListener(this);
    }

    public void listChanged(ListEvent listChanges) {
        int unsortedIndex;
        if (listChanges.isReordering()) {
            IndexedTreeNode unsortedNode;
            int[] reorderMap = listChanges.getReorderMap();
            IndexedTreeNode[] sortedNodes = new IndexedTreeNode[this.sorted.size()];
            int index = 0;
            Iterator i = this.unsorted.iterator();
            while (i.hasNext()) {
                IndexedTreeNode sortedNode;
                unsortedNode = (IndexedTreeNode)i.next();
                sortedNodes[index] = sortedNode = (IndexedTreeNode)unsortedNode.getValue();
                ++index;
            }
            index = 0;
            i = this.unsorted.iterator();
            while (i.hasNext()) {
                unsortedNode = (IndexedTreeNode)i.next();
                unsortedNode.setValue(sortedNodes[reorderMap[index]]);
                sortedNodes[reorderMap[index]].setValue(unsortedNode);
                ++index;
            }
            return;
        }
        this.updates.beginEvent();
        LinkedList<IndexedTreeNode> insertNodes = new LinkedList<IndexedTreeNode>();
        while (listChanges.next()) {
            IndexedTreeNode unsortedNode;
            int unsortedIndex2 = listChanges.getIndex();
            int changeType = listChanges.getType();
            if (changeType == 2) {
                unsortedNode = this.unsorted.addByNode(unsortedIndex2, this);
                insertNodes.addLast(unsortedNode);
                continue;
            }
            if (changeType == 0) {
                unsortedNode = this.unsorted.getNode(unsortedIndex2);
                unsortedNode.removeFromTree(this.unsorted);
                int deleteSortedIndex = this.deleteByUnsortedNode(unsortedNode);
                this.updates.addDelete(deleteSortedIndex);
                continue;
            }
            if (changeType != 1) continue;
        }
        IndicesPendingDeletion indicesPendingDeletion = new IndicesPendingDeletion();
        listChanges.reset();
        while (listChanges.next()) {
            unsortedIndex = listChanges.getIndex();
            int changeType = listChanges.getType();
            if (changeType != 1) continue;
            IndexedTreeNode unsortedNode = this.unsorted.getNode(unsortedIndex);
            IndexedTreeNode sortedNode = (IndexedTreeNode)unsortedNode.getValue();
            int originalIndex = sortedNode.getIndex();
            indicesPendingDeletion.addPair(new IndexNodePair(originalIndex, unsortedNode));
        }
        listChanges.reset();
        while (listChanges.next()) {
            unsortedIndex = listChanges.getIndex();
            int changeType = listChanges.getType();
            if (changeType != 1) continue;
            IndexedTreeNode unsortedNode = this.unsorted.getNode(unsortedIndex);
            this.deleteByUnsortedNode(unsortedNode);
        }
        Iterator i = indicesPendingDeletion.iterator();
        while (i.hasNext()) {
            IndexNodePair indexNodePair = (IndexNodePair)i.next();
            i.remove();
            int insertedIndex = this.insertByUnsortedNode(indexNodePair.node);
            int deletedIndex = indexNodePair.index;
            insertedIndex = indicesPendingDeletion.adjustDeleteAndInsert(deletedIndex, insertedIndex);
            if (deletedIndex == insertedIndex) {
                this.updates.addUpdate(insertedIndex);
                continue;
            }
            this.updates.addDelete(deletedIndex);
            this.updates.addInsert(insertedIndex);
        }
        while (!insertNodes.isEmpty()) {
            IndexedTreeNode insertNode = (IndexedTreeNode)insertNodes.removeFirst();
            int insertedIndex = this.insertByUnsortedNode(insertNode);
            this.updates.addInsert(insertedIndex);
        }
        this.updates.commitEvent();
    }

    private int insertByUnsortedNode(IndexedTreeNode unsortedNode) {
        IndexedTreeNode sortedNode = this.sorted.addByNode(unsortedNode);
        unsortedNode.setValue(sortedNode);
        return sortedNode.getIndex();
    }

    private int deleteByUnsortedNode(IndexedTreeNode unsortedNode) {
        IndexedTreeNode sortedNode = (IndexedTreeNode)unsortedNode.getValue();
        int sortedIndex = sortedNode.getIndex();
        sortedNode.removeFromTree(this.sorted);
        return sortedIndex;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
        IndexedTree previousSorted = this.sorted;
        Comparator treeComparator = null;
        treeComparator = comparator != null ? new IndexedTreeNodeComparator(comparator) : new IndexedTreeNodeRawOrderComparator();
        this.sorted = new IndexedTree(treeComparator);
        if (previousSorted == null && this.unsorted == null) {
            this.unsorted = new IndexedTree();
            for (int i = 0; i < this.source.size(); ++i) {
                IndexedTreeNode unsortedNode = this.unsorted.addByNode(i, this);
                this.insertByUnsortedNode(unsortedNode);
            }
            return;
        }
        if (this.source.size() == 0) {
            return;
        }
        Iterator i = this.unsorted.iterator();
        while (i.hasNext()) {
            IndexedTreeNode unsortedNode = (IndexedTreeNode)i.next();
            this.insertByUnsortedNode(unsortedNode);
        }
        int[] reorderMap = new int[this.size()];
        int oldSortedIndex = 0;
        Iterator i2 = previousSorted.iterator();
        while (i2.hasNext()) {
            IndexedTreeNode oldSortedNode = (IndexedTreeNode)i2.next();
            IndexedTreeNode unsortedNode = (IndexedTreeNode)oldSortedNode.getValue();
            IndexedTreeNode newSortedNode = (IndexedTreeNode)unsortedNode.getValue();
            int newSortedIndex = newSortedNode.getIndex();
            reorderMap[newSortedIndex] = oldSortedIndex++;
        }
        this.updates.beginEvent();
        this.updates.reorder(reorderMap);
        this.updates.commitEvent();
    }

    protected int getSourceIndex(int mutationIndex) {
        IndexedTreeNode sortedNode = this.sorted.getNode(mutationIndex);
        IndexedTreeNode unsortedNode = (IndexedTreeNode)sortedNode.getValue();
        int unsortedIndex = unsortedNode.getIndex();
        return unsortedIndex;
    }

    protected boolean isWritable() {
        return true;
    }

    public boolean contains(Object object) {
        return this.sorted.contains(object);
    }

    public int indexOf(Object object) {
        if (this.comparator != null) {
            return this.sorted.indexOf(object);
        }
        return this.source.indexOf(object);
    }

    public int lastIndexOf(Object object) {
        if (this.comparator != null) {
            return this.sorted.lastIndexOf(object);
        }
        return this.source.lastIndexOf(object);
    }

    public int indexOfSimulated(Object object) {
        if (this.comparator != null) {
            return this.sorted.indexOfSimulated(object);
        }
        return this.size();
    }

    public Iterator iterator() {
        return new SortedListIterator();
    }

    private class SortedListIterator
    implements Iterator {
        private ListIterator treeIterator;
        private int lastUnsortedIndex;

        private SortedListIterator() {
            this.treeIterator = SortedList.this.sorted.listIterator(0);
            this.lastUnsortedIndex = -1;
        }

        public boolean hasNext() {
            return this.treeIterator.hasNext();
        }

        public Object next() {
            IndexedTreeNode sortedNode = (IndexedTreeNode)this.treeIterator.next();
            IndexedTreeNode unsortedNode = (IndexedTreeNode)sortedNode.getValue();
            this.lastUnsortedIndex = unsortedNode.getIndex();
            return SortedList.this.source.get(this.lastUnsortedIndex);
        }

        public void remove() {
            if (this.lastUnsortedIndex == -1) {
                throw new NoSuchElementException("Cannot remove before next is called");
            }
            if (this.treeIterator.hasPrevious()) {
                this.treeIterator.previous();
                SortedList.this.source.remove(this.lastUnsortedIndex);
            } else {
                SortedList.this.source.remove(this.lastUnsortedIndex);
                this.treeIterator = SortedList.this.sorted.listIterator(0);
            }
            this.lastUnsortedIndex = -1;
        }
    }

    private class IndexNodePair
    implements Comparable {
        private int index;
        private IndexedTreeNode node;

        public IndexNodePair(int index, IndexedTreeNode node) {
            this.index = index;
            this.node = node;
        }

        public String toString() {
            return "" + this.index + "(" + SortedList.this.source.get(this.node.getIndex()) + ")";
        }

        public int compareTo(Object other) {
            IndexNodePair otherIndexNodePair = (IndexNodePair)other;
            if (SortedList.this.comparator != null) {
                Object myObject = SortedList.this.source.get(this.node.getIndex());
                Object otherObject = SortedList.this.source.get(otherIndexNodePair.node.getIndex());
                int compareResult = SortedList.this.comparator.compare(myObject, otherObject);
                if (compareResult != 0) {
                    return compareResult;
                }
            }
            return this.index - otherIndexNodePair.index;
        }
    }

    private static class IndicesPendingDeletion {
        SortedSet indexNodePairs = new TreeSet();

        private IndicesPendingDeletion() {
        }

        public void addPair(IndexNodePair nodePair) {
            this.indexNodePairs.add(nodePair);
        }

        public int adjustDeleteAndInsert(int deletedIndex, int insertedIndex) {
            Iterator i = this.indexNodePairs.iterator();
            while (i.hasNext()) {
                IndexNodePair indexNodePair = (IndexNodePair)i.next();
                if (deletedIndex < indexNodePair.index) {
                    indexNodePair.index--;
                }
                if (insertedIndex <= indexNodePair.index) {
                    indexNodePair.index++;
                    continue;
                }
                ++insertedIndex;
            }
            return insertedIndex;
        }

        public Iterator iterator() {
            return this.indexNodePairs.iterator();
        }

        public String toString() {
            return "" + this.indexNodePairs;
        }
    }

    private class IndexedTreeNodeComparator
    implements Comparator {
        private Comparator comparator;

        public IndexedTreeNodeComparator(Comparator comparator) {
            this.comparator = comparator;
        }

        public int compare(Object alpha, Object beta) {
            int result;
            Object alphaObject = alpha;
            Object betaObject = beta;
            int alphaIndex = -1;
            int betaIndex = -1;
            if (alpha instanceof IndexedTreeNode) {
                IndexedTreeNode alphaTreeNode = (IndexedTreeNode)alpha;
                alphaIndex = alphaTreeNode.getIndex();
                alphaObject = SortedList.this.source.get(alphaIndex);
            }
            if (beta instanceof IndexedTreeNode) {
                IndexedTreeNode betaTreeNode = (IndexedTreeNode)beta;
                betaIndex = betaTreeNode.getIndex();
                betaObject = SortedList.this.source.get(betaIndex);
            }
            if ((result = this.comparator.compare(alphaObject, betaObject)) != 0) {
                return result;
            }
            if (alphaIndex != -1 && betaIndex != -1) {
                return alphaIndex - betaIndex;
            }
            return 0;
        }
    }

    private static class IndexedTreeNodeRawOrderComparator
    implements Comparator {
        private IndexedTreeNodeRawOrderComparator() {
        }

        public int compare(Object alpha, Object beta) {
            try {
                IndexedTreeNode alphaTreeNode = (IndexedTreeNode)alpha;
                IndexedTreeNode betaTreeNode = (IndexedTreeNode)beta;
                int alphaIndex = alphaTreeNode.getIndex();
                int betaIndex = betaTreeNode.getIndex();
                return alphaIndex - betaIndex;
            }
            catch (ClassCastException e) {
                System.out.println(alpha.getClass());
                System.out.println(beta.getClass());
                throw e;
            }
        }
    }
}

