/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.AbstractEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.util.concurrent.J2SE12ReadWriteLock;
import ca.odell.glazedlists.util.concurrent.Lock;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

final class OldCompositeList
extends AbstractEventList {
    private List memberLists = new ArrayList();
    private LinkedList globalChangeQueue = new LinkedList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public OldCompositeList() {
        super(null);
        this.readWriteLock = new CompositeReadWriteLock();
    }

    public void addMemberList(EventList list) {
        MemberList memberList = new MemberList(list);
        this.memberLists.add(memberList);
        ((CompositeReadWriteLock)this.getReadWriteLock()).lockNewMember(memberList);
        int offset = this.getListOffset(memberList);
        if (memberList.size() > 0) {
            this.updates.beginEvent();
            this.updates.addInsert(offset, offset + memberList.size() - 1);
            this.updates.commitEvent();
        }
    }

    public void removeMemberList(EventList list) {
        MemberList memberList = null;
        for (int i = 0; i < this.memberLists.size(); ++i) {
            MemberList current = (MemberList)this.memberLists.get(i);
            if (current.getSourceList() != list) continue;
            memberList = current;
            break;
        }
        if (memberList == null) {
            throw new IllegalArgumentException("Cannot remove list " + list + " which is not in this CompositeList");
        }
        memberList.getSourceList().removeListEventListener(memberList);
        int offset = this.getListOffset(memberList);
        this.memberLists.remove(memberList);
        if (memberList.size() > 0) {
            this.updates.beginEvent();
            this.updates.addDelete(offset, offset + memberList.size() - 1);
            this.updates.commitEvent();
        }
    }

    public Object get(int index) {
        for (int i = 0; i < this.memberLists.size(); ++i) {
            MemberList current = (MemberList)this.memberLists.get(i);
            if (index < current.size()) {
                return current.getSourceList().get(index);
            }
            index -= current.size();
        }
        return null;
    }

    public Object set(int index, Object value) {
        for (int i = 0; i < this.memberLists.size(); ++i) {
            MemberList current = (MemberList)this.memberLists.get(i);
            if (index < current.size()) {
                return current.getSourceList().set(index, value);
            }
            index -= current.size();
        }
        return null;
    }

    public Object remove(int index) {
        for (int i = 0; i < this.memberLists.size(); ++i) {
            MemberList current = (MemberList)this.memberLists.get(i);
            if (index < current.size()) {
                return current.getSourceList().remove(index);
            }
            index -= current.size();
        }
        return null;
    }

    public int size() {
        int size = 0;
        for (int i = 0; i < this.memberLists.size(); ++i) {
            MemberList current = (MemberList)this.memberLists.get(i);
            size += current.size();
        }
        return size;
    }

    private int getListOffset(MemberList memberList) {
        int listOffset = 0;
        for (int i = 0; i < this.memberLists.size(); ++i) {
            MemberList current = (MemberList)this.memberLists.get(i);
            if (current == memberList) {
                return listOffset;
            }
            listOffset += current.size();
        }
        throw new IllegalStateException("Unable to find offset of member list " + memberList);
    }

    private void propagateChanges() {
        while (!this.globalChangeQueue.isEmpty()) {
            this.updates.beginEvent();
            MemberList listWithChanges = (MemberList)this.globalChangeQueue.removeFirst();
            ListEvent listChanges = (ListEvent)listWithChanges.changeQueue.removeFirst();
            int offset = this.getListOffset(listWithChanges);
            while (listChanges.next()) {
                int index = listChanges.getIndex();
                int type = listChanges.getType();
                this.updates.addChange(type, offset + index);
                if (type == 0) {
                    listWithChanges.size--;
                } else if (type == 2) {
                    listWithChanges.size++;
                }
                if (!$assertionsDisabled && listWithChanges.size < 0) {
                    throw new AssertionError();
                }
            }
            this.updates.commitEvent();
        }
    }

    static {
        $assertionsDisabled = !OldCompositeList.class.desiredAssertionStatus();
    }

    private class CompositeLock
    implements Lock {
        private Lock raceLock = new J2SE12ReadWriteLock().writeLock();
        private List lockedMemberLists = new ArrayList();
        private boolean locked = false;

        private CompositeLock() {
        }

        public void lock() {
            this.raceLock.lock();
            this.locked = true;
            Iterator i = OldCompositeList.this.memberLists.iterator();
            while (i.hasNext()) {
                MemberList memberList = (MemberList)i.next();
                memberList.getSourceList().getReadWriteLock().readLock().lock();
                this.lockedMemberLists.add(memberList);
            }
            OldCompositeList.this.propagateChanges();
        }

        public void lockNewMember(MemberList newMember) {
            if (this.locked) {
                newMember.getSourceList().getReadWriteLock().readLock().lock();
                this.lockedMemberLists.add(newMember);
            }
        }

        public boolean tryLock() {
            this.locked = false;
            boolean success = this.raceLock.tryLock();
            if (!success) {
                return false;
            }
            Iterator i = OldCompositeList.this.memberLists.iterator();
            while (i.hasNext()) {
                MemberList memberList = (MemberList)i.next();
                memberList.getSourceList().getReadWriteLock().readLock().lock();
                this.lockedMemberLists.add(memberList);
            }
            OldCompositeList.this.propagateChanges();
            return true;
        }

        public void unlock() {
            ArrayList locksToRelease = new ArrayList();
            locksToRelease.addAll(this.lockedMemberLists);
            this.lockedMemberLists.clear();
            this.raceLock.unlock();
            Iterator i = locksToRelease.iterator();
            while (i.hasNext()) {
                MemberList memberList = (MemberList)i.next();
                memberList.getSourceList().getReadWriteLock().readLock().unlock();
            }
            this.lockedMemberLists.clear();
        }
    }

    private class CompositeReadWriteLock
    implements ReadWriteLock {
        CompositeLock lock;

        private CompositeReadWriteLock() {
            this.lock = new CompositeLock();
        }

        public Lock readLock() {
            return this.lock;
        }

        public void lockNewMember(MemberList newMember) {
            this.lock.lockNewMember(newMember);
        }

        public Lock writeLock() {
            return this.lock;
        }
    }

    private class MemberList
    implements ListEventListener {
        private EventList sourceList;
        private int size;
        private LinkedList changeQueue = new LinkedList();

        public MemberList(EventList sourceList) {
            this.sourceList = sourceList;
            this.size = sourceList.size();
            sourceList.addListEventListener(this);
        }

        public int size() {
            return this.size;
        }

        public EventList getSourceList() {
            return this.sourceList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void listChanged(ListEvent listChanges) {
            OldCompositeList oldCompositeList = OldCompositeList.this;
            synchronized (oldCompositeList) {
                this.changeQueue.addLast(listChanges);
                OldCompositeList.this.globalChangeQueue.addLast(this);
            }
            boolean locked = OldCompositeList.this.getReadWriteLock().writeLock().tryLock();
            if (locked) {
                OldCompositeList.this.getReadWriteLock().writeLock().unlock();
            }
        }
    }
}

