/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class OfflineList
extends AbstractList
implements List {
    private RandomAccessFile file;
    private List map = new ArrayList();

    public OfflineList() throws IOException {
        File tmp = File.createTempFile("NB-FileList-", null);
        tmp.deleteOnExit();
        this.file = new RandomAccessFile(tmp, "rw");
    }

    public final Object get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        Long filePos = (Long)this.map.get(index);
        long pos = filePos;
        return this.readFromFile(pos);
    }

    public final int size() {
        return this.map.size();
    }

    public final void add(int index, Object element) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " of " + this.size());
        }
        if (element != null && !(element instanceof Serializable)) {
            throw new ClassCastException("got " + element.getClass());
        }
        long pos = this.writeToFile(element);
        this.map.add(index, new Long(pos));
    }

    public final Object set(int index, Object element) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " of " + this.size());
        }
        if (element != null && !(element instanceof Serializable)) {
            throw new ClassCastException("got " + element.getClass());
        }
        Object orig = this.get(index);
        long pos = this.writeToFile(element);
        this.map.set(index, new Long(pos));
        return orig;
    }

    public final Object remove(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " of " + this.size());
        }
        Object orig = this.get(index);
        this.map.remove(index);
        return orig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] toBytes(Object object) throws IOException {
        if (object == null) {
            object = new Null();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(out);
        try {
            oos.writeObject(object);
            oos.flush();
        }
        finally {
            oos.close();
        }
        byte[] data = out.toByteArray();
        return data;
    }

    protected Object fromBytes(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(in){

            protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                return super.resolveClass(desc);
            }
        };
        Object obj = ois.readObject();
        ois.close();
        if (obj instanceof Null) {
            return null;
        }
        return obj;
    }

    private long writeToFile(Object element) {
        try {
            byte[] data = this.toBytes(element);
            long len = this.file.length();
            this.file.seek(len);
            this.file.writeInt(data.length);
            this.file.write(data);
            return len;
        }
        catch (IOException ex) {
            RuntimeException out = new RuntimeException(ex.getMessage());
            out.initCause(ex);
            throw out;
        }
    }

    private Object readFromFile(long pos) {
        try {
            this.file.seek(pos);
            int size = this.file.readInt();
            byte[] data = new byte[size];
            this.file.readFully(data);
            return this.fromBytes(data);
        }
        catch (IOException ex) {
            RuntimeException out = new RuntimeException(ex.getMessage());
            out.initCause(ex);
            throw out;
        }
        catch (ClassNotFoundException ex) {
            RuntimeException out = new RuntimeException(ex.getMessage());
            out.initCause(ex);
            throw out;
        }
    }

    protected void finalize() throws Throwable {
        this.file.setLength(0L);
        this.file.close();
    }

    private static class Null
    implements Serializable {
        private Null() {
        }
    }
}

