/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.CachingList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.WaitEventList;
import java.util.Random;

class CacheTestHelper {
    private int requestWaitTime = 0;
    private int sourceListSize = 0;
    private int cacheSize = 0;
    private int interval = 0;
    private CachingList testCache = null;
    private EventList sourceList = null;

    protected CacheTestHelper(int sourceListSize, int requestWaitTime) {
        this.sourceListSize = sourceListSize;
        this.requestWaitTime = requestWaitTime;
        this.cacheSize = (int)Math.round((double)sourceListSize / 2.0);
        this.interval = (int)Math.round((double)this.cacheSize / 10.0);
    }

    protected CacheTestHelper(int sourceListSize, int cacheSize, int requestWaitTime) {
        this.sourceListSize = sourceListSize;
        this.requestWaitTime = requestWaitTime;
        this.cacheSize = cacheSize;
        this.interval = (int)Math.round((double)cacheSize / 10.0);
    }

    protected void runTests() {
        System.out.println("Beginning Performance Tests...");
        this.sourceList = new WaitEventList(this.requestWaitTime);
        for (int i = 0; i < this.sourceListSize; ++i) {
            this.sourceList.add(new Integer(i));
        }
        long startTime = System.currentTimeMillis();
        this.testRetrievalFromCache();
        this.setUp();
        this.testRemoveOfCachedData();
        this.tearDown();
        this.setUp();
        this.testRemoveOfUncachedData();
        this.tearDown();
        this.setUp();
        this.testRandomInsertion();
        this.tearDown();
        this.setUp();
        this.testClearingFullCache();
        this.tearDown();
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        System.out.println("End of Tests");
        System.out.println("Total Test Time: " + totalTime + "ms.");
    }

    private void testRetrievalFromCache() {
        for (int i = 0; i <= 10; ++i) {
            this.setUp();
            this.performNGets(i * this.interval);
            this.tearDown();
        }
    }

    private void testRemoveOfCachedData() {
        System.out.println("Testing the Expense of Removing " + this.cacheSize + " Cached Entries.");
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < this.cacheSize; ++i) {
            this.sourceList.remove(0);
        }
        long endTime = System.currentTimeMillis();
        long timeTaken = endTime - startTime;
        System.out.println("Test completed in: " + timeTaken + "ms\n");
    }

    private void testRemoveOfUncachedData() {
        System.out.println("Testing the Expense of Removing " + this.cacheSize + " Uncached Entries.");
        long startTime = System.currentTimeMillis();
        for (int i = this.cacheSize; i < this.sourceListSize; ++i) {
            this.sourceList.remove(this.cacheSize);
        }
        long endTime = System.currentTimeMillis();
        long timeTaken = endTime - startTime;
        System.out.println("Test completed in: " + timeTaken + "ms\n");
    }

    private void testRandomInsertion() {
        Random random = new Random();
        System.out.println("Testing the Expense of " + this.cacheSize + " Random Insertions.");
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < this.cacheSize; ++i) {
            int index = random.nextInt(this.cacheSize);
            this.sourceList.add(index, new Integer(index));
        }
        long endTime = System.currentTimeMillis();
        long timeTaken = endTime - startTime;
        System.out.println("Test completed in: " + timeTaken + "ms\n");
    }

    private void testClearingFullCache() {
        System.out.println("Testing the Expense of Calling clear() on a Full Cache");
        long startTime = System.currentTimeMillis();
        this.testCache.clear();
        long endTime = System.currentTimeMillis();
        long timeTaken = endTime - startTime;
        System.out.println("Test completed in: " + timeTaken + "ms\n");
    }

    private void performNGets(int start) {
        System.out.println("Running Test For A Cache Containing " + 100.0 * (double)(((float)this.cacheSize - (float)start) / (float)this.cacheSize) + "% of the searched for values: ");
        long startTime = System.currentTimeMillis();
        for (int j = start; j < start + this.cacheSize; ++j) {
            this.testCache.get(j);
        }
        long endTime = System.currentTimeMillis();
        long timeTaken = endTime - startTime;
        int uncachedExpense = (this.testCache.getCacheMisses() - this.cacheSize) * this.requestWaitTime;
        System.out.println("Percentage of cache used: " + (double)this.getCacheHitRatio() * 100.0 + "%");
        System.out.println("Test completed in: " + timeTaken + "ms");
        System.out.println("Cost of Uncached Information Retrieval: " + uncachedExpense + "ms");
        System.out.println("Net Expense of using CachingList: " + Math.round(timeTaken - (long)uncachedExpense) + "ms\n");
    }

    private void setUp() {
        this.testCache = new CachingList(this.sourceList, this.cacheSize);
        for (int i = 0; i < this.cacheSize; ++i) {
            this.testCache.get(i);
        }
    }

    private void tearDown() {
        this.testCache = null;
    }

    private float getCacheHitRatio() {
        int cacheMisses;
        int cacheHits = this.testCache.getCacheHits();
        if (cacheHits + (cacheMisses = this.testCache.getCacheMisses() - this.cacheSize) == 0) {
            return 0.0f;
        }
        return (float)cacheHits / (float)(cacheHits + cacheMisses);
    }
}

