/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.support;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.cluster.RedisClusterClient;
import com.lambdaworks.redis.resource.ClientResources;
import com.lambdaworks.redis.support.RedisClientCdiBean;
import com.lambdaworks.redis.support.RedisClusterClientCdiBean;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;

public class LettuceCdiExtension
implements Extension {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(LettuceCdiExtension.class);
    private final Map<Set<Annotation>, Bean<RedisURI>> redisUris = Maps.newConcurrentMap();
    private final Map<Set<Annotation>, Bean<ClientResources>> clientResources = Maps.newConcurrentMap();

    public LettuceCdiExtension() {
        LOGGER.info("Activating CDI extension for lettuce.");
    }

    <T> void processBean(@Observes ProcessBean<T> processBean) {
        Bean bean = processBean.getBean();
        for (Type type : bean.getTypes()) {
            HashSet qualifiers;
            if (!(type instanceof Class)) continue;
            if (RedisURI.class.isAssignableFrom((Class)type)) {
                qualifiers = new HashSet(bean.getQualifiers());
                if (bean.isAlternative() || !this.redisUris.containsKey(qualifiers)) {
                    LOGGER.debug(String.format("Discovered '%s' with qualifiers %s.", RedisURI.class.getName(), qualifiers));
                    this.redisUris.put(qualifiers, (Bean<RedisURI>)bean);
                }
            }
            if (!ClientResources.class.isAssignableFrom((Class)type)) continue;
            qualifiers = new HashSet(bean.getQualifiers());
            if (!bean.isAlternative() && this.clientResources.containsKey(qualifiers)) continue;
            LOGGER.debug(String.format("Discovered '%s' with qualifiers %s.", ClientResources.class.getName(), qualifiers));
            this.clientResources.put(qualifiers, (Bean<ClientResources>)bean);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        int counter = 0;
        for (Map.Entry<Set<Annotation>, Bean<RedisURI>> entry : this.redisUris.entrySet()) {
            Bean<RedisURI> redisUri = entry.getValue();
            Set<Annotation> qualifiers = entry.getKey();
            String clientBeanName = RedisClient.class.getSimpleName();
            String clusterClientBeanName = RedisClusterClient.class.getSimpleName();
            if (!this.contains(qualifiers, Default.class)) {
                clientBeanName = clientBeanName + counter;
                clusterClientBeanName = clusterClientBeanName + counter;
                ++counter;
            }
            Bean<ClientResources> clientResources = this.clientResources.get(qualifiers);
            RedisClientCdiBean clientBean = new RedisClientCdiBean(redisUri, clientResources, beanManager, qualifiers, clientBeanName);
            this.register(afterBeanDiscovery, qualifiers, clientBean);
            RedisClusterClientCdiBean clusterClientBean = new RedisClusterClientCdiBean(redisUri, clientResources, beanManager, qualifiers, clusterClientBeanName);
            this.register(afterBeanDiscovery, qualifiers, clusterClientBean);
        }
    }

    private boolean contains(Set<Annotation> qualifiers, Class<Default> defaultClass) {
        Optional result = Iterables.tryFind(qualifiers, (Predicate)new Predicate<Annotation>(){

            public boolean apply(Annotation input) {
                return input instanceof Default;
            }
        });
        return result.isPresent();
    }

    private void register(AfterBeanDiscovery afterBeanDiscovery, Set<Annotation> qualifiers, Bean<?> bean) {
        LOGGER.info(String.format("Registering bean '%s' with qualifiers %s.", bean.getBeanClass().getName(), qualifiers));
        afterBeanDiscovery.addBean(bean);
    }
}

