/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.event;

import com.google.common.base.Preconditions;
import com.lambdaworks.redis.event.EventPublisherOptions;
import java.util.concurrent.TimeUnit;

public class DefaultEventPublisherOptions
implements EventPublisherOptions {
    public static final long DEFAULT_EMIT_INTERVAL = 10L;
    public static final TimeUnit DEFAULT_EMIT_INTERVAL_UNIT = TimeUnit.MINUTES;
    private static final DefaultEventPublisherOptions DISABLED = new Builder().eventEmitInterval(0L, TimeUnit.SECONDS).build();
    private final long eventEmitInterval;
    private final TimeUnit eventEmitIntervalUnit;

    protected DefaultEventPublisherOptions(Builder builder) {
        this.eventEmitInterval = builder.eventEmitInterval;
        this.eventEmitIntervalUnit = builder.eventEmitIntervalUnit;
    }

    @Override
    public long eventEmitInterval() {
        return this.eventEmitInterval;
    }

    @Override
    public TimeUnit eventEmitIntervalUnit() {
        return this.eventEmitIntervalUnit;
    }

    public static DefaultEventPublisherOptions create() {
        return new Builder().build();
    }

    public static DefaultEventPublisherOptions disabled() {
        return DISABLED;
    }

    public static class Builder {
        private long eventEmitInterval = 10L;
        private TimeUnit eventEmitIntervalUnit = DEFAULT_EMIT_INTERVAL_UNIT;

        public Builder eventEmitInterval(long eventEmitInterval, TimeUnit eventEmitIntervalUnit) {
            Preconditions.checkArgument((eventEmitInterval >= 0L ? 1 : 0) != 0, (Object)"eventEmitInterval must be greater or equal to 0");
            Preconditions.checkArgument((eventEmitIntervalUnit != null ? 1 : 0) != 0, (Object)"eventEmitIntervalUnit must not be null");
            this.eventEmitInterval = eventEmitInterval;
            this.eventEmitIntervalUnit = eventEmitIntervalUnit;
            return this;
        }

        public DefaultEventPublisherOptions build() {
            return new DefaultEventPublisherOptions(this);
        }
    }
}

