/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisFuture;
import com.lambdaworks.redis.RedisSentinelAsyncConnection;
import com.lambdaworks.redis.SentinelCommandBuilder;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.protocol.Command;
import com.lambdaworks.redis.protocol.RedisCommand;
import io.netty.channel.ChannelHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

@ChannelHandler.Sharable
class RedisSentinelAsyncConnectionImpl<K, V>
extends RedisChannelHandler<K, V>
implements RedisSentinelAsyncConnection<K, V> {
    private final SentinelCommandBuilder<K, V> commandBuilder;

    public RedisSentinelAsyncConnectionImpl(RedisChannelWriter<K, V> writer, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        super(writer, timeout, unit);
        this.commandBuilder = new SentinelCommandBuilder<K, V>(codec);
    }

    @Override
    public Future<SocketAddress> getMasterAddrByName(K key) {
        Command<K, V, List<V>> cmd = this.commandBuilder.getMasterAddrByKey(key);
        RedisCommand<K, V, List<V>> future = this.dispatch(cmd);
        Future result = Futures.lazyTransform(future, (Function)new Function<List<V>, SocketAddress>(){

            public SocketAddress apply(List<V> input) {
                if (input.isEmpty()) {
                    return null;
                }
                Preconditions.checkArgument((input.size() == 2 ? 1 : 0) != 0, (Object)"List must contain exact 2 entries (Hostname, Port)");
                String hostname = (String)input.get(0);
                String port = (String)input.get(1);
                return new InetSocketAddress(hostname, Integer.parseInt(port));
            }
        });
        return result;
    }

    @Override
    public RedisFuture<List<Map<K, V>>> masters() {
        return this.dispatch(this.commandBuilder.masters());
    }

    @Override
    public RedisFuture<Map<K, V>> master(K key) {
        return this.dispatch(this.commandBuilder.master(key));
    }

    @Override
    public RedisFuture<List<Map<K, V>>> slaves(K key) {
        return this.dispatch(this.commandBuilder.slaves(key));
    }

    @Override
    public RedisFuture<Long> reset(K key) {
        return this.dispatch(this.commandBuilder.reset(key));
    }

    @Override
    public RedisFuture<String> failover(K key) {
        return this.dispatch(this.commandBuilder.failover(key));
    }

    @Override
    public RedisFuture<String> monitor(K key, String ip, int port, int quorum) {
        return this.dispatch(this.commandBuilder.monitor(key, ip, port, quorum));
    }

    @Override
    public RedisFuture<String> set(K key, String option, V value) {
        return this.dispatch(this.commandBuilder.set(key, option, value));
    }

    @Override
    public RedisFuture<String> remove(K key) {
        return this.dispatch(this.commandBuilder.remove(key));
    }

    @Override
    public RedisFuture<String> ping() {
        return this.dispatch(this.commandBuilder.ping());
    }
}

