/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ClonedInputStream
extends InputStream {
    private InputStream is;
    private ByteArrayOutputStream os = new ByteArrayOutputStream();

    public ClonedInputStream(InputStream is) {
        this.is = is;
    }

    @Override
    public int read() throws IOException {
        int resp = this.is.read();
        this.os.write(resp);
        return resp;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int resp = this.is.read(b);
        this.os.write(b);
        return resp;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int resp = this.is.read(b, off, len);
        this.os.write(b, off, len);
        return resp;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public void close() throws IOException {
        this.os.close();
        this.is.close();
    }

    @Override
    public void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.os.reset();
        this.is.reset();
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }

    public ByteArrayOutputStream getOutput() {
        return this.os;
    }
}

