/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy.jetty.http;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import org.apache.commons.logging.Log;
import org.browsermob.proxy.jetty.http.HttpConnection;
import org.browsermob.proxy.jetty.http.HttpContext;
import org.browsermob.proxy.jetty.http.HttpFields;
import org.browsermob.proxy.jetty.http.HttpHandler;
import org.browsermob.proxy.jetty.http.HttpInputStream;
import org.browsermob.proxy.jetty.http.HttpMessage;
import org.browsermob.proxy.jetty.http.HttpOutputStream;
import org.browsermob.proxy.jetty.http.HttpRequest;
import org.browsermob.proxy.jetty.http.Version;
import org.browsermob.proxy.jetty.log.LogFactory;
import org.browsermob.proxy.jetty.util.StringUtil;
import org.browsermob.proxy.jetty.util.TypeUtil;
import org.browsermob.proxy.jetty.util.UrlEncoded;

public class HttpResponse
extends HttpMessage {
    private static Log log = LogFactory.getLog(HttpResponse.class);
    public static final int __100_Continue = 100;
    public static final int __101_Switching_Protocols = 101;
    public static final int __102_Processing = 102;
    public static final int __200_OK = 200;
    public static final int __201_Created = 201;
    public static final int __202_Accepted = 202;
    public static final int __203_Non_Authoritative_Information = 203;
    public static final int __204_No_Content = 204;
    public static final int __205_Reset_Content = 205;
    public static final int __206_Partial_Content = 206;
    public static final int __207_Multi_Status = 207;
    public static final int __300_Multiple_Choices = 300;
    public static final int __301_Moved_Permanently = 301;
    public static final int __302_Moved_Temporarily = 302;
    public static final int __302_Found = 302;
    public static final int __303_See_Other = 303;
    public static final int __304_Not_Modified = 304;
    public static final int __305_Use_Proxy = 305;
    public static final int __400_Bad_Request = 400;
    public static final int __401_Unauthorized = 401;
    public static final int __402_Payment_Required = 402;
    public static final int __403_Forbidden = 403;
    public static final int __404_Not_Found = 404;
    public static final int __405_Method_Not_Allowed = 405;
    public static final int __406_Not_Acceptable = 406;
    public static final int __407_Proxy_Authentication_Required = 407;
    public static final int __408_Request_Timeout = 408;
    public static final int __409_Conflict = 409;
    public static final int __410_Gone = 410;
    public static final int __411_Length_Required = 411;
    public static final int __412_Precondition_Failed = 412;
    public static final int __413_Request_Entity_Too_Large = 413;
    public static final int __414_Request_URI_Too_Large = 414;
    public static final int __415_Unsupported_Media_Type = 415;
    public static final int __416_Requested_Range_Not_Satisfiable = 416;
    public static final int __417_Expectation_Failed = 417;
    public static final int __422_Unprocessable_Entity = 422;
    public static final int __423_Locked = 423;
    public static final int __424_Failed_Dependency = 424;
    public static final int __500_Internal_Server_Error = 500;
    public static final int __501_Not_Implemented = 501;
    public static final int __502_Bad_Gateway = 502;
    public static final int __503_Service_Unavailable = 503;
    public static final int __504_Gateway_Timeout = 504;
    public static final int __505_HTTP_Version_Not_Supported = 505;
    public static final int __507_Insufficient_Storage = 507;
    public static final HashMap __statusMsg = new HashMap();
    static byte[] __Continue;
    private int _status = 200;
    private String _reason;
    private HttpContext _httpContext;

    public HttpResponse() {
        this._version = "HTTP/1.1";
        this._dotVersion = 1;
        this._state = 0;
    }

    public HttpResponse(HttpConnection connection) {
        super(connection);
        this._version = "HTTP/1.1";
        this._dotVersion = 1;
        this._state = 0;
    }

    public HttpContext getHttpContext() {
        return this._httpContext;
    }

    public void setHttpContext(HttpContext context) {
        this._httpContext = context;
    }

    @Override
    public boolean isDirty() {
        return this._status != 200 || super.isDirty();
    }

    @Override
    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Already committed");
        }
        try {
            ((HttpOutputStream)this.getOutputStream()).resetBuffer();
            this._status = 200;
            this._reason = null;
            super.reset();
            this.setField("Date", this.getRequest().getTimeStampStr());
            if (!Version.isParanoid()) {
                this.setField("Server", Version.getDetail());
            }
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
            throw new IllegalStateException(e.toString());
        }
    }

    public HttpRequest getRequest() {
        return this.getHttpRequest();
    }

    public HttpRequest getHttpRequest() {
        if (this._connection == null) {
            return null;
        }
        return this._connection.getRequest();
    }

    public void readHeader(HttpInputStream in) throws IOException {
        this._state = 1;
        log.warn((Object)"NOT IMPLEMENTED ");
    }

    @Override
    public void writeHeader(Writer writer) throws IOException {
        if (this._state != 0) {
            throw new IllegalStateException(__state[this._state] + " is not EDITABLE");
        }
        if (this._header == null) {
            throw new IllegalStateException("Response is destroyed");
        }
        if (this.getHttpRequest().getDotVersion() >= 0) {
            this._state = 1;
            writer.write(this._version);
            writer.write(32);
            writer.write(48 + this._status / 100 % 10);
            writer.write(48 + this._status / 10 % 10);
            writer.write(48 + this._status % 10);
            writer.write(32);
            writer.write(this.getReason());
            writer.write(HttpFields.__CRLF);
            this._header.write(writer);
        }
        this._state = 3;
    }

    public int getStatus() {
        return this._status;
    }

    public void setStatus(int status) {
        this._status = status;
    }

    public String getReason() {
        if (this._reason != null) {
            return this._reason;
        }
        this._reason = (String)__statusMsg.get(TypeUtil.newInteger(this._status));
        if (this._reason == null) {
            this._reason = "unknown";
        }
        return this._reason;
    }

    public void setReason(String reason) {
        this._reason = reason;
    }

    public void setStatus(int code, String message) {
        this.setStatus(code);
        Integer code_integer = TypeUtil.newInteger(code);
        if (message == null) {
            message = (String)__statusMsg.get(code_integer);
            if (message == null) {
                message = "" + code;
            }
            this.setReason(message);
        } else {
            this.setReason(UrlEncoded.encodeString(message));
        }
    }

    public void sendError(int code, String message) throws IOException {
        this.setStatus(code, message);
        HttpRequest request = this.getHttpRequest();
        if (code != 204 && code != 304 && code != 206 && code >= 200) {
            Object o;
            if (this.getHttpContext() != null && (o = this.getHttpContext().getAttribute("org.browsermob.proxy.jetty.http.ErrorHandler")) != null && o instanceof HttpHandler) {
                ((HttpHandler)o).handle(request.getPath(), null, request, this);
            }
        } else if (code != 206) {
            this._header.remove("Content-Type");
            this._header.remove("Content-Length");
            this._characterEncoding = null;
            this._mimeType = null;
        }
        this.commit();
    }

    public void sendError(int code) throws IOException {
        this.sendError(code, null);
    }

    public void sendRedirect(String location) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Commited");
        }
        this._header.put("Location", location);
        this.setStatus(302);
        this.commit();
    }

    public void addSetCookie(String name, String value) {
        this._header.addSetCookie(new Cookie(name, value));
    }

    public void addSetCookie(Cookie cookie) {
        this._header.addSetCookie(cookie);
    }

    public void completing() {
        this.getHttpConnection().completing();
    }

    public void commit() throws IOException {
        if (!this.isCommitted()) {
            this.getOutputStream().flush();
        }
        this.getHttpConnection().commit();
    }

    @Override
    void recycle(HttpConnection connection) {
        super.recycle(connection);
        this._status = 200;
        this._reason = null;
        this._httpContext = null;
    }

    @Override
    public void destroy() {
        this._reason = null;
        super.destroy();
    }

    static {
        try {
            Field[] fields = HttpResponse.class.getDeclaredFields();
            int f = fields.length;
            while (f-- > 0) {
                int m = fields[f].getModifiers();
                String name = fields[f].getName();
                if (!Modifier.isFinal(m) || !Modifier.isStatic(m) || !fields[f].getType().equals(Integer.TYPE) || !name.startsWith("__") || !Character.isDigit(name.charAt(2))) continue;
                String message = name.substring(6);
                message = message.replace('_', ' ');
                __statusMsg.put(fields[f].get(null), message);
            }
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
        try {
            __Continue = "HTTP/1.1 100 Continue\r\n\r\n".getBytes(StringUtil.__ISO_8859_1);
        }
        catch (Exception e) {
            log.fatal((Object)e);
            System.exit(1);
        }
    }
}

