/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.HostNameResolver;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.browsermob.proxy.http.SimulatedSocket;

public class SimulatedSocketFactory
implements SocketFactory {
    private final HostNameResolver nameResolver;
    private long downstreamKbps;
    private long upstreamKbps;
    private long latency;

    public SimulatedSocketFactory(HostNameResolver nameResolver) {
        this.nameResolver = nameResolver;
    }

    public Socket createSocket() {
        return new SimulatedSocket(new Socket(), this.downstreamKbps, this.upstreamKbps, this.latency);
    }

    public Socket connectSocket(Socket sock, String host, int port, InetAddress localAddress, int localPort, HttpParams params) throws IOException {
        if (host == null) {
            throw new IllegalArgumentException("Target host may not be null.");
        }
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null.");
        }
        if (sock == null) {
            sock = this.createSocket();
        }
        if (localAddress != null || localPort > 0) {
            if (localPort < 0) {
                localPort = 0;
            }
            InetSocketAddress isa = new InetSocketAddress(localAddress, localPort);
            sock.bind(isa);
        }
        int timeout = HttpConnectionParams.getConnectionTimeout((HttpParams)params);
        InetSocketAddress remoteAddress = this.nameResolver != null ? new InetSocketAddress(this.nameResolver.resolve(host), port) : new InetSocketAddress(host, port);
        try {
            sock.connect(remoteAddress, timeout);
        }
        catch (SocketTimeoutException ex) {
            throw new ConnectTimeoutException("Connect to " + remoteAddress + " timed out");
        }
        return new SimulatedSocket(sock, this.downstreamKbps, this.upstreamKbps, this.latency);
    }

    public final boolean isSecure(Socket sock) throws IllegalArgumentException {
        if (sock == null) {
            throw new IllegalArgumentException("Socket may not be null.");
        }
        if (sock.isClosed()) {
            throw new IllegalArgumentException("Socket is closed.");
        }
        return false;
    }

    public void setDownstreamKbps(long downstreamKbps) {
        this.downstreamKbps = downstreamKbps;
    }

    public void setUpstreamKbps(long upstreamKbps) {
        this.upstreamKbps = upstreamKbps;
    }

    public void setLatency(long latency) {
        this.latency = latency;
    }
}

