/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy.http;

import cz.mallat.uasparser.CachingOnlineUpdateUASparser;
import cz.mallat.uasparser.UserAgentInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.browsermob.core.har.Har;
import org.browsermob.core.har.HarCookie;
import org.browsermob.core.har.HarEntry;
import org.browsermob.core.har.HarNameValuePair;
import org.browsermob.core.har.HarNameVersion;
import org.browsermob.core.har.HarRequest;
import org.browsermob.core.har.HarResponse;
import org.browsermob.core.har.HarTimings;
import org.browsermob.proxy.http.BadURIException;
import org.browsermob.proxy.http.BrowserMobHostNameResolver;
import org.browsermob.proxy.http.BrowserMobHttpRequest;
import org.browsermob.proxy.http.BrowserMobHttpResponse;
import org.browsermob.proxy.http.HttpClientInterrupter;
import org.browsermob.proxy.http.RequestCallback;
import org.browsermob.proxy.http.RequestCookiesInterceptor;
import org.browsermob.proxy.http.RequestInfo;
import org.browsermob.proxy.http.ResponseCookiesInterceptor;
import org.browsermob.proxy.http.SimulatedSocketFactory;
import org.browsermob.proxy.http.TrustingSSLSocketFactory;
import org.browsermob.proxy.http.WildcardMatchingCredentialsProvider;
import org.browsermob.proxy.util.CappedByteArrayOutputStream;
import org.browsermob.proxy.util.Log;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.UrlEncoded;
import org.xbill.DNS.Cache;

public class BrowserMobHttpClient {
    private static final int BUFFER = 4096;
    private static final Log LOG = new Log();
    private Har har;
    private String harPageRef;
    private boolean captureHeaders;
    private boolean captureContent;
    private SimulatedSocketFactory socketFactory;
    private TrustingSSLSocketFactory sslSocketFactory;
    private ThreadSafeClientConnManager httpClientConnMgr;
    private DefaultHttpClient httpClient;
    private List<BlacklistEntry> blacklistEntries = null;
    private WhitelistEntry whitelistEntry = null;
    private List<RewriteRule> rewriteRules = new CopyOnWriteArrayList<RewriteRule>();
    private HashMap<String, String> additionalHeaders = new HashMap();
    private int requestTimeout;
    private AtomicBoolean allowNewRequests = new AtomicBoolean(true);
    private BrowserMobHostNameResolver hostNameResolver;
    private boolean decompress = true;
    private final Set<ActiveRequest> activeRequests = new HashSet<ActiveRequest>();
    private WildcardMatchingCredentialsProvider credsProvider;
    private boolean shutdown = false;
    private AuthType authType;
    private boolean followRedirects = true;
    private static final int MAX_REDIRECT = 10;

    public BrowserMobHttpClient() {
        BasicHttpParams params = new BasicHttpParams();
        ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)30);
        ConnPerRouteBean connPerRoute = new ConnPerRouteBean(6);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)connPerRoute);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        this.hostNameResolver = new BrowserMobHostNameResolver(new Cache(255));
        this.socketFactory = new SimulatedSocketFactory(this.hostNameResolver);
        schemeRegistry.register(new Scheme("http", (SocketFactory)this.socketFactory, 80));
        TrustingSSLSocketFactory sslSocketFactory = this.sslSocketFactory = new TrustingSSLSocketFactory(this.hostNameResolver);
        sslSocketFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        schemeRegistry.register(new Scheme("https", (SocketFactory)sslSocketFactory, 443));
        this.httpClientConnMgr = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry){

            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                final ClientConnectionRequest wrapped = super.requestConnection(route, state);
                return new ClientConnectionRequest(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public ManagedClientConnection getConnection(long timeout, TimeUnit tunit) throws InterruptedException, ConnectionPoolTimeoutException {
                        Date start = new Date();
                        try {
                            ManagedClientConnection managedClientConnection = wrapped.getConnection(timeout, tunit);
                            return managedClientConnection;
                        }
                        finally {
                            RequestInfo.get().blocked(start, new Date());
                        }
                    }

                    public void abortRequest() {
                        wrapped.abortRequest();
                    }
                };
            }
        };
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)this.httpClientConnMgr, (HttpParams)params){

            protected HttpRequestExecutor createRequestExecutor() {
                return new HttpRequestExecutor(){

                    protected HttpResponse doSendRequest(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
                        Date start = new Date();
                        HttpResponse response = super.doSendRequest(request, conn, context);
                        RequestInfo.get().send(start, new Date());
                        return response;
                    }

                    protected HttpResponse doReceiveResponse(HttpRequest request, HttpClientConnection conn, HttpContext context) throws HttpException, IOException {
                        Date start = new Date();
                        HttpResponse response = super.doReceiveResponse(request, conn, context);
                        RequestInfo.get().wait(start, new Date());
                        return response;
                    }
                };
            }
        };
        this.credsProvider = new WildcardMatchingCredentialsProvider();
        this.httpClient.setCredentialsProvider((CredentialsProvider)this.credsProvider);
        this.httpClient.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuth(), 0);
        this.httpClient.getParams().setParameter("http.protocol.handle-redirects", (Object)true);
        this.httpClient.getParams().setParameter("http.protocol.single-cookie-header", (Object)Boolean.TRUE);
        this.setRetryCount(0);
        this.httpClient.getParams().setParameter("http.protocol.handle-redirects", (Object)false);
        HttpClientInterrupter.watch(this);
        this.setConnectionTimeout(60000);
        this.setSocketOperationTimeout(60000);
        this.setRequestTimeout(-1);
    }

    public void setRetryCount(int count) {
        this.httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(count, false));
    }

    public void remapHost(String source, String target) {
        this.hostNameResolver.remap(source, target);
    }

    public void addRequestInterceptor(HttpRequestInterceptor i) {
        this.httpClient.addRequestInterceptor(i);
    }

    public void addResponseInterceptor(HttpResponseInterceptor i) {
        this.httpClient.addResponseInterceptor(i);
    }

    public void createCookie(String name, String value, String domain) {
        this.createCookie(name, value, domain, null);
    }

    public void createCookie(String name, String value, String domain, String path) {
        BasicClientCookie cookie = new BasicClientCookie(name, value);
        cookie.setDomain(domain);
        if (path != null) {
            cookie.setPath(path);
        }
        this.httpClient.getCookieStore().addCookie((Cookie)cookie);
    }

    public void clearCookies() {
        this.httpClient.getCookieStore().clear();
    }

    public Cookie getCookie(String name) {
        return this.getCookie(name, null, null);
    }

    public Cookie getCookie(String name, String domain) {
        return this.getCookie(name, domain, null);
    }

    public Cookie getCookie(String name, String domain, String path) {
        for (Cookie cookie : this.httpClient.getCookieStore().getCookies()) {
            if (!cookie.getName().equals(name) || domain != null && !domain.equals(cookie.getDomain()) || path != null && !path.equals(cookie.getPath())) continue;
            return cookie;
        }
        return null;
    }

    public BrowserMobHttpRequest newPost(String url) {
        try {
            URI uri = this.makeUri(url);
            return new BrowserMobHttpRequest((HttpRequestBase)new HttpPost(uri), this, -1, this.captureContent);
        }
        catch (URISyntaxException e) {
            throw this.reportBadURI(url, "POST");
        }
    }

    public BrowserMobHttpRequest newGet(String url) {
        try {
            URI uri = this.makeUri(url);
            return new BrowserMobHttpRequest((HttpRequestBase)new HttpGet(uri), this, -1, this.captureContent);
        }
        catch (URISyntaxException e) {
            throw this.reportBadURI(url, "GET");
        }
    }

    public BrowserMobHttpRequest newPut(String url) {
        try {
            URI uri = this.makeUri(url);
            return new BrowserMobHttpRequest((HttpRequestBase)new HttpPut(uri), this, -1, this.captureContent);
        }
        catch (Exception e) {
            throw this.reportBadURI(url, "PUT");
        }
    }

    public BrowserMobHttpRequest newDelete(String url) {
        try {
            URI uri = this.makeUri(url);
            return new BrowserMobHttpRequest((HttpRequestBase)new HttpDelete(uri), this, -1, this.captureContent);
        }
        catch (URISyntaxException e) {
            throw this.reportBadURI(url, "DELETE");
        }
    }

    public BrowserMobHttpRequest newOptions(String url) {
        try {
            URI uri = this.makeUri(url);
            return new BrowserMobHttpRequest((HttpRequestBase)new HttpOptions(uri), this, -1, this.captureContent);
        }
        catch (URISyntaxException e) {
            throw this.reportBadURI(url, "OPTIONS");
        }
    }

    public BrowserMobHttpRequest newHead(String url) {
        try {
            URI uri = this.makeUri(url);
            return new BrowserMobHttpRequest((HttpRequestBase)new HttpHead(uri), this, -1, this.captureContent);
        }
        catch (URISyntaxException e) {
            throw this.reportBadURI(url, "HEAD");
        }
    }

    private URI makeUri(String url) throws URISyntaxException {
        url = url.replace(" ", "%20");
        url = url.replace(">", "%3C");
        url = url.replace("<", "%3E");
        url = url.replace("#", "%23");
        url = url.replace("{", "%7B");
        url = url.replace("}", "%7D");
        url = url.replace("|", "%7C");
        url = url.replace("\\", "%5C");
        url = url.replace("^", "%5E");
        url = url.replace("~", "%7E");
        url = url.replace("[", "%5B");
        url = url.replace("]", "%5D");
        url = url.replace("`", "%60");
        URI uri = new URI(url = url.replace("\"", "%22"));
        if (uri.getPort() == 80 && "http".equals(uri.getScheme()) || uri.getPort() == 443 && "https".equals(uri.getScheme())) {
            StringBuilder sb = new StringBuilder(uri.getScheme()).append("://");
            if (uri.getRawUserInfo() != null) {
                sb.append(uri.getRawUserInfo()).append("@");
            }
            sb.append(uri.getHost());
            if (uri.getRawPath() != null) {
                sb.append(uri.getRawPath());
            }
            if (uri.getRawQuery() != null) {
                sb.append("?").append(uri.getRawQuery());
            }
            if (uri.getRawFragment() != null) {
                sb.append("#").append(uri.getRawFragment());
            }
            uri = new URI(sb.toString());
        }
        return uri;
    }

    private RuntimeException reportBadURI(String url, String method) {
        if (this.har != null && this.harPageRef != null) {
            HarEntry entry = new HarEntry(this.harPageRef);
            entry.setTime(0L);
            entry.setRequest(new HarRequest(method, url, "HTTP/1.1"));
            entry.setResponse(new HarResponse(-998, "Bad URI", "HTTP/1.1"));
            entry.setTimings(new HarTimings());
            this.har.getLog().addEntry(entry);
        }
        throw new BadURIException("Bad URI requested: " + url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTimeout() {
        Set<ActiveRequest> set = this.activeRequests;
        synchronized (set) {
            for (ActiveRequest activeRequest : this.activeRequests) {
                activeRequest.checkTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrowserMobHttpResponse execute(BrowserMobHttpRequest req) {
        if (!this.allowNewRequests.get()) {
            throw new RuntimeException("No more requests allowed");
        }
        BrowserMobHttpResponse browserMobHttpResponse = this.execute(req, 1);
        return browserMobHttpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private BrowserMobHttpResponse execute(BrowserMobHttpRequest req, int depth) {
        void var11_28;
        List cookies;
        Set<ActiveRequest> v22;
        String query;
        Header[] uaHeaders;
        if (depth >= 10) {
            throw new IllegalStateException("Max number of redirects (10) reached");
        }
        RequestCallback callback = req.getRequestCallback();
        HttpRequestBase method = req.getMethod();
        String verificationText = req.getVerificationText();
        String url = method.getURI().toString();
        if (this.har != null && this.har.getLog().getBrowser() == null && (uaHeaders = method.getHeaders("User-Agent")) != null && uaHeaders.length > 0) {
            String userAgent = uaHeaders[0].getValue();
            try {
                CachingOnlineUpdateUASparser p = new CachingOnlineUpdateUASparser();
                UserAgentInfo uai = p.parse(userAgent);
                String string = uai.getUaName();
                int lastSpace = string.lastIndexOf(32);
                String browser = string.substring(0, lastSpace);
                String version = string.substring(lastSpace + 1);
                this.har.getLog().setBrowser(new HarNameVersion(browser, version));
            }
            catch (IOException e) {
            }
            catch (Exception e) {
                LOG.warn("Failed to parse user agent string", e);
            }
        }
        boolean rewrote = false;
        String newUrl = url;
        for (RewriteRule rule : this.rewriteRules) {
            Matcher matcher = rule.match.matcher(newUrl);
            newUrl = matcher.replaceAll(rule.replace);
            rewrote = true;
        }
        if (rewrote) {
            try {
                method.setURI(new URI(newUrl));
                url = newUrl;
            }
            catch (URISyntaxException e) {
                LOG.warn("Could not rewrite url to %s", newUrl);
            }
        }
        int mockResponseCode = -1;
        if (this.whitelistEntry != null) {
            boolean found = false;
            for (Pattern pattern : this.whitelistEntry.patterns) {
                if (!pattern.matcher(url).matches()) continue;
                found = true;
                break;
            }
            if (!found) {
                mockResponseCode = this.whitelistEntry.responseCode;
            }
        }
        if (this.blacklistEntries != null) {
            for (BlacklistEntry blacklistEntry : this.blacklistEntries) {
                if (!blacklistEntry.pattern.matcher(url).matches()) continue;
                mockResponseCode = blacklistEntry.responseCode;
                break;
            }
        }
        if (!this.additionalHeaders.isEmpty()) {
            for (Map.Entry entry : this.additionalHeaders.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                method.removeHeaders(key);
                method.addHeader(key, value);
            }
        }
        String charSet = "UTF-8";
        Object var11_26 = null;
        InputStream is = null;
        int statusCode = -998;
        long bytes = 0L;
        boolean contentMatched = true;
        OutputStream os = req.getOutputStream();
        if (os == null) {
            os = new CappedByteArrayOutputStream(0x100000);
        }
        if (verificationText != null) {
            contentMatched = false;
        }
        Date start = new Date();
        RequestInfo.clear(url);
        HarEntry entry = new HarEntry(this.harPageRef);
        entry.setRequest(new HarRequest(method.getMethod(), url, method.getProtocolVersion().getProtocol()));
        entry.setResponse(new HarResponse(-999, "NO RESPONSE", method.getProtocolVersion().getProtocol()));
        if (this.har != null && this.harPageRef != null) {
            this.har.getLog().addEntry(entry);
        }
        if ((query = method.getURI().getQuery()) != null) {
            MultiMap params = new MultiMap();
            UrlEncoded.decodeTo((String)query, (MultiMap)params, (String)"UTF-8");
            for (String k : params.keySet()) {
                for (Set<ActiveRequest> v22 : params.getValues((Object)k)) {
                    entry.getRequest().getQueryString().add(new HarNameValuePair(k, (String)((Object)v22)));
                }
            }
        }
        String errorMessage = null;
        HttpResponse response = null;
        BasicHttpContext ctx = new BasicHttpContext();
        ActiveRequest activeRequest = new ActiveRequest(method, ctx, entry.getStartedDateTime());
        v22 = this.activeRequests;
        synchronized (v22) {
            this.activeRequests.add(activeRequest);
        }
        if (this.authType != AuthType.NTLM && this.authType == AuthType.BASIC) {
            ctx.setAttribute("preemptive-auth", (Object)new BasicScheme());
        }
        StatusLine statusLine = null;
        try {
            if (method.getHeaders("User-Agent").length == 0) {
                method.addHeader("User-Agent", "BrowserMob VU/1.0");
            }
            if (mockResponseCode != -1) {
                statusCode = mockResponseCode;
                callback.handleHeaders(new Header[]{new Header(){

                    public String getName() {
                        return "Content-Type";
                    }

                    public String getValue() {
                        return "text/plain";
                    }

                    public HeaderElement[] getElements() throws ParseException {
                        return new HeaderElement[0];
                    }
                }});
            } else {
                response = this.httpClient.execute((HttpUriRequest)method, (HttpContext)ctx);
                statusLine = response.getStatusLine();
                statusCode = statusLine.getStatusCode();
                if (callback != null) {
                    callback.handleStatusLine(statusLine);
                    callback.handleHeaders(response.getAllHeaders());
                }
                if (response.getEntity() != null) {
                    is = response.getEntity().getContent();
                }
                if (is != null) {
                    Header contentEncodingHeader;
                    if (this.decompress && (contentEncodingHeader = response.getFirstHeader("Content-Encoding")) != null && "gzip".equalsIgnoreCase(contentEncodingHeader.getValue())) {
                        is = new GZIPInputStream(is);
                    }
                    bytes = BrowserMobHttpClient.copyWithStats(is, os);
                }
            }
        }
        catch (Exception e) {
            errorMessage = e.toString();
            if (callback != null) {
                callback.reportError(e);
            }
            if (!this.shutdown) {
                LOG.info(String.format("%s when requesting %s", errorMessage, url), new Object[0]);
            }
        }
        finally {
            Set<ActiveRequest> e = this.activeRequests;
            synchronized (e) {
                this.activeRequests.remove(activeRequest);
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e2) {}
            }
        }
        RequestInfo.get().finish();
        entry.setStartedDateTime(RequestInfo.get().getStart());
        entry.setTimings(RequestInfo.get().getTimings());
        entry.setServerIPAddress(RequestInfo.get().getResolvedAddress());
        entry.setTime(RequestInfo.get().getTotalTime());
        entry.getResponse().setBodySize(bytes);
        entry.getResponse().getContent().setSize(bytes);
        entry.getResponse().setStatus(statusCode);
        if (statusLine != null) {
            entry.getResponse().setStatusText(statusLine.getReasonPhrase());
        }
        boolean urlEncoded = false;
        if (this.captureHeaders || this.captureContent) {
            for (Header header : method.getAllHeaders()) {
                if (header.getValue() != null && header.getValue().startsWith("application/x-www-form-urlencoded")) {
                    urlEncoded = true;
                }
                entry.getRequest().getHeaders().add(new HarNameValuePair(header.getName(), header.getValue()));
            }
            if (response != null) {
                for (Header header : response.getAllHeaders()) {
                    entry.getResponse().getHeaders().add(new HarNameValuePair(header.getName(), header.getValue()));
                }
            }
        }
        if ((cookies = (List)ctx.getAttribute("browsermob.http.request.cookies")) != null) {
            for (Cookie c : cookies) {
                HarCookie hc = this.toHarCookie(c);
                entry.getRequest().getCookies().add(hc);
            }
        }
        String contentType = null;
        if (response != null) {
            try {
                Header contentTypeHdr = response.getFirstHeader("Content-Type");
                if (contentTypeHdr != null) {
                    contentType = contentTypeHdr.getValue();
                    NameValuePair nvp = contentTypeHdr.getElements()[0].getParameterByName("charset");
                    if (nvp != null) {
                        charSet = nvp.getValue();
                    }
                }
                if (os instanceof ByteArrayOutputStream) {
                    String string = ((ByteArrayOutputStream)os).toString(charSet);
                    if (verificationText != null) {
                        contentMatched = string.contains(verificationText);
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            cookies = (List)ctx.getAttribute("browsermob.http.response.cookies");
            if (cookies != null) {
                for (Cookie c : cookies) {
                    HarCookie hc = this.toHarCookie(c);
                    entry.getResponse().getCookies().add(hc);
                }
            }
        }
        if (contentType != null) {
            entry.getResponse().getContent().setMimeType(contentType);
        }
        boolean isRedirect = false;
        String location = null;
        if (response != null && statusCode >= 300 && statusCode < 400 && statusCode != 304) {
            isRedirect = true;
            Header locationHeader = response.getLastHeader("location");
            if (locationHeader != null) {
                location = locationHeader.getValue();
            } else if (this.followRedirects) {
                throw new RuntimeException("Invalid redirect - missing location header");
            }
        }
        int expectedStatusCode = req.getExpectedStatusCode();
        if (mockResponseCode == -1 && expectedStatusCode > -1) {
            if (this.followRedirects) {
                throw new RuntimeException("Response validation cannot be used while following redirects");
            }
            if (expectedStatusCode != statusCode) {
                if (isRedirect) {
                    throw new RuntimeException("Expected status code of " + expectedStatusCode + " but saw " + statusCode + " redirecting to: " + location);
                }
                throw new RuntimeException("Expected status code of " + expectedStatusCode + " but saw " + statusCode);
            }
        }
        if (isRedirect && req.getExpectedLocation() != null) {
            if (this.followRedirects) {
                throw new RuntimeException("Response validation cannot be used while following redirects");
            }
            if (location.compareTo(req.getExpectedLocation()) != 0) {
                throw new RuntimeException("Expected a redirect to  " + req.getExpectedLocation() + " but saw " + location);
            }
        }
        if (isRedirect && this.followRedirects) {
            try {
                URI redirectUri = new URI(location);
                URI newUri = method.getURI().resolve(redirectUri);
                method.setURI(newUri);
                return this.execute(req, ++depth);
            }
            catch (URISyntaxException e) {
                LOG.warn("Could not parse URL", e);
            }
        }
        return new BrowserMobHttpResponse(entry, method, response, contentMatched, verificationText, errorMessage, (String)var11_28, contentType, charSet);
    }

    public void shutdown() {
        this.shutdown = true;
        this.abortActiveRequests();
        this.rewriteRules.clear();
        this.credsProvider.clear();
        this.httpClientConnMgr.shutdown();
        HttpClientInterrupter.release(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortActiveRequests() {
        this.allowNewRequests.set(true);
        Set<ActiveRequest> set = this.activeRequests;
        synchronized (set) {
            for (ActiveRequest activeRequest : this.activeRequests) {
                activeRequest.abort();
            }
            this.activeRequests.clear();
        }
    }

    public void setHar(Har har) {
        this.har = har;
    }

    public void setHarPageRef(String harPageRef) {
        this.harPageRef = harPageRef;
    }

    public void setDownstreamKbps(long downstreamKbps) {
        this.socketFactory.setDownstreamKbps(downstreamKbps);
        this.sslSocketFactory.setDownstreamKbps(downstreamKbps);
    }

    public void setUpstreamKbps(long upstreamKbps) {
        this.socketFactory.setUpstreamKbps(upstreamKbps);
        this.sslSocketFactory.setUpstreamKbps(upstreamKbps);
    }

    public void setLatency(long latency) {
        this.socketFactory.setLatency(latency);
        this.sslSocketFactory.setLatency(latency);
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public void setSocketOperationTimeout(int readTimeout) {
        this.httpClient.getParams().setIntParameter("http.socket.timeout", readTimeout);
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.httpClient.getParams().setIntParameter("http.connection.timeout", connectionTimeout);
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void autoBasicAuthorization(String domain, String username, String password) {
        this.authType = AuthType.BASIC;
        this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(domain, -1), (Credentials)new UsernamePasswordCredentials(username, password));
    }

    public void autoNTLMAuthorization(String domain, String username, String password) {
        this.authType = AuthType.NTLM;
        this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(domain, -1), (Credentials)new NTCredentials(username, password, "workstation", domain));
    }

    public void rewriteUrl(String match, String replace) {
        this.rewriteRules.add(new RewriteRule(match, replace));
    }

    public void blacklistRequest(String pattern, int responseCode) {
        this.blacklistRequests(pattern, responseCode);
    }

    public void blacklistRequests(String pattern, int responseCode) {
        if (this.blacklistEntries == null) {
            this.blacklistEntries = new CopyOnWriteArrayList<BlacklistEntry>();
        }
        this.blacklistEntries.add(new BlacklistEntry(pattern, responseCode));
    }

    public void whitelistRequests(String[] patterns, int responseCode) {
        this.whitelistEntry = new WhitelistEntry(patterns, responseCode);
    }

    public void addHeader(String name, String value) {
        this.additionalHeaders.put(name, value);
    }

    public void prepareForBrowser() {
        this.httpClient.addRequestInterceptor((HttpRequestInterceptor)new RequestCookiesInterceptor());
        this.httpClient.addResponseInterceptor((HttpResponseInterceptor)new ResponseCookiesInterceptor());
        this.decompress = false;
        this.setFollowRedirects(false);
    }

    public String remappedHost(String host) {
        return this.hostNameResolver.remapping(host);
    }

    public List<String> originalHosts(String host) {
        return this.hostNameResolver.original(host);
    }

    public Har getHar() {
        return this.har;
    }

    public void setCaptureHeaders(boolean captureHeaders) {
        this.captureHeaders = captureHeaders;
    }

    public void setCaptureContent(boolean captureContent) {
        this.captureContent = captureContent;
    }

    public void setHttpProxy(String httpProxy) {
        String host = httpProxy.split(":")[0];
        Integer port = Integer.parseInt(httpProxy.split(":")[1]);
        HttpHost proxy = new HttpHost(host, port.intValue());
        this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
    }

    private HarCookie toHarCookie(Cookie c) {
        HarCookie hc = new HarCookie();
        hc.setName(c.getName());
        hc.setPath(c.getPath());
        hc.setValue(c.getValue());
        hc.setDomain(c.getDomain());
        hc.setExpires(c.getExpiryDate());
        return hc;
    }

    public void clearDNSCache() {
        this.hostNameResolver.clearCache();
    }

    public void setDNSCacheTimeout(int timeout) {
        this.hostNameResolver.setCacheTimeout(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyWithStats(InputStream is, OutputStream os) throws IOException {
        long bytesCopied = 0L;
        byte[] buffer = new byte[4096];
        try {
            int length;
            int firstByte = is.read();
            if (firstByte == -1) {
                long l = 0L;
                return l;
            }
            os.write(firstByte);
            ++bytesCopied;
            do {
                if ((length = is.read(buffer, 0, 4096)) == -1) continue;
                bytesCopied += (long)length;
                os.write(buffer, 0, length);
                os.flush();
            } while (length != -1);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
            try {
                os.close();
            }
            catch (IOException e) {}
        }
        return bytesCopied;
    }

    private static enum AuthType {
        NONE,
        BASIC,
        NTLM;

    }

    private class RewriteRule {
        private Pattern match;
        private String replace;

        private RewriteRule(String match, String replace) {
            this.match = Pattern.compile(match);
            this.replace = replace;
        }
    }

    private class BlacklistEntry {
        private Pattern pattern;
        private int responseCode;

        private BlacklistEntry(String pattern, int responseCode) {
            this.pattern = Pattern.compile(pattern);
            this.responseCode = responseCode;
        }
    }

    private class WhitelistEntry {
        private List<Pattern> patterns = new CopyOnWriteArrayList<Pattern>();
        private int responseCode;

        private WhitelistEntry(String[] patterns, int responseCode) {
            for (String pattern : patterns) {
                this.patterns.add(Pattern.compile(pattern));
            }
            this.responseCode = responseCode;
        }
    }

    class ActiveRequest {
        HttpRequestBase request;
        BasicHttpContext ctx;
        Date start;

        ActiveRequest(HttpRequestBase request, BasicHttpContext ctx, Date start) {
            this.request = request;
            this.ctx = ctx;
            this.start = start;
        }

        void checkTimeout() {
            if (BrowserMobHttpClient.this.requestTimeout != -1 && this.request != null && this.start != null && new Date(System.currentTimeMillis() - (long)BrowserMobHttpClient.this.requestTimeout).after(this.start)) {
                LOG.info("Aborting request to %s after it failed to complete in %d ms", this.request.getURI().toString(), BrowserMobHttpClient.this.requestTimeout);
                this.abort();
            }
        }

        public void abort() {
            this.request.abort();
            HttpConnection conn = (HttpConnection)this.ctx.getAttribute("http.connection");
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static class PreemptiveAuth
    implements HttpRequestInterceptor {
        PreemptiveAuth() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                Credentials creds;
                AuthScheme authScheme = (AuthScheme)context.getAttribute("preemptive-auth");
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                if (authScheme != null && (creds = credsProvider.getCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()))) != null) {
                    authState.setAuthScheme(authScheme);
                    authState.setCredentials(creds);
                }
            }
        }
    }
}

