/*
 * Decompiled with CFR 0.152.
 */
package cz.mallat.uasparser;

import cz.mallat.uasparser.UserAgentInfo;
import cz.mallat.uasparser.Utils;
import java.util.Iterator;
import java.util.List;

class BrowserEntry {
    private Long type;
    private String family;
    private String name;
    private String url;
    private String company;
    private String companyUrl;
    private String ico;
    private String infoUrl;

    public BrowserEntry(List<String> data) {
        Iterator<String> it = data.iterator();
        this.type = Long.parseLong(it.next());
        this.family = it.next();
        this.url = it.next();
        this.company = it.next();
        this.companyUrl = it.next();
        this.ico = it.next();
        this.infoUrl = it.next();
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public Long getType() {
        return this.type;
    }

    public void setType(Long type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getCompanyUrl() {
        return this.companyUrl;
    }

    public void setCompanyUrl(String companyUrl) {
        this.companyUrl = companyUrl;
    }

    public String getIco() {
        return this.ico;
    }

    public void setIco(String ico) {
        this.ico = ico;
    }

    public String getInfoUrl() {
        return this.infoUrl;
    }

    public void setInfoUrl(String infoUrl) {
        this.infoUrl = infoUrl;
    }

    public void copyTo(UserAgentInfo uai, String browserVersionInfo) {
        if (Utils.validString(this.getFamily())) {
            uai.setUaFamily(this.getFamily());
            uai.setUaName(uai.getUaFamily() + (browserVersionInfo != null && !browserVersionInfo.isEmpty() ? " " + browserVersionInfo : ""));
        }
        if (Utils.validString(this.getUrl())) {
            uai.setUaUrl(this.getUrl());
        }
        if (Utils.validString(this.getCompany())) {
            uai.setUaCompany(this.getCompany());
        }
        if (Utils.validString(this.getCompanyUrl())) {
            uai.setUaCompanyUrl(this.getCompanyUrl());
        }
        if (Utils.validString(this.getIco())) {
            uai.setUaIcon(this.getIco());
        }
        if (Utils.validString(this.getInfoUrl())) {
            uai.setUaInfoUrl("http://user-agent-string.info" + this.getInfoUrl());
        }
    }
}

