/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.utilint.DbLsn;

public class EnvironmentStats {
    private int splitBins;
    private int dbClosedBins;
    private int cursorsBins;
    private int nonEmptyBins;
    private int processedBins;
    private int inCompQueueSize;
    private int nEvictPasses;
    private long nNodesSelected;
    private long nNodesScanned;
    private long nNodesExplicitlyEvicted;
    private long nBINsStripped;
    private long requiredEvictBytes;
    private int nCheckpoints;
    private long lastCheckpointId;
    private int nFullINFlush;
    private int nFullBINFlush;
    private int nDeltaINFlush;
    private long lastCheckpointStart;
    private long lastCheckpointEnd;
    private int nCleanerRuns;
    private int nCleanerDeletions;
    private int nINsCleaned;
    private int nINsMigrated;
    private int nLNsCleaned;
    private int nLNsDead;
    private int nLNsLocked;
    private int nLNsMigrated;
    private int nDeltasCleaned;
    private int nCleanerEntriesRead;
    private long cacheDataBytes;
    private long nNotResident;
    private long nCacheMiss;
    private int nLogBuffers;
    private long bufferBytes;
    private long nFSyncs;
    private long nFSyncRequests;
    private long nFSyncTimeouts;
    private long nRepeatFaultReads;
    private long nRepeatIteratorReads;

    public EnvironmentStats() {
        this.reset();
    }

    private void reset() {
        this.splitBins = 0;
        this.dbClosedBins = 0;
        this.cursorsBins = 0;
        this.nonEmptyBins = 0;
        this.processedBins = 0;
        this.inCompQueueSize = 0;
        this.nEvictPasses = 0;
        this.nNodesSelected = 0L;
        this.nNodesScanned = 0L;
        this.nNodesExplicitlyEvicted = 0L;
        this.nBINsStripped = 0L;
        this.requiredEvictBytes = 0L;
        this.nCheckpoints = 0;
        this.lastCheckpointId = 0L;
        this.nFullINFlush = 0;
        this.nFullBINFlush = 0;
        this.nDeltaINFlush = 0;
        this.lastCheckpointStart = -1L;
        this.lastCheckpointEnd = -1L;
        this.nCleanerRuns = 0;
        this.nCleanerDeletions = 0;
        this.nINsCleaned = 0;
        this.nINsMigrated = 0;
        this.nLNsCleaned = 0;
        this.nLNsDead = 0;
        this.nLNsLocked = 0;
        this.nLNsMigrated = 0;
        this.nDeltasCleaned = 0;
        this.nCleanerEntriesRead = 0;
        this.cacheDataBytes = 0L;
        this.nNotResident = 0L;
        this.nCacheMiss = 0L;
        this.nLogBuffers = 0;
        this.bufferBytes = 0L;
        this.nFSyncs = 0L;
        this.nFSyncRequests = 0L;
        this.nFSyncTimeouts = 0L;
        this.nRepeatFaultReads = 0L;
        this.nRepeatIteratorReads = 0L;
    }

    public long getBufferBytes() {
        return this.bufferBytes;
    }

    public int getCursorsBins() {
        return this.cursorsBins;
    }

    public int getDbClosedBins() {
        return this.dbClosedBins;
    }

    public int getInCompQueueSize() {
        return this.inCompQueueSize;
    }

    public long getLastCheckpointId() {
        return this.lastCheckpointId;
    }

    public long getNCacheMiss() {
        return this.nCacheMiss;
    }

    public int getNCheckpoints() {
        return this.nCheckpoints;
    }

    public int getNCleanerRuns() {
        return this.nCleanerRuns;
    }

    public int getNCleanerDeletions() {
        return this.nCleanerDeletions;
    }

    public int getNDeltaINFlush() {
        return this.nDeltaINFlush;
    }

    public long getLastCheckpointEnd() {
        return this.lastCheckpointEnd;
    }

    public long getLastCheckpointStart() {
        return this.lastCheckpointStart;
    }

    public int getNDeltasCleaned() {
        return this.nDeltasCleaned;
    }

    public int getNCleanerEntriesRead() {
        return this.nCleanerEntriesRead;
    }

    public int getNEvictPasses() {
        return this.nEvictPasses;
    }

    public long getNFSyncs() {
        return this.nFSyncs;
    }

    public long getNFSyncRequests() {
        return this.nFSyncRequests;
    }

    public long getNFSyncTimeouts() {
        return this.nFSyncTimeouts;
    }

    public int getNFullINFlush() {
        return this.nFullINFlush;
    }

    public int getNFullBINFlush() {
        return this.nFullBINFlush;
    }

    public int getNINsCleaned() {
        return this.nINsCleaned;
    }

    public int getNINsMigrated() {
        return this.nINsMigrated;
    }

    public int getNLNsCleaned() {
        return this.nLNsCleaned;
    }

    public int getNLNsDead() {
        return this.nLNsDead;
    }

    public int getNLNsLocked() {
        return this.nLNsLocked;
    }

    public int getNLNsMigrated() {
        return this.nLNsMigrated;
    }

    public int getNLogBuffers() {
        return this.nLogBuffers;
    }

    public long getNNodesExplicitlyEvicted() {
        return this.nNodesExplicitlyEvicted;
    }

    public long getNBINsStripped() {
        return this.nBINsStripped;
    }

    public long getRequiredEvictBytes() {
        return this.requiredEvictBytes;
    }

    public long getNNodesScanned() {
        return this.nNodesScanned;
    }

    public long getNNodesSelected() {
        return this.nNodesSelected;
    }

    public long getCacheTotalBytes() {
        return this.cacheDataBytes + this.bufferBytes;
    }

    public long getCacheDataBytes() {
        return this.cacheDataBytes;
    }

    public long getNNotResident() {
        return this.nNotResident;
    }

    public int getNonEmptyBins() {
        return this.nonEmptyBins;
    }

    public int getProcessedBins() {
        return this.processedBins;
    }

    public long getNRepeatFaultReads() {
        return this.nRepeatFaultReads;
    }

    public long getNRepeatIteratorReads() {
        return this.nRepeatFaultReads;
    }

    public int getSplitBins() {
        return this.splitBins;
    }

    public void setCacheDataBytes(long cacheDataBytes) {
        this.cacheDataBytes = cacheDataBytes;
    }

    public void setNNotResident(long nNotResident) {
        this.nNotResident = nNotResident;
    }

    public void setNCacheMiss(long nCacheMiss) {
        this.nCacheMiss = nCacheMiss;
    }

    public void setNLogBuffers(int nLogBuffers) {
        this.nLogBuffers = nLogBuffers;
    }

    public void setBufferBytes(long bufferBytes) {
        this.bufferBytes = bufferBytes;
    }

    public void setCursorsBins(int val) {
        this.cursorsBins = val;
    }

    public void setDbClosedBins(int val) {
        this.dbClosedBins = val;
    }

    public void setInCompQueueSize(int val) {
        this.inCompQueueSize = val;
    }

    public void setLastCheckpointId(long l) {
        this.lastCheckpointId = l;
    }

    public void setNCheckpoints(int val) {
        this.nCheckpoints = val;
    }

    public void setNCleanerRuns(int val) {
        this.nCleanerRuns = val;
    }

    public void setNCleanerDeletions(int val) {
        this.nCleanerDeletions = val;
    }

    public void setNDeltaINFlush(int val) {
        this.nDeltaINFlush = val;
    }

    public void setLastCheckpointEnd(long lsn) {
        this.lastCheckpointEnd = lsn;
    }

    public void setLastCheckpointStart(long lsn) {
        this.lastCheckpointStart = lsn;
    }

    public void setNDeltasCleaned(int val) {
        this.nDeltasCleaned = val;
    }

    public void setNCleanerEntriesRead(int val) {
        this.nCleanerEntriesRead = val;
    }

    public void setNEvictPasses(int val) {
        this.nEvictPasses = val;
    }

    public void setNFSyncs(long val) {
        this.nFSyncs = val;
    }

    public void setNFSyncRequests(long val) {
        this.nFSyncRequests = val;
    }

    public void setNFSyncTimeouts(long val) {
        this.nFSyncTimeouts = val;
    }

    public void setNFullINFlush(int val) {
        this.nFullINFlush = val;
    }

    public void setNFullBINFlush(int val) {
        this.nFullBINFlush = val;
    }

    public void setNINsCleaned(int val) {
        this.nINsCleaned = val;
    }

    public void setNINsMigrated(int val) {
        this.nINsMigrated = val;
    }

    public void setNLNsCleaned(int val) {
        this.nLNsCleaned = val;
    }

    public void setNLNsDead(int val) {
        this.nLNsDead = val;
    }

    public void setNLNsLocked(int val) {
        this.nLNsLocked = val;
    }

    public void setNLNsMigrated(int val) {
        this.nLNsMigrated = val;
    }

    public void setNNodesExplicitlyEvicted(long l) {
        this.nNodesExplicitlyEvicted = l;
    }

    public void setRequiredEvictBytes(long l) {
        this.requiredEvictBytes = l;
    }

    public void setNBINsStripped(long l) {
        this.nBINsStripped = l;
    }

    public void setNNodesScanned(long l) {
        this.nNodesScanned = l;
    }

    public void setNNodesSelected(long l) {
        this.nNodesSelected = l;
    }

    public void setNonEmptyBins(int val) {
        this.nonEmptyBins = val;
    }

    public void setProcessedBins(int val) {
        this.processedBins = val;
    }

    public void setNRepeatFaultReads(long val) {
        this.nRepeatFaultReads = val;
    }

    public void setNRepeatIteratorReads(long val) {
        this.nRepeatIteratorReads = val;
    }

    public void setSplitBins(int val) {
        this.splitBins = val;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("splitBins=").append(this.splitBins).append('\n');
        sb.append("dbClosedBins=").append(this.dbClosedBins).append('\n');
        sb.append("cursorsBins=").append(this.cursorsBins).append('\n');
        sb.append("nonEmptyBins=").append(this.nonEmptyBins).append('\n');
        sb.append("processedBins=").append(this.processedBins).append('\n');
        sb.append("inCompQueueSize=").append(this.inCompQueueSize).append('\n');
        sb.append("nEvictPasses=").append(this.nEvictPasses).append('\n');
        sb.append("nNodesSelected=").append(this.nNodesSelected).append('\n');
        sb.append("nNodesScanned=").append(this.nNodesScanned).append('\n');
        sb.append("nNodesExplicitlyEvicted=").append(this.nNodesExplicitlyEvicted).append('\n');
        sb.append("nBINsStripped=").append(this.nBINsStripped).append('\n');
        sb.append("requiredEvictBytes=").append(this.requiredEvictBytes).append('\n');
        sb.append("nCheckpoints=").append(this.nCheckpoints).append('\n');
        sb.append("lastCheckpointId=").append(this.lastCheckpointId).append('\n');
        sb.append("nFullINFlush=").append(this.nFullINFlush).append('\n');
        sb.append("nFullBINFlush=").append(this.nFullBINFlush).append('\n');
        sb.append("nDeltaINFlush=").append(this.nDeltaINFlush).append('\n');
        sb.append("lastCheckpointStart=").append(DbLsn.getNoFormatString(this.lastCheckpointStart)).append('\n');
        sb.append("lastCheckpointEnd=").append(DbLsn.getNoFormatString(this.lastCheckpointEnd)).append('\n');
        sb.append("nCleanerRuns=").append(this.nCleanerRuns).append('\n');
        sb.append("nCleanerDeletions=").append(this.nCleanerDeletions).append('\n');
        sb.append("nINsCleaned=").append(this.nINsCleaned).append('\n');
        sb.append("nINsMigrated=").append(this.nINsMigrated).append('\n');
        sb.append("nLNsCleaned=").append(this.nLNsCleaned).append('\n');
        sb.append("nLNsDead=").append(this.nLNsDead).append('\n');
        sb.append("nLNsLocked=").append(this.nLNsLocked).append('\n');
        sb.append("nLNsMigrated=").append(this.nLNsMigrated).append('\n');
        sb.append("nDeltasCleaned=").append(this.nDeltasCleaned).append('\n');
        sb.append("nCleanerEntriesRead=").append(this.nCleanerEntriesRead).append('\n');
        sb.append("nNotResident=").append(this.nNotResident).append('\n');
        sb.append("nCacheMiss=").append(this.nCacheMiss).append('\n');
        sb.append("nLogBuffers=").append(this.nLogBuffers).append('\n');
        sb.append("bufferBytes=").append(this.bufferBytes).append('\n');
        sb.append("cacheDataBytes=").append(this.cacheDataBytes).append('\n');
        sb.append("cacheTotalBytes=").append(this.getCacheTotalBytes()).append('\n');
        sb.append("nFSyncs=").append(this.nFSyncs).append('\n');
        sb.append("nFSyncRequests=").append(this.nFSyncRequests).append('\n');
        sb.append("nFSyncTimeouts=").append(this.nFSyncTimeouts).append('\n');
        sb.append("nRepeatFaultReads=").append(this.nRepeatFaultReads).append('\n');
        sb.append("nRepeatIteratorReads=").append(this.nRepeatIteratorReads).append('\n');
        return sb.toString();
    }
}

